/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.PaymentIntent;
import com.chargebee.models.enums.AccountHolderType;
import com.chargebee.models.enums.AccountType;
import com.chargebee.models.enums.DirectDebitScheme;
import com.chargebee.models.enums.EcheckType;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.Type;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.models.enums.VoucherType;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class PaymentSource
extends Resource<PaymentSource> {
    public PaymentSource(String jsonStr) {
        super(jsonStr);
    }

    public PaymentSource(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public String referenceId() {
        return this.reqString("reference_id");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Gateway gateway() {
        return this.reqEnum("gateway", Gateway.class);
    }

    public String gatewayAccountId() {
        return this.optString("gateway_account_id");
    }

    public String ipAddress() {
        return this.optString("ip_address");
    }

    public String issuingCountry() {
        return this.optString("issuing_country");
    }

    public Card card() {
        return this.optSubResource("card", Card.class);
    }

    public BankAccount bankAccount() {
        return this.optSubResource("bank_account", BankAccount.class);
    }

    public CustVoucherSource boleto() {
        return this.optSubResource("boleto", CustVoucherSource.class);
    }

    public BillingAddress billingAddress() {
        return this.optSubResource("billing_address", BillingAddress.class);
    }

    public AmazonPayment amazonPayment() {
        return this.optSubResource("amazon_payment", AmazonPayment.class);
    }

    public Upi upi() {
        return this.optSubResource("upi", Upi.class);
    }

    public Paypal paypal() {
        return this.optSubResource("paypal", Paypal.class);
    }

    public Venmo venmo() {
        return this.optSubResource("venmo", Venmo.class);
    }

    public List<Mandate> mandates() {
        return this.optList("mandates", Mandate.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public String businessEntityId() {
        return this.optString("business_entity_id");
    }

    public static CreateUsingTempTokenRequest createUsingTempToken() {
        String uri = PaymentSource.uri("payment_sources", "create_using_temp_token");
        return new CreateUsingTempTokenRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateUsingPermanentTokenRequest createUsingPermanentToken() {
        String uri = PaymentSource.uri("payment_sources", "create_using_permanent_token");
        return new CreateUsingPermanentTokenRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateUsingTokenRequest createUsingToken() {
        String uri = PaymentSource.uri("payment_sources", "create_using_token");
        return new CreateUsingTokenRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateUsingPaymentIntentRequest createUsingPaymentIntent() {
        String uri = PaymentSource.uri("payment_sources", "create_using_payment_intent");
        return new CreateUsingPaymentIntentRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateVoucherPaymentSourceRequest createVoucherPaymentSource() {
        String uri = PaymentSource.uri("payment_sources", "create_voucher_payment_source");
        return new CreateVoucherPaymentSourceRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateCardRequest createCard() {
        String uri = PaymentSource.uri("payment_sources", "create_card");
        return new CreateCardRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateBankAccountRequest createBankAccount() {
        String uri = PaymentSource.uri("payment_sources", "create_bank_account");
        return new CreateBankAccountRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateCardRequest updateCard(String id) {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "update_card");
        return new UpdateCardRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateBankAccountRequest updateBankAccount(String id) {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "update_bank_account");
        return new UpdateBankAccountRequest(HttpUtil.Method.POST, uri);
    }

    public static VerifyBankAccountRequest verifyBankAccount(String id) {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "verify_bank_account");
        return new VerifyBankAccountRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static PaymentSourceListRequest list() {
        String uri = PaymentSource.uri("payment_sources");
        return new PaymentSourceListRequest(uri);
    }

    public static SwitchGatewayAccountRequest switchGatewayAccount(String id) {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "switch_gateway_account");
        return new SwitchGatewayAccountRequest(HttpUtil.Method.POST, uri);
    }

    public static ExportPaymentSourceRequest exportPaymentSource(String id) {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "export_payment_source");
        return new ExportPaymentSourceRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request deleteLocal(String id) {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "delete_local");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class ExportPaymentSourceRequest
    extends Request<ExportPaymentSourceRequest> {
        private ExportPaymentSourceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ExportPaymentSourceRequest gatewayAccountId(String gatewayAccountId) {
            this.params.add("gateway_account_id", gatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class SwitchGatewayAccountRequest
    extends Request<SwitchGatewayAccountRequest> {
        private SwitchGatewayAccountRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public SwitchGatewayAccountRequest gatewayAccountId(String gatewayAccountId) {
            this.params.add("gateway_account_id", gatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class PaymentSourceListRequest
    extends ListRequest<PaymentSourceListRequest> {
        private PaymentSourceListRequest(String uri) {
            super(uri);
        }

        public PaymentSourceListRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public StringFilter<PaymentSourceListRequest> customerId() {
            return new StringFilter<PaymentSourceListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, PaymentSourceListRequest> type() {
            return new EnumFilter<Type, PaymentSourceListRequest>("type", this);
        }

        public EnumFilter<Status, PaymentSourceListRequest> status() {
            return new EnumFilter<Status, PaymentSourceListRequest>("status", this);
        }

        public TimestampFilter<PaymentSourceListRequest> updatedAt() {
            return new TimestampFilter<PaymentSourceListRequest>("updated_at", this);
        }

        public TimestampFilter<PaymentSourceListRequest> createdAt() {
            return new TimestampFilter<PaymentSourceListRequest>("created_at", this);
        }

        public PaymentSourceListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        public PaymentSourceListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class VerifyBankAccountRequest
    extends Request<VerifyBankAccountRequest> {
        private VerifyBankAccountRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public VerifyBankAccountRequest amount1(Integer amount1) {
            this.params.add("amount1", amount1);
            return this;
        }

        public VerifyBankAccountRequest amount2(Integer amount2) {
            this.params.add("amount2", amount2);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateBankAccountRequest
    extends Request<UpdateBankAccountRequest> {
        private UpdateBankAccountRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateBankAccountRequest bankAccountFirstName(String bankAccountFirstName) {
            this.params.addOpt("bank_account[first_name]", bankAccountFirstName);
            return this;
        }

        public UpdateBankAccountRequest bankAccountLastName(String bankAccountLastName) {
            this.params.addOpt("bank_account[last_name]", bankAccountLastName);
            return this;
        }

        public UpdateBankAccountRequest bankAccountEmail(String bankAccountEmail) {
            this.params.addOpt("bank_account[email]", bankAccountEmail);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateCardRequest
    extends Request<UpdateCardRequest> {
        private UpdateCardRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateCardRequest gatewayMetaData(JSONObject gatewayMetaData) {
            this.params.addOpt("gateway_meta_data", gatewayMetaData);
            return this;
        }

        public UpdateCardRequest referenceTransaction(String referenceTransaction) {
            this.params.addOpt("reference_transaction", referenceTransaction);
            return this;
        }

        public UpdateCardRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public UpdateCardRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public UpdateCardRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public UpdateCardRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public UpdateCardRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public UpdateCardRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public UpdateCardRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public UpdateCardRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public UpdateCardRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public UpdateCardRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public UpdateCardRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        public UpdateCardRequest cardAdditionalInformation(JSONObject cardAdditionalInformation) {
            this.params.addOpt("card[additional_information]", cardAdditionalInformation);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateBankAccountRequest
    extends Request<CreateBankAccountRequest> {
        private CreateBankAccountRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateBankAccountRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateBankAccountRequest issuingCountry(String issuingCountry) {
            this.params.addOpt("issuing_country", issuingCountry);
            return this;
        }

        public CreateBankAccountRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateBankAccountRequest bankAccountGatewayAccountId(String bankAccountGatewayAccountId) {
            this.params.addOpt("bank_account[gateway_account_id]", bankAccountGatewayAccountId);
            return this;
        }

        public CreateBankAccountRequest bankAccountIban(String bankAccountIban) {
            this.params.addOpt("bank_account[iban]", bankAccountIban);
            return this;
        }

        public CreateBankAccountRequest bankAccountFirstName(String bankAccountFirstName) {
            this.params.addOpt("bank_account[first_name]", bankAccountFirstName);
            return this;
        }

        public CreateBankAccountRequest bankAccountLastName(String bankAccountLastName) {
            this.params.addOpt("bank_account[last_name]", bankAccountLastName);
            return this;
        }

        public CreateBankAccountRequest bankAccountCompany(String bankAccountCompany) {
            this.params.addOpt("bank_account[company]", bankAccountCompany);
            return this;
        }

        public CreateBankAccountRequest bankAccountEmail(String bankAccountEmail) {
            this.params.addOpt("bank_account[email]", bankAccountEmail);
            return this;
        }

        public CreateBankAccountRequest bankAccountPhone(String bankAccountPhone) {
            this.params.addOpt("bank_account[phone]", bankAccountPhone);
            return this;
        }

        public CreateBankAccountRequest bankAccountBankName(String bankAccountBankName) {
            this.params.addOpt("bank_account[bank_name]", bankAccountBankName);
            return this;
        }

        public CreateBankAccountRequest bankAccountAccountNumber(String bankAccountAccountNumber) {
            this.params.addOpt("bank_account[account_number]", bankAccountAccountNumber);
            return this;
        }

        public CreateBankAccountRequest bankAccountRoutingNumber(String bankAccountRoutingNumber) {
            this.params.addOpt("bank_account[routing_number]", bankAccountRoutingNumber);
            return this;
        }

        public CreateBankAccountRequest bankAccountBankCode(String bankAccountBankCode) {
            this.params.addOpt("bank_account[bank_code]", bankAccountBankCode);
            return this;
        }

        public CreateBankAccountRequest bankAccountAccountType(AccountType bankAccountAccountType) {
            this.params.addOpt("bank_account[account_type]", (Object)bankAccountAccountType);
            return this;
        }

        public CreateBankAccountRequest bankAccountAccountHolderType(AccountHolderType bankAccountAccountHolderType) {
            this.params.addOpt("bank_account[account_holder_type]", (Object)bankAccountAccountHolderType);
            return this;
        }

        public CreateBankAccountRequest bankAccountEcheckType(EcheckType bankAccountEcheckType) {
            this.params.addOpt("bank_account[echeck_type]", (Object)bankAccountEcheckType);
            return this;
        }

        public CreateBankAccountRequest bankAccountSwedishIdentityNumber(String bankAccountSwedishIdentityNumber) {
            this.params.addOpt("bank_account[swedish_identity_number]", bankAccountSwedishIdentityNumber);
            return this;
        }

        public CreateBankAccountRequest bankAccountBillingAddress(JSONObject bankAccountBillingAddress) {
            this.params.addOpt("bank_account[billing_address]", bankAccountBillingAddress);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateCardRequest
    extends Request<CreateCardRequest> {
        private CreateCardRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateCardRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateCardRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateCardRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CreateCardRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public CreateCardRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public CreateCardRequest cardNumber(String cardNumber) {
            this.params.add("card[number]", cardNumber);
            return this;
        }

        public CreateCardRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.add("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public CreateCardRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.add("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public CreateCardRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public CreateCardRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public CreateCardRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public CreateCardRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public CreateCardRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public CreateCardRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public CreateCardRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public CreateCardRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        public CreateCardRequest cardAdditionalInformation(JSONObject cardAdditionalInformation) {
            this.params.addOpt("card[additional_information]", cardAdditionalInformation);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateVoucherPaymentSourceRequest
    extends Request<CreateVoucherPaymentSourceRequest> {
        private CreateVoucherPaymentSourceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateVoucherPaymentSourceRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateVoucherPaymentSourceRequest voucherPaymentSourceVoucherType(VoucherType voucherPaymentSourceVoucherType) {
            this.params.add("voucher_payment_source[voucher_type]", (Object)voucherPaymentSourceVoucherType);
            return this;
        }

        public CreateVoucherPaymentSourceRequest voucherPaymentSourceGatewayAccountId(String voucherPaymentSourceGatewayAccountId) {
            this.params.addOpt("voucher_payment_source[gateway_account_id]", voucherPaymentSourceGatewayAccountId);
            return this;
        }

        public CreateVoucherPaymentSourceRequest voucherPaymentSourceTaxId(String voucherPaymentSourceTaxId) {
            this.params.addOpt("voucher_payment_source[tax_id]", voucherPaymentSourceTaxId);
            return this;
        }

        public CreateVoucherPaymentSourceRequest voucherPaymentSourceBillingAddress(JSONObject voucherPaymentSourceBillingAddress) {
            this.params.addOpt("voucher_payment_source[billing_address]", voucherPaymentSourceBillingAddress);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateUsingPaymentIntentRequest
    extends Request<CreateUsingPaymentIntentRequest> {
        private CreateUsingPaymentIntentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateUsingPaymentIntentRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateUsingPaymentIntentRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateUsingPaymentIntentRequest paymentIntentId(String paymentIntentId) {
            this.params.addOpt("payment_intent[id]", paymentIntentId);
            return this;
        }

        public CreateUsingPaymentIntentRequest paymentIntentGatewayAccountId(String paymentIntentGatewayAccountId) {
            this.params.addOpt("payment_intent[gateway_account_id]", paymentIntentGatewayAccountId);
            return this;
        }

        public CreateUsingPaymentIntentRequest paymentIntentGwToken(String paymentIntentGwToken) {
            this.params.addOpt("payment_intent[gw_token]", paymentIntentGwToken);
            return this;
        }

        public CreateUsingPaymentIntentRequest paymentIntentPaymentMethodType(PaymentIntent.PaymentMethodType paymentIntentPaymentMethodType) {
            this.params.addOpt("payment_intent[payment_method_type]", (Object)paymentIntentPaymentMethodType);
            return this;
        }

        public CreateUsingPaymentIntentRequest paymentIntentReferenceId(String paymentIntentReferenceId) {
            this.params.addOpt("payment_intent[reference_id]", paymentIntentReferenceId);
            return this;
        }

        @Deprecated
        public CreateUsingPaymentIntentRequest paymentIntentGwPaymentMethodId(String paymentIntentGwPaymentMethodId) {
            this.params.addOpt("payment_intent[gw_payment_method_id]", paymentIntentGwPaymentMethodId);
            return this;
        }

        public CreateUsingPaymentIntentRequest paymentIntentAdditionalInfo(JSONObject paymentIntentAdditionalInfo) {
            this.params.addOpt("payment_intent[additional_info]", paymentIntentAdditionalInfo);
            return this;
        }

        public CreateUsingPaymentIntentRequest paymentIntentAdditionalInformation(JSONObject paymentIntentAdditionalInformation) {
            this.params.addOpt("payment_intent[additional_information]", paymentIntentAdditionalInformation);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateUsingTokenRequest
    extends Request<CreateUsingTokenRequest> {
        private CreateUsingTokenRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateUsingTokenRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateUsingTokenRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateUsingTokenRequest tokenId(String tokenId) {
            this.params.add("token_id", tokenId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateUsingPermanentTokenRequest
    extends Request<CreateUsingPermanentTokenRequest> {
        private CreateUsingPermanentTokenRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateUsingPermanentTokenRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateUsingPermanentTokenRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public CreateUsingPermanentTokenRequest gatewayAccountId(String gatewayAccountId) {
            this.params.addOpt("gateway_account_id", gatewayAccountId);
            return this;
        }

        public CreateUsingPermanentTokenRequest referenceId(String referenceId) {
            this.params.add("reference_id", referenceId);
            return this;
        }

        public CreateUsingPermanentTokenRequest issuingCountry(String issuingCountry) {
            this.params.addOpt("issuing_country", issuingCountry);
            return this;
        }

        public CreateUsingPermanentTokenRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateUsingPermanentTokenRequest additionalInformation(JSONObject additionalInformation) {
            this.params.addOpt("additional_information", additionalInformation);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateUsingTempTokenRequest
    extends Request<CreateUsingTempTokenRequest> {
        private CreateUsingTempTokenRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateUsingTempTokenRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateUsingTempTokenRequest gatewayAccountId(String gatewayAccountId) {
            this.params.addOpt("gateway_account_id", gatewayAccountId);
            return this;
        }

        public CreateUsingTempTokenRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public CreateUsingTempTokenRequest tmpToken(String tmpToken) {
            this.params.add("tmp_token", tmpToken);
            return this;
        }

        public CreateUsingTempTokenRequest issuingCountry(String issuingCountry) {
            this.params.addOpt("issuing_country", issuingCountry);
            return this;
        }

        public CreateUsingTempTokenRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateUsingTempTokenRequest additionalInformation(JSONObject additionalInformation) {
            this.params.addOpt("additional_information", additionalInformation);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Mandate
    extends Resource<Mandate> {
        public Mandate(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public String subscriptionId() {
            return this.reqString("subscription_id");
        }

        public Timestamp createdAt() {
            return this.reqTimestamp("created_at");
        }
    }

    public static class Venmo
    extends Resource<Venmo> {
        public Venmo(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String userName() {
            return this.optString("user_name");
        }
    }

    public static class Paypal
    extends Resource<Paypal> {
        public Paypal(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String email() {
            return this.optString("email");
        }

        public String agreementId() {
            return this.optString("agreement_id");
        }
    }

    public static class Upi
    extends Resource<Upi> {
        public Upi(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String vpa() {
            return this.optString("vpa");
        }
    }

    public static class AmazonPayment
    extends Resource<AmazonPayment> {
        public AmazonPayment(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String email() {
            return this.optString("email");
        }

        public String agreementId() {
            return this.optString("agreement_id");
        }
    }

    public static class BillingAddress
    extends Resource<BillingAddress> {
        public BillingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    public static class CustVoucherSource
    extends Resource<CustVoucherSource> {
        public CustVoucherSource(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String last4() {
            return this.reqString("last4");
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }
    }

    public static class BankAccount
    extends Resource<BankAccount> {
        public BankAccount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String last4() {
            return this.reqString("last4");
        }

        public String nameOnAccount() {
            return this.optString("name_on_account");
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public DirectDebitScheme directDebitScheme() {
            return this.optEnum("direct_debit_scheme", DirectDebitScheme.class);
        }

        public String bankName() {
            return this.optString("bank_name");
        }

        public String mandateId() {
            return this.optString("mandate_id");
        }

        public AccountType accountType() {
            return this.optEnum("account_type", AccountType.class);
        }

        public EcheckType echeckType() {
            return this.optEnum("echeck_type", EcheckType.class);
        }

        public AccountHolderType accountHolderType() {
            return this.optEnum("account_holder_type", AccountHolderType.class);
        }

        public String email() {
            return this.optString("email");
        }

        public static enum AccountHolderType {
            INDIVIDUAL,
            COMPANY,
            _UNKNOWN;

        }

        public static enum EcheckType {
            WEB,
            PPD,
            CCD,
            _UNKNOWN;

        }

        public static enum AccountType {
            CHECKING,
            SAVINGS,
            BUSINESS_CHECKING,
            CURRENT,
            _UNKNOWN;

        }
    }

    public static class Card
    extends Resource<Card> {
        public Card(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String iin() {
            return this.reqString("iin");
        }

        public String last4() {
            return this.reqString("last4");
        }

        public Brand brand() {
            return this.reqEnum("brand", Brand.class);
        }

        public FundingType fundingType() {
            return this.reqEnum("funding_type", FundingType.class);
        }

        public Integer expiryMonth() {
            return this.reqInteger("expiry_month");
        }

        public Integer expiryYear() {
            return this.reqInteger("expiry_year");
        }

        public String billingAddr1() {
            return this.optString("billing_addr1");
        }

        public String billingAddr2() {
            return this.optString("billing_addr2");
        }

        public String billingCity() {
            return this.optString("billing_city");
        }

        public String billingStateCode() {
            return this.optString("billing_state_code");
        }

        public String billingState() {
            return this.optString("billing_state");
        }

        public String billingCountry() {
            return this.optString("billing_country");
        }

        public String billingZip() {
            return this.optString("billing_zip");
        }

        public String maskedNumber() {
            return this.optString("masked_number");
        }

        public static enum FundingType {
            CREDIT,
            DEBIT,
            PREPAID,
            NOT_KNOWN,
            NOT_APPLICABLE,
            _UNKNOWN;

        }

        public static enum Brand {
            VISA,
            MASTERCARD,
            AMERICAN_EXPRESS,
            DISCOVER,
            JCB,
            DINERS_CLUB,
            OTHER,
            BANCONTACT,
            NOT_APPLICABLE,
            _UNKNOWN;

        }
    }

    public static enum Status {
        VALID,
        EXPIRING,
        EXPIRED,
        INVALID,
        PENDING_VERIFICATION,
        _UNKNOWN;

    }
}

