/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.CreditType;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class PromotionalCredit
extends Resource<PromotionalCredit> {
    public PromotionalCredit(String jsonStr) {
        super(jsonStr);
    }

    public PromotionalCredit(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public String amountInDecimal() {
        return this.optString("amount_in_decimal");
    }

    public Integer amount() {
        return this.reqInteger("amount");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public String description() {
        return this.reqString("description");
    }

    public CreditType creditType() {
        return this.reqEnum("credit_type", CreditType.class);
    }

    public String reference() {
        return this.optString("reference");
    }

    public Integer closingBalance() {
        return this.reqInteger("closing_balance");
    }

    public String doneBy() {
        return this.optString("done_by");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public static AddRequest add() {
        String uri = PromotionalCredit.uri("promotional_credits", "add");
        return new AddRequest(HttpUtil.Method.POST, uri);
    }

    public static DeductRequest deduct() {
        String uri = PromotionalCredit.uri("promotional_credits", "deduct");
        return new DeductRequest(HttpUtil.Method.POST, uri);
    }

    public static SetRequest set() {
        String uri = PromotionalCredit.uri("promotional_credits", "set");
        return new SetRequest(HttpUtil.Method.POST, uri);
    }

    public static PromotionalCreditListRequest list() {
        String uri = PromotionalCredit.uri("promotional_credits");
        return new PromotionalCreditListRequest(uri);
    }

    public static Request retrieve(String id) {
        String uri = PromotionalCredit.uri("promotional_credits", PromotionalCredit.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static class PromotionalCreditListRequest
    extends ListRequest<PromotionalCreditListRequest> {
        private PromotionalCreditListRequest(String uri) {
            super(uri);
        }

        public StringFilter<PromotionalCreditListRequest> id() {
            return new StringFilter<PromotionalCreditListRequest>("id", this);
        }

        public TimestampFilter<PromotionalCreditListRequest> createdAt() {
            return new TimestampFilter<PromotionalCreditListRequest>("created_at", this);
        }

        public EnumFilter<Type, PromotionalCreditListRequest> type() {
            return new EnumFilter<Type, PromotionalCreditListRequest>("type", this);
        }

        public StringFilter<PromotionalCreditListRequest> customerId() {
            return new StringFilter<PromotionalCreditListRequest>("customer_id", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class SetRequest
    extends Request<SetRequest> {
        private SetRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public SetRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public SetRequest amount(Integer amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public SetRequest amountInDecimal(String amountInDecimal) {
            this.params.addOpt("amount_in_decimal", amountInDecimal);
            return this;
        }

        public SetRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public SetRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public SetRequest creditType(CreditType creditType) {
            this.params.addOpt("credit_type", (Object)creditType);
            return this;
        }

        public SetRequest reference(String reference) {
            this.params.addOpt("reference", reference);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class DeductRequest
    extends Request<DeductRequest> {
        private DeductRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeductRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public DeductRequest amount(Integer amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public DeductRequest amountInDecimal(String amountInDecimal) {
            this.params.addOpt("amount_in_decimal", amountInDecimal);
            return this;
        }

        public DeductRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public DeductRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public DeductRequest creditType(CreditType creditType) {
            this.params.addOpt("credit_type", (Object)creditType);
            return this;
        }

        public DeductRequest reference(String reference) {
            this.params.addOpt("reference", reference);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AddRequest
    extends Request<AddRequest> {
        private AddRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public AddRequest amount(Integer amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public AddRequest amountInDecimal(String amountInDecimal) {
            this.params.addOpt("amount_in_decimal", amountInDecimal);
            return this;
        }

        public AddRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public AddRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public AddRequest creditType(CreditType creditType) {
            this.params.addOpt("credit_type", (Object)creditType);
            return this;
        }

        public AddRequest reference(String reference) {
            this.params.addOpt("reference", reference);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum Type {
        INCREMENT,
        DECREMENT,
        _UNKNOWN;

    }
}

