/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.Environment;
import com.chargebee.ListResult;
import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.DateFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.RequestBase;
import java.io.IOException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRequest<U extends ListRequest>
extends RequestBase<U> {
    public ListRequest(String uri) {
        this.uri = uri;
    }

    public U limit(int limit) {
        this.params.addOpt("limit", limit);
        return (U)this;
    }

    public U offset(String offset) {
        this.params.addOpt("offset", offset);
        return (U)this;
    }

    public StringFilter<U> stringFilterParam(String paramName) {
        return new StringFilter<ListRequest>(paramName, this).supportsPresenceOperator(true).supportsMultiOperators(true);
    }

    public BooleanFilter<U> booleanFilterParam(String paramName) {
        return new BooleanFilter<ListRequest>(paramName, this).supportsPresenceOperator(true);
    }

    public NumberFilter<Long, U> longFilterParam(String paramName) {
        return new NumberFilter(paramName, this).supportsPresenceOperator(true);
    }

    public TimestampFilter<U> timestampFilterParam(String paramName) {
        return new TimestampFilter<ListRequest>(paramName, this).supportsPresenceOperator(true);
    }

    public DateFilter<Date, U> dateFilterParam(String paramName) {
        return new DateFilter(paramName, this).supportsPresenceOperator(true);
    }

    public final ListResult request() throws IOException {
        return this.request(Environment.defaultConfig());
    }

    public final ListResult request(Environment env) throws IOException {
        if (env == null) {
            throw new RuntimeException("Environment cannot be null");
        }
        String url = env.apiBaseUrl() + this.uri;
        return HttpUtil.getList(url, this.params(), this.headers, env);
    }

    @Override
    public Params params() {
        return this.params;
    }
}

