/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.internal.ResultBase;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.BillingAlignmentMode;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.Taxability;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostedPage
extends Resource<HostedPage> {
    public HostedPage(String jsonStr) {
        super(jsonStr);
    }

    public HostedPage(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.optString("id");
    }

    public Type type() {
        return this.optEnum("type", Type.class);
    }

    public String url() {
        return this.optString("url");
    }

    public State state() {
        return this.optEnum("state", State.class);
    }

    @Deprecated
    public FailureReason failureReason() {
        return this.optEnum("failure_reason", FailureReason.class);
    }

    public String passThruContent() {
        return this.optString("pass_thru_content");
    }

    public Boolean embed() {
        return this.reqBoolean("embed");
    }

    public Timestamp createdAt() {
        return this.optTimestamp("created_at");
    }

    public Timestamp expiresAt() {
        return this.optTimestamp("expires_at");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public JSONObject checkoutInfo() {
        return this.optJSONObject("checkout_info");
    }

    public static CheckoutNewRequest checkoutNew() throws IOException {
        String uri = HostedPage.uri("hosted_pages", "checkout_new");
        return new CheckoutNewRequest(HttpUtil.Method.POST, uri);
    }

    public static CheckoutExistingRequest checkoutExisting() throws IOException {
        String uri = HostedPage.uri("hosted_pages", "checkout_existing");
        return new CheckoutExistingRequest(HttpUtil.Method.POST, uri);
    }

    @Deprecated
    public static UpdateCardRequest updateCard() throws IOException {
        String uri = HostedPage.uri("hosted_pages", "update_card");
        return new UpdateCardRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdatePaymentMethodRequest updatePaymentMethod() throws IOException {
        String uri = HostedPage.uri("hosted_pages", "update_payment_method");
        return new UpdatePaymentMethodRequest(HttpUtil.Method.POST, uri);
    }

    public static Request acknowledge(String id) throws IOException {
        String uri = HostedPage.uri("hosted_pages", HostedPage.nullCheck(id), "acknowledge");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = HostedPage.uri("hosted_pages", HostedPage.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static HostedPageListRequest list() throws IOException {
        String uri = HostedPage.uri("hosted_pages");
        return new HostedPageListRequest(uri);
    }

    public Content content() {
        if (this.optJSONObject("content") == null) {
            return null;
        }
        return new Content(this.optJSONObject("content"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HostedPageListRequest
    extends ListRequest<HostedPageListRequest> {
        private HostedPageListRequest(String uri) {
            super(uri);
        }

        public StringFilter<HostedPageListRequest> id() {
            return new StringFilter<HostedPageListRequest>("id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, HostedPageListRequest> type() {
            return new EnumFilter<Type, HostedPageListRequest>("type", this);
        }

        public EnumFilter<State, HostedPageListRequest> state() {
            return new EnumFilter<State, HostedPageListRequest>("state", this);
        }

        public TimestampFilter<HostedPageListRequest> updatedAt() {
            return new TimestampFilter<HostedPageListRequest>("updated_at", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdatePaymentMethodRequest
    extends Request<UpdatePaymentMethodRequest> {
        private UpdatePaymentMethodRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdatePaymentMethodRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public UpdatePaymentMethodRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public UpdatePaymentMethodRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public UpdatePaymentMethodRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public UpdatePaymentMethodRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public UpdatePaymentMethodRequest customerId(String customerId) {
            this.params.add("customer[id]", customerId);
            return this;
        }

        @Deprecated
        public UpdatePaymentMethodRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        @Deprecated
        public UpdatePaymentMethodRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public UpdatePaymentMethodRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateCardRequest
    extends Request<UpdateCardRequest> {
        private UpdateCardRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateCardRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public UpdateCardRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public UpdateCardRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public UpdateCardRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public UpdateCardRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public UpdateCardRequest customerId(String customerId) {
            this.params.add("customer[id]", customerId);
            return this;
        }

        @Deprecated
        public UpdateCardRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        @Deprecated
        public UpdateCardRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public UpdateCardRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckoutExistingRequest
    extends Request<CheckoutExistingRequest> {
        private CheckoutExistingRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutExistingRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CheckoutExistingRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public CheckoutExistingRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CheckoutExistingRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public CheckoutExistingRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CheckoutExistingRequest reactivate(Boolean reactivate) {
            this.params.addOpt("reactivate", reactivate);
            return this;
        }

        public CheckoutExistingRequest forceTermReset(Boolean forceTermReset) {
            this.params.addOpt("force_term_reset", forceTermReset);
            return this;
        }

        public CheckoutExistingRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutExistingRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public CheckoutExistingRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public CheckoutExistingRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public CheckoutExistingRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public CheckoutExistingRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        public CheckoutExistingRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.addOpt("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CheckoutExistingRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CheckoutExistingRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CheckoutExistingRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CheckoutExistingRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CheckoutExistingRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public CheckoutExistingRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CheckoutExistingRequest subscriptionInvoiceNotes(String subscriptionInvoiceNotes) {
            this.params.addOpt("subscription[invoice_notes]", subscriptionInvoiceNotes);
            return this;
        }

        public CheckoutExistingRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        @Deprecated
        public CheckoutExistingRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CheckoutExistingRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CheckoutExistingRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CheckoutExistingRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CheckoutExistingRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckoutNewRequest
    extends Request<CheckoutNewRequest> {
        private CheckoutNewRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutNewRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CheckoutNewRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CheckoutNewRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CheckoutNewRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutNewRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public CheckoutNewRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public CheckoutNewRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public CheckoutNewRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public CheckoutNewRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CheckoutNewRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public CheckoutNewRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public CheckoutNewRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public CheckoutNewRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        public CheckoutNewRequest customerCompany(String customerCompany) {
            this.params.addOpt("customer[company]", customerCompany);
            return this;
        }

        public CheckoutNewRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CheckoutNewRequest customerLocale(String customerLocale) {
            this.params.addOpt("customer[locale]", customerLocale);
            return this;
        }

        public CheckoutNewRequest customerPhone(String customerPhone) {
            this.params.addOpt("customer[phone]", customerPhone);
            return this;
        }

        public CheckoutNewRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CheckoutNewRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CheckoutNewRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CheckoutNewRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CheckoutNewRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CheckoutNewRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public CheckoutNewRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CheckoutNewRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public CheckoutNewRequest subscriptionInvoiceNotes(String subscriptionInvoiceNotes) {
            this.params.addOpt("subscription[invoice_notes]", subscriptionInvoiceNotes);
            return this;
        }

        @Deprecated
        public CheckoutNewRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CheckoutNewRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CheckoutNewRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CheckoutNewRequest customerConsolidatedInvoicing(Boolean customerConsolidatedInvoicing) {
            this.params.addOpt("customer[consolidated_invoicing]", customerConsolidatedInvoicing);
            return this;
        }

        public CheckoutNewRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public CheckoutNewRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public CheckoutNewRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public CheckoutNewRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public CheckoutNewRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public CheckoutNewRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CheckoutNewRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CheckoutNewRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CheckoutNewRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CheckoutNewRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CheckoutNewRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public CheckoutNewRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CheckoutNewRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CheckoutNewRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CheckoutNewRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CheckoutNewRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CheckoutNewRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CheckoutNewRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CheckoutNewRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CheckoutNewRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CheckoutNewRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CheckoutNewRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CheckoutNewRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CheckoutNewRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CheckoutNewRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CheckoutNewRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CheckoutNewRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CheckoutNewRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CheckoutNewRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CheckoutNewRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CheckoutNewRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Content
    extends ResultBase {
        public Content(JSONObject jsonObj) {
            super(jsonObj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum FailureReason {
        CARD_ERROR,
        SERVER_ERROR,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CREATED,
        REQUESTED,
        SUCCEEDED,
        CANCELLED,
        FAILED,
        ACKNOWLEDGED,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CHECKOUT_NEW,
        CHECKOUT_EXISTING,
        UPDATE_CARD,
        UPDATE_PAYMENT_METHOD,
        _UNKNOWN;

    }
}

