/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.CreditNote;
import com.chargebee.models.Transaction;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.TaxExemptReason;
import com.chargebee.models.enums.TaxJurisType;
import com.chargebee.models.enums.TaxOverrideReason;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoice
extends Resource<Invoice> {
    public Invoice(String jsonStr) {
        super(jsonStr);
    }

    public Invoice(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String poNumber() {
        return this.optString("po_number");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public Boolean recurring() {
        return this.reqBoolean("recurring");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String vatNumber() {
        return this.optString("vat_number");
    }

    public PriceType priceType() {
        return this.reqEnum("price_type", PriceType.class);
    }

    public Timestamp date() {
        return this.optTimestamp("date");
    }

    public Timestamp dueDate() {
        return this.optTimestamp("due_date");
    }

    public Integer netTermDays() {
        return this.optInteger("net_term_days");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Integer total() {
        return this.optInteger("total");
    }

    public Integer amountPaid() {
        return this.optInteger("amount_paid");
    }

    public Integer amountAdjusted() {
        return this.optInteger("amount_adjusted");
    }

    public Integer writeOffAmount() {
        return this.optInteger("write_off_amount");
    }

    public Integer creditsApplied() {
        return this.optInteger("credits_applied");
    }

    public Integer amountDue() {
        return this.optInteger("amount_due");
    }

    public Timestamp paidAt() {
        return this.optTimestamp("paid_at");
    }

    public DunningStatus dunningStatus() {
        return this.optEnum("dunning_status", DunningStatus.class);
    }

    public Timestamp nextRetryAt() {
        return this.optTimestamp("next_retry_at");
    }

    public Timestamp voidedAt() {
        return this.optTimestamp("voided_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Integer subTotal() {
        return this.reqInteger("sub_total");
    }

    public Integer tax() {
        return this.reqInteger("tax");
    }

    public Boolean firstInvoice() {
        return this.optBoolean("first_invoice");
    }

    public Boolean hasAdvanceCharges() {
        return this.optBoolean("has_advance_charges");
    }

    public Integer amountToCollect() {
        return this.optInteger("amount_to_collect");
    }

    public List<LineItem> lineItems() {
        return this.optList("line_items", LineItem.class);
    }

    public List<Discount> discounts() {
        return this.optList("discounts", Discount.class);
    }

    public List<LineItemDiscount> lineItemDiscounts() {
        return this.optList("line_item_discounts", LineItemDiscount.class);
    }

    public List<Tax> taxes() {
        return this.optList("taxes", Tax.class);
    }

    public List<LineItemTax> lineItemTaxes() {
        return this.optList("line_item_taxes", LineItemTax.class);
    }

    public List<LinkedPayment> linkedPayments() {
        return this.optList("linked_payments", LinkedPayment.class);
    }

    public List<AppliedCredit> appliedCredits() {
        return this.optList("applied_credits", AppliedCredit.class);
    }

    public List<AdjustmentCreditNote> adjustmentCreditNotes() {
        return this.optList("adjustment_credit_notes", AdjustmentCreditNote.class);
    }

    public List<IssuedCreditNote> issuedCreditNotes() {
        return this.optList("issued_credit_notes", IssuedCreditNote.class);
    }

    public List<LinkedOrder> linkedOrders() {
        return this.optList("linked_orders", LinkedOrder.class);
    }

    public List<Note> notes() {
        return this.optList("notes", Note.class);
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public BillingAddress billingAddress() {
        return this.optSubResource("billing_address", BillingAddress.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public static CreateRequest create() throws IOException {
        String uri = Invoice.uri("invoices");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeRequest charge() throws IOException {
        String uri = Invoice.uri("invoices", "charge");
        return new ChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeAddonRequest chargeAddon() throws IOException {
        String uri = Invoice.uri("invoices", "charge_addon");
        return new ChargeAddonRequest(HttpUtil.Method.POST, uri);
    }

    public static Request stopDunning(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "stop_dunning");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static ImportInvoiceRequest importInvoice() throws IOException {
        String uri = Invoice.uri("invoices", "import_invoice");
        return new ImportInvoiceRequest(HttpUtil.Method.POST, uri);
    }

    public static ApplyPaymentsRequest applyPayments(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "apply_payments");
        return new ApplyPaymentsRequest(HttpUtil.Method.POST, uri);
    }

    public static ApplyCreditsRequest applyCredits(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "apply_credits");
        return new ApplyCreditsRequest(HttpUtil.Method.POST, uri);
    }

    public static InvoiceListRequest list() throws IOException {
        String uri = Invoice.uri("invoices");
        return new InvoiceListRequest(uri);
    }

    @Deprecated
    public static ListRequest invoicesForCustomer(String id) throws IOException {
        String uri = Invoice.uri("customers", Invoice.nullCheck(id), "invoices");
        return new ListRequest(uri);
    }

    @Deprecated
    public static ListRequest invoicesForSubscription(String id) throws IOException {
        String uri = Invoice.uri("subscriptions", Invoice.nullCheck(id), "invoices");
        return new ListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request pdf(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "pdf");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static AddChargeRequest addCharge(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "add_charge");
        return new AddChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static AddAddonChargeRequest addAddonCharge(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "add_addon_charge");
        return new AddAddonChargeRequest(HttpUtil.Method.POST, uri);
    }

    public static Request close(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "close");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static CollectPaymentRequest collectPayment(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "collect_payment");
        return new CollectPaymentRequest(HttpUtil.Method.POST, uri);
    }

    public static RecordPaymentRequest recordPayment(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "record_payment");
        return new RecordPaymentRequest(HttpUtil.Method.POST, uri);
    }

    public static RefundRequest refund(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "refund");
        return new RefundRequest(HttpUtil.Method.POST, uri);
    }

    public static RecordRefundRequest recordRefund(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "record_refund");
        return new RecordRefundRequest(HttpUtil.Method.POST, uri);
    }

    public static RemovePaymentRequest removePayment(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "remove_payment");
        return new RemovePaymentRequest(HttpUtil.Method.POST, uri);
    }

    public static RemoveCreditNoteRequest removeCreditNote(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "remove_credit_note");
        return new RemoveCreditNoteRequest(HttpUtil.Method.POST, uri);
    }

    public static VoidInvoiceRequest voidInvoice(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "void");
        return new VoidInvoiceRequest(HttpUtil.Method.POST, uri);
    }

    public static WriteOffRequest writeOff(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "write_off");
        return new WriteOffRequest(HttpUtil.Method.POST, uri);
    }

    public static DeleteRequest delete(String id) throws IOException {
        String uri = Invoice.uri("invoices", Invoice.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriteOffRequest
    extends Request<WriteOffRequest> {
        private WriteOffRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public WriteOffRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VoidInvoiceRequest
    extends Request<VoidInvoiceRequest> {
        private VoidInvoiceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public VoidInvoiceRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveCreditNoteRequest
    extends Request<RemoveCreditNoteRequest> {
        private RemoveCreditNoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemoveCreditNoteRequest creditNoteId(String creditNoteId) {
            this.params.add("credit_note[id]", creditNoteId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemovePaymentRequest
    extends Request<RemovePaymentRequest> {
        private RemovePaymentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemovePaymentRequest transactionId(String transactionId) {
            this.params.add("transaction[id]", transactionId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecordRefundRequest
    extends Request<RecordRefundRequest> {
        private RecordRefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordRefundRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RecordRefundRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public RecordRefundRequest transactionAmount(Integer transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public RecordRefundRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.add("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public RecordRefundRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public RecordRefundRequest transactionDate(Timestamp transactionDate) {
            this.params.add("transaction[date]", transactionDate);
            return this;
        }

        public RecordRefundRequest creditNoteReasonCode(CreditNote.ReasonCode creditNoteReasonCode) {
            this.params.addOpt("credit_note[reason_code]", (Object)creditNoteReasonCode);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefundRequest
    extends Request<RefundRequest> {
        private RefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RefundRequest refundAmount(Integer refundAmount) {
            this.params.addOpt("refund_amount", refundAmount);
            return this;
        }

        public RefundRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RefundRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public RefundRequest creditNoteReasonCode(CreditNote.ReasonCode creditNoteReasonCode) {
            this.params.addOpt("credit_note[reason_code]", (Object)creditNoteReasonCode);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecordPaymentRequest
    extends Request<RecordPaymentRequest> {
        private RecordPaymentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordPaymentRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RecordPaymentRequest transactionAmount(Integer transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public RecordPaymentRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.add("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public RecordPaymentRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public RecordPaymentRequest transactionIdAtGateway(String transactionIdAtGateway) {
            this.params.addOpt("transaction[id_at_gateway]", transactionIdAtGateway);
            return this;
        }

        public RecordPaymentRequest transactionStatus(Transaction.Status transactionStatus) {
            this.params.addOpt("transaction[status]", (Object)transactionStatus);
            return this;
        }

        public RecordPaymentRequest transactionDate(Timestamp transactionDate) {
            this.params.addOpt("transaction[date]", transactionDate);
            return this;
        }

        public RecordPaymentRequest transactionErrorCode(String transactionErrorCode) {
            this.params.addOpt("transaction[error_code]", transactionErrorCode);
            return this;
        }

        public RecordPaymentRequest transactionErrorText(String transactionErrorText) {
            this.params.addOpt("transaction[error_text]", transactionErrorText);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectPaymentRequest
    extends Request<CollectPaymentRequest> {
        private CollectPaymentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CollectPaymentRequest amount(Integer amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public CollectPaymentRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddAddonChargeRequest
    extends Request<AddAddonChargeRequest> {
        private AddAddonChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddAddonChargeRequest addonId(String addonId) {
            this.params.add("addon_id", addonId);
            return this;
        }

        public AddAddonChargeRequest addonQuantity(Integer addonQuantity) {
            this.params.addOpt("addon_quantity", addonQuantity);
            return this;
        }

        public AddAddonChargeRequest addonUnitPrice(Integer addonUnitPrice) {
            this.params.addOpt("addon_unit_price", addonUnitPrice);
            return this;
        }

        public AddAddonChargeRequest lineItemDateFrom(Timestamp lineItemDateFrom) {
            this.params.addOpt("line_item[date_from]", lineItemDateFrom);
            return this;
        }

        public AddAddonChargeRequest lineItemDateTo(Timestamp lineItemDateTo) {
            this.params.addOpt("line_item[date_to]", lineItemDateTo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddChargeRequest
    extends Request<AddChargeRequest> {
        private AddChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddChargeRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public AddChargeRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public AddChargeRequest lineItemDateFrom(Timestamp lineItemDateFrom) {
            this.params.addOpt("line_item[date_from]", lineItemDateFrom);
            return this;
        }

        public AddChargeRequest lineItemDateTo(Timestamp lineItemDateTo) {
            this.params.addOpt("line_item[date_to]", lineItemDateTo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvoiceListRequest
    extends ListRequest<InvoiceListRequest> {
        private InvoiceListRequest(String uri) {
            super(uri);
        }

        @Deprecated
        public InvoiceListRequest paidOnAfter(Timestamp paidOnAfter) {
            this.params.addOpt("paid_on_after", paidOnAfter);
            return this;
        }

        public InvoiceListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<InvoiceListRequest> id() {
            return new StringFilter<InvoiceListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<InvoiceListRequest> subscriptionId() {
            return new StringFilter<InvoiceListRequest>("subscription_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<InvoiceListRequest> customerId() {
            return new StringFilter<InvoiceListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public BooleanFilter<InvoiceListRequest> recurring() {
            return new BooleanFilter<InvoiceListRequest>("recurring", this);
        }

        public EnumFilter<Status, InvoiceListRequest> status() {
            return new EnumFilter<Status, InvoiceListRequest>("status", this);
        }

        public EnumFilter<PriceType, InvoiceListRequest> priceType() {
            return new EnumFilter<PriceType, InvoiceListRequest>("price_type", this);
        }

        public TimestampFilter<InvoiceListRequest> date() {
            return new TimestampFilter<InvoiceListRequest>("date", this);
        }

        public TimestampFilter<InvoiceListRequest> paidAt() {
            return new TimestampFilter<InvoiceListRequest>("paid_at", this);
        }

        public NumberFilter<Integer, InvoiceListRequest> total() {
            return new NumberFilter<Integer, InvoiceListRequest>("total", this);
        }

        public NumberFilter<Integer, InvoiceListRequest> amountPaid() {
            return new NumberFilter<Integer, InvoiceListRequest>("amount_paid", this);
        }

        public NumberFilter<Integer, InvoiceListRequest> amountAdjusted() {
            return new NumberFilter<Integer, InvoiceListRequest>("amount_adjusted", this);
        }

        public NumberFilter<Integer, InvoiceListRequest> creditsApplied() {
            return new NumberFilter<Integer, InvoiceListRequest>("credits_applied", this);
        }

        public NumberFilter<Integer, InvoiceListRequest> amountDue() {
            return new NumberFilter<Integer, InvoiceListRequest>("amount_due", this);
        }

        public EnumFilter<DunningStatus, InvoiceListRequest> dunningStatus() {
            return new EnumFilter("dunning_status", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<InvoiceListRequest> voidedAt() {
            return new TimestampFilter<InvoiceListRequest>("voided_at", this);
        }

        public TimestampFilter<InvoiceListRequest> updatedAt() {
            return new TimestampFilter<InvoiceListRequest>("updated_at", this);
        }

        public InvoiceListRequest sortByDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "date");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ApplyCreditsRequest
    extends Request<ApplyCreditsRequest> {
        private ApplyCreditsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ApplyCreditsRequest creditNoteId(int index, String creditNoteId) {
            this.params.addOpt("credit_notes[id][" + index + "]", creditNoteId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ApplyPaymentsRequest
    extends Request<ApplyPaymentsRequest> {
        private ApplyPaymentsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ApplyPaymentsRequest transactionId(int index, String transactionId) {
            this.params.addOpt("transactions[id][" + index + "]", transactionId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportInvoiceRequest
    extends Request<ImportInvoiceRequest> {
        private ImportInvoiceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportInvoiceRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public ImportInvoiceRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public ImportInvoiceRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ImportInvoiceRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ImportInvoiceRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public ImportInvoiceRequest priceType(PriceType priceType) {
            this.params.addOpt("price_type", (Object)priceType);
            return this;
        }

        public ImportInvoiceRequest taxOverrideReason(TaxOverrideReason taxOverrideReason) {
            this.params.addOpt("tax_override_reason", (Object)taxOverrideReason);
            return this;
        }

        public ImportInvoiceRequest vatNumber(String vatNumber) {
            this.params.addOpt("vat_number", vatNumber);
            return this;
        }

        public ImportInvoiceRequest date(Timestamp date) {
            this.params.add("date", date);
            return this;
        }

        public ImportInvoiceRequest total(Integer total) {
            this.params.add("total", total);
            return this;
        }

        public ImportInvoiceRequest roundOff(Integer roundOff) {
            this.params.addOpt("round_off", roundOff);
            return this;
        }

        public ImportInvoiceRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public ImportInvoiceRequest dueDate(Timestamp dueDate) {
            this.params.addOpt("due_date", dueDate);
            return this;
        }

        public ImportInvoiceRequest netTermDays(Integer netTermDays) {
            this.params.addOpt("net_term_days", netTermDays);
            return this;
        }

        public ImportInvoiceRequest useForProration(Boolean useForProration) {
            this.params.addOpt("use_for_proration", useForProration);
            return this;
        }

        public ImportInvoiceRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public ImportInvoiceRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public ImportInvoiceRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public ImportInvoiceRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public ImportInvoiceRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public ImportInvoiceRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public ImportInvoiceRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public ImportInvoiceRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public ImportInvoiceRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public ImportInvoiceRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public ImportInvoiceRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public ImportInvoiceRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public ImportInvoiceRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public ImportInvoiceRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public ImportInvoiceRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public ImportInvoiceRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public ImportInvoiceRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public ImportInvoiceRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public ImportInvoiceRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public ImportInvoiceRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public ImportInvoiceRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public ImportInvoiceRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public ImportInvoiceRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public ImportInvoiceRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public ImportInvoiceRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public ImportInvoiceRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public ImportInvoiceRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public ImportInvoiceRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public ImportInvoiceRequest lineItemDateFrom(int index, Timestamp lineItemDateFrom) {
            this.params.addOpt("line_items[date_from][" + index + "]", lineItemDateFrom);
            return this;
        }

        public ImportInvoiceRequest lineItemDateTo(int index, Timestamp lineItemDateTo) {
            this.params.addOpt("line_items[date_to][" + index + "]", lineItemDateTo);
            return this;
        }

        public ImportInvoiceRequest lineItemDescription(int index, String lineItemDescription) {
            this.params.add("line_items[description][" + index + "]", lineItemDescription);
            return this;
        }

        public ImportInvoiceRequest lineItemUnitAmount(int index, Integer lineItemUnitAmount) {
            this.params.addOpt("line_items[unit_amount][" + index + "]", lineItemUnitAmount);
            return this;
        }

        public ImportInvoiceRequest lineItemQuantity(int index, Integer lineItemQuantity) {
            this.params.addOpt("line_items[quantity][" + index + "]", lineItemQuantity);
            return this;
        }

        public ImportInvoiceRequest lineItemAmount(int index, Integer lineItemAmount) {
            this.params.addOpt("line_items[amount][" + index + "]", lineItemAmount);
            return this;
        }

        public ImportInvoiceRequest lineItemEntityType(int index, LineItem.EntityType lineItemEntityType) {
            this.params.addOpt("line_items[entity_type][" + index + "]", (Object)lineItemEntityType);
            return this;
        }

        public ImportInvoiceRequest lineItemEntityId(int index, String lineItemEntityId) {
            this.params.addOpt("line_items[entity_id][" + index + "]", lineItemEntityId);
            return this;
        }

        public ImportInvoiceRequest lineItemItemLevelDiscount1EntityId(int index, String lineItemItemLevelDiscount1EntityId) {
            this.params.addOpt("line_items[item_level_discount1_entity_id][" + index + "]", lineItemItemLevelDiscount1EntityId);
            return this;
        }

        public ImportInvoiceRequest lineItemItemLevelDiscount1Amount(int index, Integer lineItemItemLevelDiscount1Amount) {
            this.params.addOpt("line_items[item_level_discount1_amount][" + index + "]", lineItemItemLevelDiscount1Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemItemLevelDiscount2EntityId(int index, String lineItemItemLevelDiscount2EntityId) {
            this.params.addOpt("line_items[item_level_discount2_entity_id][" + index + "]", lineItemItemLevelDiscount2EntityId);
            return this;
        }

        public ImportInvoiceRequest lineItemItemLevelDiscount2Amount(int index, Integer lineItemItemLevelDiscount2Amount) {
            this.params.addOpt("line_items[item_level_discount2_amount][" + index + "]", lineItemItemLevelDiscount2Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax1Name(int index, String lineItemTax1Name) {
            this.params.addOpt("line_items[tax1_name][" + index + "]", lineItemTax1Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax1Amount(int index, Integer lineItemTax1Amount) {
            this.params.addOpt("line_items[tax1_amount][" + index + "]", lineItemTax1Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax2Name(int index, String lineItemTax2Name) {
            this.params.addOpt("line_items[tax2_name][" + index + "]", lineItemTax2Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax2Amount(int index, Integer lineItemTax2Amount) {
            this.params.addOpt("line_items[tax2_amount][" + index + "]", lineItemTax2Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax3Name(int index, String lineItemTax3Name) {
            this.params.addOpt("line_items[tax3_name][" + index + "]", lineItemTax3Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax3Amount(int index, Integer lineItemTax3Amount) {
            this.params.addOpt("line_items[tax3_amount][" + index + "]", lineItemTax3Amount);
            return this;
        }

        public ImportInvoiceRequest lineItemTax4Name(int index, String lineItemTax4Name) {
            this.params.addOpt("line_items[tax4_name][" + index + "]", lineItemTax4Name);
            return this;
        }

        public ImportInvoiceRequest lineItemTax4Amount(int index, Integer lineItemTax4Amount) {
            this.params.addOpt("line_items[tax4_amount][" + index + "]", lineItemTax4Amount);
            return this;
        }

        public ImportInvoiceRequest discountEntityType(int index, Discount.EntityType discountEntityType) {
            this.params.add("discounts[entity_type][" + index + "]", (Object)discountEntityType);
            return this;
        }

        public ImportInvoiceRequest discountEntityId(int index, String discountEntityId) {
            this.params.addOpt("discounts[entity_id][" + index + "]", discountEntityId);
            return this;
        }

        public ImportInvoiceRequest discountDescription(int index, String discountDescription) {
            this.params.addOpt("discounts[description][" + index + "]", discountDescription);
            return this;
        }

        public ImportInvoiceRequest discountAmount(int index, Integer discountAmount) {
            this.params.add("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public ImportInvoiceRequest taxName(int index, String taxName) {
            this.params.add("taxes[name][" + index + "]", taxName);
            return this;
        }

        public ImportInvoiceRequest taxRate(int index, Double taxRate) {
            this.params.add("taxes[rate][" + index + "]", taxRate);
            return this;
        }

        public ImportInvoiceRequest taxAmount(int index, Integer taxAmount) {
            this.params.addOpt("taxes[amount][" + index + "]", taxAmount);
            return this;
        }

        public ImportInvoiceRequest taxDescription(int index, String taxDescription) {
            this.params.addOpt("taxes[description][" + index + "]", taxDescription);
            return this;
        }

        public ImportInvoiceRequest taxJurisType(int index, TaxJurisType taxJurisType) {
            this.params.addOpt("taxes[juris_type][" + index + "]", (Object)taxJurisType);
            return this;
        }

        public ImportInvoiceRequest taxJurisName(int index, String taxJurisName) {
            this.params.addOpt("taxes[juris_name][" + index + "]", taxJurisName);
            return this;
        }

        public ImportInvoiceRequest taxJurisCode(int index, String taxJurisCode) {
            this.params.addOpt("taxes[juris_code][" + index + "]", taxJurisCode);
            return this;
        }

        public ImportInvoiceRequest paymentAmount(int index, Integer paymentAmount) {
            this.params.add("payments[amount][" + index + "]", paymentAmount);
            return this;
        }

        public ImportInvoiceRequest paymentPaymentMethod(int index, PaymentMethod paymentPaymentMethod) {
            this.params.add("payments[payment_method][" + index + "]", (Object)paymentPaymentMethod);
            return this;
        }

        public ImportInvoiceRequest paymentDate(int index, Timestamp paymentDate) {
            this.params.addOpt("payments[date][" + index + "]", paymentDate);
            return this;
        }

        public ImportInvoiceRequest paymentReferenceNumber(int index, String paymentReferenceNumber) {
            this.params.addOpt("payments[reference_number][" + index + "]", paymentReferenceNumber);
            return this;
        }

        public ImportInvoiceRequest noteEntityType(int index, Note.EntityType noteEntityType) {
            this.params.addOpt("notes[entity_type][" + index + "]", (Object)noteEntityType);
            return this;
        }

        public ImportInvoiceRequest noteEntityId(int index, String noteEntityId) {
            this.params.addOpt("notes[entity_id][" + index + "]", noteEntityId);
            return this;
        }

        public ImportInvoiceRequest noteNote(int index, String noteNote) {
            this.params.addOpt("notes[note][" + index + "]", noteNote);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChargeAddonRequest
    extends Request<ChargeAddonRequest> {
        private ChargeAddonRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeAddonRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ChargeAddonRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ChargeAddonRequest addonId(String addonId) {
            this.params.add("addon_id", addonId);
            return this;
        }

        public ChargeAddonRequest addonQuantity(Integer addonQuantity) {
            this.params.addOpt("addon_quantity", addonQuantity);
            return this;
        }

        public ChargeAddonRequest addonUnitPrice(Integer addonUnitPrice) {
            this.params.addOpt("addon_unit_price", addonUnitPrice);
            return this;
        }

        public ChargeAddonRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public ChargeAddonRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public ChargeAddonRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChargeRequest
    extends Request<ChargeRequest> {
        private ChargeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ChargeRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ChargeRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public ChargeRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public ChargeRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        public ChargeRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public ChargeRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public ChargeRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public CreateRequest paymentSourceId(String paymentSourceId) {
            this.params.addOpt("payment_source_id", paymentSourceId);
            return this;
        }

        public CreateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateRequest chargeAmount(int index, Integer chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CreateRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BillingAddress
    extends Resource<BillingAddress> {
        public BillingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Note
    extends Resource<Note> {
        public Note(JSONObject jsonObj) {
            super(jsonObj);
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String note() {
            return this.reqString("note");
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            PLAN,
            ADDON,
            COUPON,
            SUBSCRIPTION,
            CUSTOMER,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedOrder
    extends Resource<LinkedOrder> {
        public LinkedOrder(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Status status() {
            return this.optEnum("status", Status.class);
        }

        public String referenceId() {
            return this.optString("reference_id");
        }

        public String fulfillmentStatus() {
            return this.optString("fulfillment_status");
        }

        public String batchId() {
            return this.optString("batch_id");
        }

        public Timestamp createdAt() {
            return this.reqTimestamp("created_at");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Status {
            NEW,
            PROCESSING,
            COMPLETE,
            CANCELLED,
            VOIDED,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IssuedCreditNote
    extends Resource<IssuedCreditNote> {
        public IssuedCreditNote(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String cnId() {
            return this.reqString("cn_id");
        }

        public CreditNote.ReasonCode cnReasonCode() {
            return this.reqEnum("cn_reason_code", CreditNote.ReasonCode.class);
        }

        public Timestamp cnDate() {
            return this.optTimestamp("cn_date");
        }

        public Integer cnTotal() {
            return this.optInteger("cn_total");
        }

        public CreditNote.Status cnStatus() {
            return this.reqEnum("cn_status", CreditNote.Status.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdjustmentCreditNote
    extends Resource<AdjustmentCreditNote> {
        public AdjustmentCreditNote(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String cnId() {
            return this.reqString("cn_id");
        }

        public CreditNote.ReasonCode cnReasonCode() {
            return this.reqEnum("cn_reason_code", CreditNote.ReasonCode.class);
        }

        public Timestamp cnDate() {
            return this.optTimestamp("cn_date");
        }

        public Integer cnTotal() {
            return this.optInteger("cn_total");
        }

        public CreditNote.Status cnStatus() {
            return this.reqEnum("cn_status", CreditNote.Status.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AppliedCredit
    extends Resource<AppliedCredit> {
        public AppliedCredit(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String cnId() {
            return this.reqString("cn_id");
        }

        public Integer appliedAmount() {
            return this.reqInteger("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public CreditNote.ReasonCode cnReasonCode() {
            return this.reqEnum("cn_reason_code", CreditNote.ReasonCode.class);
        }

        public Timestamp cnDate() {
            return this.optTimestamp("cn_date");
        }

        public CreditNote.Status cnStatus() {
            return this.reqEnum("cn_status", CreditNote.Status.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedPayment
    extends Resource<LinkedPayment> {
        public LinkedPayment(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String txnId() {
            return this.reqString("txn_id");
        }

        public Integer appliedAmount() {
            return this.reqInteger("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public Transaction.Status txnStatus() {
            return this.optEnum("txn_status", Transaction.Status.class);
        }

        public Timestamp txnDate() {
            return this.optTimestamp("txn_date");
        }

        public Integer txnAmount() {
            return this.optInteger("txn_amount");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItemTax
    extends Resource<LineItemTax> {
        public LineItemTax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public String taxName() {
            return this.reqString("tax_name");
        }

        public Double taxRate() {
            return this.reqDouble("tax_rate");
        }

        public Integer taxAmount() {
            return this.reqInteger("tax_amount");
        }

        public TaxJurisType taxJurisType() {
            return this.optEnum("tax_juris_type", TaxJurisType.class);
        }

        public String taxJurisName() {
            return this.optString("tax_juris_name");
        }

        public String taxJurisCode() {
            return this.optString("tax_juris_code");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tax
    extends Resource<Tax> {
        public Tax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String name() {
            return this.reqString("name");
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItemDiscount
    extends Resource<LineItemDiscount> {
        public LineItemDiscount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.reqString("line_item_id");
        }

        public DiscountType discountType() {
            return this.reqEnum("discount_type", DiscountType.class);
        }

        public String couponId() {
            return this.optString("coupon_id");
        }

        public Integer discountAmount() {
            return this.reqInteger("discount_amount");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DiscountType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Discount
    extends Resource<Discount> {
        public Discount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItem
    extends Resource<LineItem> {
        public LineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.optString("id");
        }

        public String subscriptionId() {
            return this.optString("subscription_id");
        }

        public Timestamp dateFrom() {
            return this.reqTimestamp("date_from");
        }

        public Timestamp dateTo() {
            return this.reqTimestamp("date_to");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Boolean isTaxed() {
            return this.reqBoolean("is_taxed");
        }

        public Integer taxAmount() {
            return this.optInteger("tax_amount");
        }

        public Double taxRate() {
            return this.optDouble("tax_rate");
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public Integer discountAmount() {
            return this.optInteger("discount_amount");
        }

        public Integer itemLevelDiscountAmount() {
            return this.optInteger("item_level_discount_amount");
        }

        public String description() {
            return this.reqString("description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public TaxExemptReason taxExemptReason() {
            return this.optEnum("tax_exempt_reason", TaxExemptReason.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            PLAN_SETUP,
            PLAN,
            ADDON,
            ADHOC,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DunningStatus {
        IN_PROGRESS,
        EXHAUSTED,
        STOPPED,
        SUCCESS,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PAID,
        POSTED,
        PAYMENT_DUE,
        NOT_PAID,
        VOIDED,
        PENDING,
        _UNKNOWN;

    }
}

