/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.Type;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentSource
extends Resource<PaymentSource> {
    public PaymentSource(String jsonStr) {
        super(jsonStr);
    }

    public PaymentSource(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public String referenceId() {
        return this.reqString("reference_id");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Gateway gateway() {
        return this.reqEnum("gateway", Gateway.class);
    }

    public String gatewayAccountId() {
        return this.optString("gateway_account_id");
    }

    public String ipAddress() {
        return this.optString("ip_address");
    }

    public String issuingCountry() {
        return this.optString("issuing_country");
    }

    public Card card() {
        return this.optSubResource("card", Card.class);
    }

    public BankAccount bankAccount() {
        return this.optSubResource("bank_account", BankAccount.class);
    }

    public AmazonPayment amazonPayment() {
        return this.optSubResource("amazon_payment", AmazonPayment.class);
    }

    public Paypal paypal() {
        return this.optSubResource("paypal", Paypal.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public static CreateUsingTempTokenRequest createUsingTempToken() throws IOException {
        String uri = PaymentSource.uri("payment_sources", "create_using_temp_token");
        return new CreateUsingTempTokenRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateUsingPermanentTokenRequest createUsingPermanentToken() throws IOException {
        String uri = PaymentSource.uri("payment_sources", "create_using_permanent_token");
        return new CreateUsingPermanentTokenRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateCardRequest createCard() throws IOException {
        String uri = PaymentSource.uri("payment_sources", "create_card");
        return new CreateCardRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateCardRequest updateCard(String id) throws IOException {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "update_card");
        return new UpdateCardRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static PaymentSourceListRequest list() throws IOException {
        String uri = PaymentSource.uri("payment_sources");
        return new PaymentSourceListRequest(uri);
    }

    public static SwitchGatewayAccountRequest switchGatewayAccount(String id) throws IOException {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "switch_gateway_account");
        return new SwitchGatewayAccountRequest(HttpUtil.Method.POST, uri);
    }

    public static ExportPaymentSourceRequest exportPaymentSource(String id) throws IOException {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "export_payment_source");
        return new ExportPaymentSourceRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) throws IOException {
        String uri = PaymentSource.uri("payment_sources", PaymentSource.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExportPaymentSourceRequest
    extends Request<ExportPaymentSourceRequest> {
        private ExportPaymentSourceRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ExportPaymentSourceRequest gatewayAccountId(String gatewayAccountId) {
            this.params.add("gateway_account_id", gatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwitchGatewayAccountRequest
    extends Request<SwitchGatewayAccountRequest> {
        private SwitchGatewayAccountRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public SwitchGatewayAccountRequest gatewayAccountId(String gatewayAccountId) {
            this.params.add("gateway_account_id", gatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PaymentSourceListRequest
    extends ListRequest<PaymentSourceListRequest> {
        private PaymentSourceListRequest(String uri) {
            super(uri);
        }

        public StringFilter<PaymentSourceListRequest> customerId() {
            return new StringFilter<PaymentSourceListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, PaymentSourceListRequest> type() {
            return new EnumFilter<Type, PaymentSourceListRequest>("type", this);
        }

        public EnumFilter<Status, PaymentSourceListRequest> status() {
            return new EnumFilter<Status, PaymentSourceListRequest>("status", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateCardRequest
    extends Request<UpdateCardRequest> {
        private UpdateCardRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateCardRequest gatewayMetaData(JSONObject gatewayMetaData) {
            this.params.addOpt("gateway_meta_data", gatewayMetaData);
            return this;
        }

        public UpdateCardRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public UpdateCardRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public UpdateCardRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public UpdateCardRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public UpdateCardRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public UpdateCardRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public UpdateCardRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public UpdateCardRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public UpdateCardRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public UpdateCardRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public UpdateCardRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateCardRequest
    extends Request<CreateCardRequest> {
        private CreateCardRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateCardRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateCardRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        public CreateCardRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CreateCardRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public CreateCardRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public CreateCardRequest cardNumber(String cardNumber) {
            this.params.add("card[number]", cardNumber);
            return this;
        }

        public CreateCardRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.add("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public CreateCardRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.add("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public CreateCardRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public CreateCardRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public CreateCardRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public CreateCardRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public CreateCardRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public CreateCardRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public CreateCardRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public CreateCardRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateUsingPermanentTokenRequest
    extends Request<CreateUsingPermanentTokenRequest> {
        private CreateUsingPermanentTokenRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateUsingPermanentTokenRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateUsingPermanentTokenRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public CreateUsingPermanentTokenRequest gatewayAccountId(String gatewayAccountId) {
            this.params.addOpt("gateway_account_id", gatewayAccountId);
            return this;
        }

        public CreateUsingPermanentTokenRequest referenceId(String referenceId) {
            this.params.add("reference_id", referenceId);
            return this;
        }

        public CreateUsingPermanentTokenRequest issuingCountry(String issuingCountry) {
            this.params.addOpt("issuing_country", issuingCountry);
            return this;
        }

        public CreateUsingPermanentTokenRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateUsingTempTokenRequest
    extends Request<CreateUsingTempTokenRequest> {
        private CreateUsingTempTokenRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateUsingTempTokenRequest customerId(String customerId) {
            this.params.add("customer_id", customerId);
            return this;
        }

        public CreateUsingTempTokenRequest gatewayAccountId(String gatewayAccountId) {
            this.params.addOpt("gateway_account_id", gatewayAccountId);
            return this;
        }

        public CreateUsingTempTokenRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public CreateUsingTempTokenRequest tmpToken(String tmpToken) {
            this.params.add("tmp_token", tmpToken);
            return this;
        }

        public CreateUsingTempTokenRequest issuingCountry(String issuingCountry) {
            this.params.addOpt("issuing_country", issuingCountry);
            return this;
        }

        public CreateUsingTempTokenRequest replacePrimaryPaymentSource(Boolean replacePrimaryPaymentSource) {
            this.params.addOpt("replace_primary_payment_source", replacePrimaryPaymentSource);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Paypal
    extends Resource<Paypal> {
        public Paypal(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String email() {
            return this.optString("email");
        }

        public String agreementId() {
            return this.optString("agreement_id");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AmazonPayment
    extends Resource<AmazonPayment> {
        public AmazonPayment(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String email() {
            return this.optString("email");
        }

        public String agreementId() {
            return this.optString("agreement_id");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BankAccount
    extends Resource<BankAccount> {
        public BankAccount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String nameOnAccount() {
            return this.optString("name_on_account");
        }

        public String bankName() {
            return this.optString("bank_name");
        }

        public String mandateId() {
            return this.optString("mandate_id");
        }

        public AccountType accountType() {
            return this.optEnum("account_type", AccountType.class);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum AccountType {
            CHECKING,
            SAVINGS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Card
    extends Resource<Card> {
        public Card(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String iin() {
            return this.reqString("iin");
        }

        public String last4() {
            return this.reqString("last4");
        }

        public Brand brand() {
            return this.reqEnum("brand", Brand.class);
        }

        public FundingType fundingType() {
            return this.reqEnum("funding_type", FundingType.class);
        }

        public Integer expiryMonth() {
            return this.reqInteger("expiry_month");
        }

        public Integer expiryYear() {
            return this.reqInteger("expiry_year");
        }

        public String billingAddr1() {
            return this.optString("billing_addr1");
        }

        public String billingAddr2() {
            return this.optString("billing_addr2");
        }

        public String billingCity() {
            return this.optString("billing_city");
        }

        public String billingStateCode() {
            return this.optString("billing_state_code");
        }

        public String billingState() {
            return this.optString("billing_state");
        }

        public String billingCountry() {
            return this.optString("billing_country");
        }

        public String billingZip() {
            return this.optString("billing_zip");
        }

        public String maskedNumber() {
            return this.optString("masked_number");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum FundingType {
            CREDIT,
            DEBIT,
            PREPAID,
            NOT_KNOWN,
            NOT_APPLICABLE,
            _UNKNOWN;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Brand {
            VISA,
            MASTERCARD,
            AMERICAN_EXPRESS,
            DISCOVER,
            JCB,
            DINERS_CLUB,
            OTHER,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        VALID,
        EXPIRING,
        EXPIRED,
        INVALID,
        PENDING_VERIFICATION,
        _UNKNOWN;

    }
}

