/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.Invoice;
import com.chargebee.models.Transaction;
import com.chargebee.models.enums.DispositionType;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.models.enums.TaxExemptReason;
import com.chargebee.models.enums.TaxJurisType;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditNote
extends Resource<CreditNote> {
    public CreditNote(String jsonStr) {
        super(jsonStr);
    }

    public CreditNote(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public String referenceInvoiceId() {
        return this.reqString("reference_invoice_id");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public ReasonCode reasonCode() {
        return this.reqEnum("reason_code", ReasonCode.class);
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String vatNumber() {
        return this.optString("vat_number");
    }

    public Timestamp date() {
        return this.optTimestamp("date");
    }

    public PriceType priceType() {
        return this.reqEnum("price_type", PriceType.class);
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Integer total() {
        return this.optInteger("total");
    }

    public Integer amountAllocated() {
        return this.optInteger("amount_allocated");
    }

    public Integer amountRefunded() {
        return this.optInteger("amount_refunded");
    }

    public Integer amountAvailable() {
        return this.optInteger("amount_available");
    }

    public Timestamp refundedAt() {
        return this.optTimestamp("refunded_at");
    }

    public Timestamp voidedAt() {
        return this.optTimestamp("voided_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Integer subTotal() {
        return this.reqInteger("sub_total");
    }

    public Integer roundOffAmount() {
        return this.optInteger("round_off_amount");
    }

    public List<LineItem> lineItems() {
        return this.optList("line_items", LineItem.class);
    }

    public List<Discount> discounts() {
        return this.optList("discounts", Discount.class);
    }

    public List<LineItemDiscount> lineItemDiscounts() {
        return this.optList("line_item_discounts", LineItemDiscount.class);
    }

    public List<LineItemTier> lineItemTiers() {
        return this.optList("line_item_tiers", LineItemTier.class);
    }

    public List<Tax> taxes() {
        return this.optList("taxes", Tax.class);
    }

    public List<LineItemTax> lineItemTaxes() {
        return this.optList("line_item_taxes", LineItemTax.class);
    }

    public List<LinkedRefund> linkedRefunds() {
        return this.optList("linked_refunds", LinkedRefund.class);
    }

    public List<Allocation> allocations() {
        return this.optList("allocations", Allocation.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public static CreateRequest create() throws IOException {
        String uri = CreditNote.uri("credit_notes");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static PdfRequest pdf(String id) throws IOException {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "pdf");
        return new PdfRequest(HttpUtil.Method.POST, uri);
    }

    public static RecordRefundRequest recordRefund(String id) throws IOException {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "record_refund");
        return new RecordRefundRequest(HttpUtil.Method.POST, uri);
    }

    public static VoidCreditNoteRequest voidCreditNote(String id) throws IOException {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "void");
        return new VoidCreditNoteRequest(HttpUtil.Method.POST, uri);
    }

    public static CreditNoteListRequest list() throws IOException {
        String uri = CreditNote.uri("credit_notes");
        return new CreditNoteListRequest(uri);
    }

    @Deprecated
    public static ListRequest creditNotesForCustomer(String id) throws IOException {
        String uri = CreditNote.uri("customers", CreditNote.nullCheck(id), "credit_notes");
        return new ListRequest(uri);
    }

    public static DeleteRequest delete(String id) throws IOException {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreditNoteListRequest
    extends ListRequest<CreditNoteListRequest> {
        private CreditNoteListRequest(String uri) {
            super(uri);
        }

        public CreditNoteListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<CreditNoteListRequest> id() {
            return new StringFilter<CreditNoteListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<CreditNoteListRequest> customerId() {
            return new StringFilter<CreditNoteListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public StringFilter<CreditNoteListRequest> subscriptionId() {
            return new StringFilter<CreditNoteListRequest>("subscription_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<CreditNoteListRequest> referenceInvoiceId() {
            return new StringFilter<CreditNoteListRequest>("reference_invoice_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, CreditNoteListRequest> type() {
            return new EnumFilter<Type, CreditNoteListRequest>("type", this);
        }

        public EnumFilter<ReasonCode, CreditNoteListRequest> reasonCode() {
            return new EnumFilter<ReasonCode, CreditNoteListRequest>("reason_code", this);
        }

        public EnumFilter<Status, CreditNoteListRequest> status() {
            return new EnumFilter<Status, CreditNoteListRequest>("status", this);
        }

        public TimestampFilter<CreditNoteListRequest> date() {
            return new TimestampFilter<CreditNoteListRequest>("date", this);
        }

        public NumberFilter<Integer, CreditNoteListRequest> total() {
            return new NumberFilter<Integer, CreditNoteListRequest>("total", this);
        }

        public EnumFilter<PriceType, CreditNoteListRequest> priceType() {
            return new EnumFilter<PriceType, CreditNoteListRequest>("price_type", this);
        }

        public NumberFilter<Integer, CreditNoteListRequest> amountAllocated() {
            return new NumberFilter<Integer, CreditNoteListRequest>("amount_allocated", this);
        }

        public NumberFilter<Integer, CreditNoteListRequest> amountRefunded() {
            return new NumberFilter<Integer, CreditNoteListRequest>("amount_refunded", this);
        }

        public NumberFilter<Integer, CreditNoteListRequest> amountAvailable() {
            return new NumberFilter<Integer, CreditNoteListRequest>("amount_available", this);
        }

        public TimestampFilter<CreditNoteListRequest> voidedAt() {
            return new TimestampFilter<CreditNoteListRequest>("voided_at", this);
        }

        public TimestampFilter<CreditNoteListRequest> updatedAt() {
            return new TimestampFilter<CreditNoteListRequest>("updated_at", this);
        }

        public CreditNoteListRequest sortByDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "date");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VoidCreditNoteRequest
    extends Request<VoidCreditNoteRequest> {
        private VoidCreditNoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public VoidCreditNoteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecordRefundRequest
    extends Request<RecordRefundRequest> {
        private RecordRefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordRefundRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RecordRefundRequest transactionAmount(Integer transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public RecordRefundRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.add("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public RecordRefundRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public RecordRefundRequest transactionDate(Timestamp transactionDate) {
            this.params.add("transaction[date]", transactionDate);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PdfRequest
    extends Request<PdfRequest> {
        private PdfRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public PdfRequest dispositionType(DispositionType dispositionType) {
            this.params.addOpt("disposition_type", (Object)dispositionType);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest referenceInvoiceId(String referenceInvoiceId) {
            this.params.add("reference_invoice_id", referenceInvoiceId);
            return this;
        }

        public CreateRequest total(Integer total) {
            this.params.addOpt("total", total);
            return this;
        }

        public CreateRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public CreateRequest reasonCode(ReasonCode reasonCode) {
            this.params.add("reason_code", (Object)reasonCode);
            return this;
        }

        public CreateRequest date(Timestamp date) {
            this.params.addOpt("date", date);
            return this;
        }

        public CreateRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public CreateRequest lineItemReferenceLineItemId(int index, String lineItemReferenceLineItemId) {
            this.params.add("line_items[reference_line_item_id][" + index + "]", lineItemReferenceLineItemId);
            return this;
        }

        public CreateRequest lineItemUnitAmount(int index, Integer lineItemUnitAmount) {
            this.params.addOpt("line_items[unit_amount][" + index + "]", lineItemUnitAmount);
            return this;
        }

        public CreateRequest lineItemQuantity(int index, Integer lineItemQuantity) {
            this.params.addOpt("line_items[quantity][" + index + "]", lineItemQuantity);
            return this;
        }

        public CreateRequest lineItemAmount(int index, Integer lineItemAmount) {
            this.params.addOpt("line_items[amount][" + index + "]", lineItemAmount);
            return this;
        }

        public CreateRequest lineItemDescription(int index, String lineItemDescription) {
            this.params.addOpt("line_items[description][" + index + "]", lineItemDescription);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Allocation
    extends Resource<Allocation> {
        public Allocation(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String invoiceId() {
            return this.reqString("invoice_id");
        }

        public Integer allocatedAmount() {
            return this.reqInteger("allocated_amount");
        }

        public Timestamp allocatedAt() {
            return this.reqTimestamp("allocated_at");
        }

        public Timestamp invoiceDate() {
            return this.optTimestamp("invoice_date");
        }

        public Invoice.Status invoiceStatus() {
            return this.reqEnum("invoice_status", Invoice.Status.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedRefund
    extends Resource<LinkedRefund> {
        public LinkedRefund(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String txnId() {
            return this.reqString("txn_id");
        }

        public Integer appliedAmount() {
            return this.reqInteger("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public Transaction.Status txnStatus() {
            return this.optEnum("txn_status", Transaction.Status.class);
        }

        public Timestamp txnDate() {
            return this.optTimestamp("txn_date");
        }

        public Integer txnAmount() {
            return this.optInteger("txn_amount");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItemTax
    extends Resource<LineItemTax> {
        public LineItemTax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public String taxName() {
            return this.reqString("tax_name");
        }

        public Double taxRate() {
            return this.reqDouble("tax_rate");
        }

        public Integer taxAmount() {
            return this.reqInteger("tax_amount");
        }

        public TaxJurisType taxJurisType() {
            return this.optEnum("tax_juris_type", TaxJurisType.class);
        }

        public String taxJurisName() {
            return this.optString("tax_juris_name");
        }

        public String taxJurisCode() {
            return this.optString("tax_juris_code");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tax
    extends Resource<Tax> {
        public Tax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String name() {
            return this.reqString("name");
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItemTier
    extends Resource<LineItemTier> {
        public LineItemTier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Integer quantityUsed() {
            return this.reqInteger("quantity_used");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItemDiscount
    extends Resource<LineItemDiscount> {
        public LineItemDiscount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.reqString("line_item_id");
        }

        public DiscountType discountType() {
            return this.reqEnum("discount_type", DiscountType.class);
        }

        public String couponId() {
            return this.optString("coupon_id");
        }

        public Integer discountAmount() {
            return this.reqInteger("discount_amount");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DiscountType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Discount
    extends Resource<Discount> {
        public Discount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineItem
    extends Resource<LineItem> {
        public LineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.optString("id");
        }

        public String subscriptionId() {
            return this.optString("subscription_id");
        }

        public Timestamp dateFrom() {
            return this.reqTimestamp("date_from");
        }

        public Timestamp dateTo() {
            return this.reqTimestamp("date_to");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Integer amount() {
            return this.optInteger("amount");
        }

        public PricingModel pricingModel() {
            return this.optEnum("pricing_model", PricingModel.class);
        }

        public Boolean isTaxed() {
            return this.reqBoolean("is_taxed");
        }

        public Integer taxAmount() {
            return this.optInteger("tax_amount");
        }

        public Double taxRate() {
            return this.optDouble("tax_rate");
        }

        public Integer discountAmount() {
            return this.optInteger("discount_amount");
        }

        public Integer itemLevelDiscountAmount() {
            return this.optInteger("item_level_discount_amount");
        }

        public String description() {
            return this.reqString("description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public TaxExemptReason taxExemptReason() {
            return this.optEnum("tax_exempt_reason", TaxExemptReason.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EntityType {
            PLAN_SETUP,
            PLAN,
            ADDON,
            ADHOC,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ADJUSTED,
        REFUNDED,
        REFUND_DUE,
        VOIDED,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReasonCode {
        WRITE_OFF,
        SUBSCRIPTION_CHANGE,
        SUBSCRIPTION_CANCELLATION,
        SUBSCRIPTION_PAUSE,
        CHARGEBACK,
        PRODUCT_UNSATISFACTORY,
        SERVICE_UNSATISFACTORY,
        ORDER_CHANGE,
        ORDER_CANCELLATION,
        WAIVER,
        OTHER,
        FRAUDULENT,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADJUSTMENT,
        REFUNDABLE,
        _UNKNOWN;

    }
}

