/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.EntityType;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMigration
extends Resource<ResourceMigration> {
    public ResourceMigration(String jsonStr) {
        super(jsonStr);
    }

    public ResourceMigration(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String fromSite() {
        return this.reqString("from_site");
    }

    public EntityType entityType() {
        return this.reqEnum("entity_type", EntityType.class);
    }

    public String entityId() {
        return this.reqString("entity_id");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String errors() {
        return this.optString("errors");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp updatedAt() {
        return this.reqTimestamp("updated_at");
    }

    public static RetrieveLatestRequest retrieveLatest() throws IOException {
        String uri = ResourceMigration.uri("resource_migrations", "retrieve_latest");
        return new RetrieveLatestRequest(HttpUtil.Method.GET, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetrieveLatestRequest
    extends Request<RetrieveLatestRequest> {
        private RetrieveLatestRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RetrieveLatestRequest fromSite(String fromSite) {
            this.params.add("from_site", fromSite);
            return this;
        }

        public RetrieveLatestRequest entityType(EntityType entityType) {
            this.params.add("entity_type", (Object)entityType);
            return this;
        }

        public RetrieveLatestRequest entityId(String entityId) {
            this.params.add("entity_id", entityId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        SCHEDULED,
        FAILED,
        SUCCEEDED,
        _UNKNOWN;

    }
}

