/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouponSet
extends Resource<CouponSet> {
    public CouponSet(String jsonStr) {
        super(jsonStr);
    }

    public CouponSet(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String couponId() {
        return this.reqString("coupon_id");
    }

    public String name() {
        return this.reqString("name");
    }

    public Integer totalCount() {
        return this.optInteger("total_count");
    }

    public Integer redeemedCount() {
        return this.optInteger("redeemed_count");
    }

    public Integer archivedCount() {
        return this.optInteger("archived_count");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public static CreateRequest create() throws IOException {
        String uri = CouponSet.uri("coupon_sets");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static AddCouponCodesRequest addCouponCodes(String id) throws IOException {
        String uri = CouponSet.uri("coupon_sets", CouponSet.nullCheck(id), "add_coupon_codes");
        return new AddCouponCodesRequest(HttpUtil.Method.POST, uri);
    }

    public static CouponSetListRequest list() throws IOException {
        String uri = CouponSet.uri("coupon_sets");
        return new CouponSetListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = CouponSet.uri("coupon_sets", CouponSet.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static UpdateRequest update(String id) throws IOException {
        String uri = CouponSet.uri("coupon_sets", CouponSet.nullCheck(id), "update");
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) throws IOException {
        String uri = CouponSet.uri("coupon_sets", CouponSet.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request deleteUnusedCouponCodes(String id) throws IOException {
        String uri = CouponSet.uri("coupon_sets", CouponSet.nullCheck(id), "delete_unused_coupon_codes");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CouponSetListRequest
    extends ListRequest<CouponSetListRequest> {
        private CouponSetListRequest(String uri) {
            super(uri);
        }

        public StringFilter<CouponSetListRequest> id() {
            return new StringFilter<CouponSetListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<CouponSetListRequest> name() {
            return new StringFilter<CouponSetListRequest>("name", this).supportsMultiOperators(true);
        }

        public StringFilter<CouponSetListRequest> couponId() {
            return new StringFilter<CouponSetListRequest>("coupon_id", this).supportsMultiOperators(true);
        }

        public NumberFilter<Integer, CouponSetListRequest> totalCount() {
            return new NumberFilter<Integer, CouponSetListRequest>("total_count", this);
        }

        public NumberFilter<Integer, CouponSetListRequest> redeemedCount() {
            return new NumberFilter<Integer, CouponSetListRequest>("redeemed_count", this);
        }

        public NumberFilter<Integer, CouponSetListRequest> archivedCount() {
            return new NumberFilter<Integer, CouponSetListRequest>("archived_count", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddCouponCodesRequest
    extends Request<AddCouponCodesRequest> {
        private AddCouponCodesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddCouponCodesRequest code(List<String> code) {
            this.params.addOpt("code", code);
            return this;
        }

        public AddCouponCodesRequest code(String ... code) {
            this.params.addOpt("code", code);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest couponId(String couponId) {
            this.params.add("coupon_id", couponId);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }
}

