/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.Environment;
import com.chargebee.exceptions.OperationFailedException;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeMachine
extends Resource<TimeMachine> {
    public TimeMachine(String jsonStr) {
        super(jsonStr);
    }

    public TimeMachine(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String name() {
        return this.reqString("name");
    }

    public TimeTravelStatus timeTravelStatus() {
        return this.reqEnum("time_travel_status", TimeTravelStatus.class);
    }

    public Timestamp genesisTime() {
        return this.reqTimestamp("genesis_time");
    }

    public Timestamp destinationTime() {
        return this.reqTimestamp("destination_time");
    }

    public String failureCode() {
        return this.optString("failure_code");
    }

    public String failureReason() {
        return this.optString("failure_reason");
    }

    public String errorJson() {
        return this.optString("error_json");
    }

    public static Request retrieve(String id) throws IOException {
        String uri = TimeMachine.uri("time_machines", TimeMachine.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static StartAfreshRequest startAfresh(String id) throws IOException {
        String uri = TimeMachine.uri("time_machines", TimeMachine.nullCheck(id), "start_afresh");
        return new StartAfreshRequest(HttpUtil.Method.POST, uri);
    }

    public static TravelForwardRequest travelForward(String id) throws IOException {
        String uri = TimeMachine.uri("time_machines", TimeMachine.nullCheck(id), "travel_forward");
        return new TravelForwardRequest(HttpUtil.Method.POST, uri);
    }

    public TimeMachine waitForTimeTravelCompletion() throws Exception {
        return this.waitForTimeTravelCompletion(null);
    }

    public TimeMachine waitForTimeTravelCompletion(Environment env) throws Exception {
        int count = 0;
        int sleepTime = Integer.getInteger("cb.java.time_travel.sleep.millis", 3000);
        while (this.timeTravelStatus() == TimeTravelStatus.IN_PROGRESS) {
            if (count++ > 30) {
                throw new RuntimeException("The time travel is taking too much time");
            }
            Thread.sleep(sleepTime);
            Request req = TimeMachine.retrieve(this.name());
            this.jsonObj = (env == null ? req.request() : req.request((Environment)env)).timeMachine().jsonObj;
        }
        if (this.timeTravelStatus() == TimeTravelStatus.FAILED) {
            JSONObject errorJson = new JSONObject(this.errorJson());
            int httpStatusCode = errorJson.getInt("http_code");
            throw new OperationFailedException(httpStatusCode, errorJson);
        }
        if (this.timeTravelStatus() == TimeTravelStatus.NOT_ENABLED || this.timeTravelStatus() == TimeTravelStatus._UNKNOWN) {
            throw new RuntimeException("Time travel status is in wrong state" + (Object)((Object)this.timeTravelStatus()));
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TravelForwardRequest
    extends Request<TravelForwardRequest> {
        private TravelForwardRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public TravelForwardRequest destinationTime(Timestamp destinationTime) {
            this.params.addOpt("destination_time", destinationTime);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartAfreshRequest
    extends Request<StartAfreshRequest> {
        private StartAfreshRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StartAfreshRequest genesisTime(Timestamp genesisTime) {
            this.params.addOpt("genesis_time", genesisTime);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeTravelStatus {
        NOT_ENABLED,
        IN_PROGRESS,
        SUCCEEDED,
        FAILED,
        _UNKNOWN;

    }
}

