/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbilledCharge
extends Resource<UnbilledCharge> {
    public UnbilledCharge(String jsonStr) {
        super(jsonStr);
    }

    public UnbilledCharge(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.optString("id");
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public Timestamp dateFrom() {
        return this.optTimestamp("date_from");
    }

    public Timestamp dateTo() {
        return this.optTimestamp("date_to");
    }

    public Integer unitAmount() {
        return this.optInteger("unit_amount");
    }

    public PricingModel pricingModel() {
        return this.optEnum("pricing_model", PricingModel.class);
    }

    public Integer quantity() {
        return this.optInteger("quantity");
    }

    public Integer amount() {
        return this.optInteger("amount");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Integer discountAmount() {
        return this.optInteger("discount_amount");
    }

    public String description() {
        return this.optString("description");
    }

    public EntityType entityType() {
        return this.reqEnum("entity_type", EntityType.class);
    }

    public String entityId() {
        return this.optString("entity_id");
    }

    public Boolean isVoided() {
        return this.reqBoolean("is_voided");
    }

    public Timestamp voidedAt() {
        return this.optTimestamp("voided_at");
    }

    public List<Tier> tiers() {
        return this.optList("tiers", Tier.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public static InvoiceUnbilledChargesRequest invoiceUnbilledCharges() throws IOException {
        String uri = UnbilledCharge.uri("unbilled_charges", "invoice_unbilled_charges");
        return new InvoiceUnbilledChargesRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) throws IOException {
        String uri = UnbilledCharge.uri("unbilled_charges", UnbilledCharge.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static UnbilledChargeListRequest list() throws IOException {
        String uri = UnbilledCharge.uri("unbilled_charges");
        return new UnbilledChargeListRequest(uri);
    }

    public static InvoiceNowEstimateRequest invoiceNowEstimate() throws IOException {
        String uri = UnbilledCharge.uri("unbilled_charges", "invoice_now_estimate");
        return new InvoiceNowEstimateRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvoiceNowEstimateRequest
    extends Request<InvoiceNowEstimateRequest> {
        private InvoiceNowEstimateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public InvoiceNowEstimateRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public InvoiceNowEstimateRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnbilledChargeListRequest
    extends ListRequest<UnbilledChargeListRequest> {
        private UnbilledChargeListRequest(String uri) {
            super(uri);
        }

        public UnbilledChargeListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<UnbilledChargeListRequest> subscriptionId() {
            return new StringFilter<UnbilledChargeListRequest>("subscription_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<UnbilledChargeListRequest> customerId() {
            return new StringFilter<UnbilledChargeListRequest>("customer_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvoiceUnbilledChargesRequest
    extends Request<InvoiceUnbilledChargesRequest> {
        private InvoiceUnbilledChargesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public InvoiceUnbilledChargesRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public InvoiceUnbilledChargesRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tier
    extends Resource<Tier> {
        public Tier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Integer quantityUsed() {
            return this.reqInteger("quantity_used");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityType {
        PLAN_SETUP,
        PLAN,
        ADDON,
        ADHOC,
        _UNKNOWN;

    }
}

