/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalSession
extends Resource<PortalSession> {
    public PortalSession(String jsonStr) {
        super(jsonStr);
    }

    public PortalSession(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String token() {
        return this.reqString("token");
    }

    public String accessUrl() {
        return this.reqString("access_url");
    }

    public String redirectUrl() {
        return this.optString("redirect_url");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp expiresAt() {
        return this.optTimestamp("expires_at");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public Timestamp loginAt() {
        return this.optTimestamp("login_at");
    }

    public Timestamp logoutAt() {
        return this.optTimestamp("logout_at");
    }

    public String loginIpaddress() {
        return this.optString("login_ipaddress");
    }

    public String logoutIpaddress() {
        return this.optString("logout_ipaddress");
    }

    public List<LinkedCustomer> linkedCustomers() {
        return this.optList("linked_customers", LinkedCustomer.class);
    }

    public static CreateRequest create() throws IOException {
        String uri = PortalSession.uri("portal_sessions");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = PortalSession.uri("portal_sessions", PortalSession.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request logout(String id) throws IOException {
        String uri = PortalSession.uri("portal_sessions", PortalSession.nullCheck(id), "logout");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static ActivateRequest activate(String id) throws IOException {
        String uri = PortalSession.uri("portal_sessions", PortalSession.nullCheck(id), "activate");
        return new ActivateRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActivateRequest
    extends Request<ActivateRequest> {
        private ActivateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ActivateRequest token(String token) {
            this.params.add("token", token);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CreateRequest forwardUrl(String forwardUrl) {
            this.params.addOpt("forward_url", forwardUrl);
            return this;
        }

        public CreateRequest customerId(String customerId) {
            this.params.add("customer[id]", customerId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedCustomer
    extends Resource<LinkedCustomer> {
        public LinkedCustomer(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String customerId() {
            return this.reqString("customer_id");
        }

        public String email() {
            return this.optString("email");
        }

        public Boolean hasBillingAddress() {
            return this.reqBoolean("has_billing_address");
        }

        public Boolean hasPaymentMethod() {
            return this.reqBoolean("has_payment_method");
        }

        public Boolean hasActiveSubscription() {
            return this.reqBoolean("has_active_subscription");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        CREATED,
        LOGGED_IN,
        LOGGED_OUT,
        NOT_YET_ACTIVATED,
        ACTIVATED,
        _UNKNOWN;

    }
}

