/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentIntent
extends Resource<PaymentIntent> {
    public PaymentIntent(String jsonStr) {
        super(jsonStr);
    }

    public PaymentIntent(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String currencyCode() {
        return this.optString("currency_code");
    }

    public Integer amount() {
        return this.reqInteger("amount");
    }

    public String gatewayAccountId() {
        return this.reqString("gateway_account_id");
    }

    public Timestamp expiresAt() {
        return this.reqTimestamp("expires_at");
    }

    public String referenceId() {
        return this.optString("reference_id");
    }

    public PaymentMethodType paymentMethodType() {
        return this.optEnum("payment_method_type", PaymentMethodType.class);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Timestamp modifiedAt() {
        return this.reqTimestamp("modified_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String gateway() {
        return this.optString("gateway");
    }

    public PaymentAttempt activePaymentAttempt() {
        return this.optSubResource("active_payment_attempt", PaymentAttempt.class);
    }

    public static CreateRequest create() {
        String uri = PaymentIntent.uri("payment_intents");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = PaymentIntent.uri("payment_intents", PaymentIntent.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = PaymentIntent.uri("payment_intents", PaymentIntent.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest amount(Integer amount) {
            this.params.addOpt("amount", amount);
            return this;
        }

        public UpdateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public UpdateRequest gatewayAccountId(String gatewayAccountId) {
            this.params.addOpt("gateway_account_id", gatewayAccountId);
            return this;
        }

        public UpdateRequest paymentMethodType(PaymentMethodType paymentMethodType) {
            this.params.addOpt("payment_method_type", (Object)paymentMethodType);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public CreateRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.add("currency_code", currencyCode);
            return this;
        }

        public CreateRequest gatewayAccountId(String gatewayAccountId) {
            this.params.addOpt("gateway_account_id", gatewayAccountId);
            return this;
        }

        public CreateRequest referenceId(String referenceId) {
            this.params.addOpt("reference_id", referenceId);
            return this;
        }

        public CreateRequest paymentMethodType(PaymentMethodType paymentMethodType) {
            this.params.addOpt("payment_method_type", (Object)paymentMethodType);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PaymentAttempt
    extends Resource<PaymentAttempt> {
        public PaymentAttempt(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.optString("id");
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public PaymentMethodType paymentMethodType() {
            return this.optEnum("payment_method_type", PaymentMethodType.class);
        }

        public String idAtGateway() {
            return this.optString("id_at_gateway");
        }

        public String errorCode() {
            return this.optString("error_code");
        }

        public String errorText() {
            return this.optString("error_text");
        }

        public Timestamp createdAt() {
            return this.reqTimestamp("created_at");
        }

        public Timestamp modifiedAt() {
            return this.reqTimestamp("modified_at");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Status {
            INITED,
            REQUIRES_IDENTIFICATION,
            REQUIRES_CHALLENGE,
            REQUIRES_REDIRECTION,
            AUTHORIZED,
            REFUSED,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PaymentMethodType {
        CARD,
        IDEAL,
        SOFORT,
        BANCONTACT,
        GOOGLE_PAY,
        DOTPAY,
        GIROPAY,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        INITED,
        IN_PROGRESS,
        AUTHORIZED,
        CONSUMED,
        EXPIRED,
        _UNKNOWN;

    }
}

