/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee;

import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.org.json.JSONObject;
import java.util.Map;

public class BatchEntry<T extends Request> {
    String correlationId;
    JSONObject parameters;
    Request<T> requestObject;

    public void setParameters(JSONObject parameters) {
        this.parameters = parameters;
    }

    public Request<T> getRequestObject() {
        return this.requestObject;
    }

    public BatchEntry(Request<T> requestObject, String correlationId) {
        this(requestObject);
        this.correlationId = correlationId;
    }

    public BatchEntry(Request<T> requestObject) {
        this.requestObject = requestObject;
        this.parameters = this.jsonParams(requestObject.params());
    }

    private JSONObject jsonParams(Params params) {
        JSONObject paramJson = new JSONObject();
        for (Map.Entry<String, Object> paramMap : params.entries()) {
            paramJson.put(paramMap.getKey().toString(), paramMap.getValue());
        }
        return paramJson;
    }

    public JSONObject getJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("parameters", this.parameters);
        if (this.correlationId != null) {
            jsonObject.put("correlation_id", this.correlationId);
        }
        return jsonObject;
    }
}

