/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.Environment;
import com.chargebee.RequestWrap;
import com.chargebee.Result;
import com.chargebee.internal.BatchRequest;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.RequestBase;
import java.io.IOException;
import java.util.Map;

public class Request<U extends Request>
extends RequestBase<U> {
    private final HttpUtil.Method httpMeth;
    private String pathParam = null;

    public Request(HttpUtil.Method httpMeth, String uri) {
        this.uri = uri;
        this.httpMeth = httpMeth;
    }

    public Request(HttpUtil.Method httpMeth, String uri, String pathParam) {
        this(httpMeth, uri);
        this.pathParam = pathParam;
    }

    public U param(String paramName, Object value) {
        this.params.add(paramName, value);
        return (U)this;
    }

    public Result request() throws Exception {
        return this.request(Environment.defaultConfig());
    }

    public Result request(Environment env) throws Exception {
        RequestWrap<Request> c = new RequestWrap<Request>(env, this){

            @Override
            public Result call() throws Exception {
                return Request._request(this.env, (Request)this.request);
            }
        };
        return (Result)(env.reqInterceptor() != null ? env.reqInterceptor().handleRequest((RequestWrap<? extends RequestBase>)c) : c.call());
    }

    private static Result _request(Environment env, Request<?> req) throws IOException {
        if (env == null) {
            throw new RuntimeException("Environment cannot be null");
        }
        String url = env.apiBaseUrl() + req.uri;
        switch (req.httpMeth) {
            case GET: {
                return HttpUtil.get(url, req.params(), req.headers, env);
            }
            case POST: {
                if (req instanceof BatchRequest) {
                    return HttpUtil.post(url, ((BatchRequest)req).buildRequest(), (Map<String, String>)req.headers, env);
                }
                return HttpUtil.post(url, req.params(), (Map<String, String>)req.headers, env);
            }
        }
        throw new RuntimeException("Not handled type [" + (Object)((Object)req.httpMeth) + "]");
    }

    @Override
    public Params params() {
        return this.params;
    }

    public HttpUtil.Method httpMeth() {
        return this.httpMeth;
    }

    public String pathParam() {
        return this.pathParam;
    }
}

