/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.AvalaraSaleType;
import com.chargebee.models.enums.Channel;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class Addon
extends Resource<Addon> {
    public Addon(String jsonStr) {
        super(jsonStr);
    }

    public Addon(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String invoiceName() {
        return this.optString("invoice_name");
    }

    public String description() {
        return this.optString("description");
    }

    public PricingModel pricingModel() {
        return this.reqEnum("pricing_model", PricingModel.class);
    }

    @Deprecated
    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public ChargeType chargeType() {
        return this.reqEnum("charge_type", ChargeType.class);
    }

    public Long price() {
        return this.optLong("price");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Integer period() {
        return this.optInteger("period");
    }

    public PeriodUnit periodUnit() {
        return this.reqEnum("period_unit", PeriodUnit.class);
    }

    public String unit() {
        return this.optString("unit");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp archivedAt() {
        return this.optTimestamp("archived_at");
    }

    public Boolean enabledInPortal() {
        return this.reqBoolean("enabled_in_portal");
    }

    public String taxCode() {
        return this.optString("tax_code");
    }

    public String hsnCode() {
        return this.optString("hsn_code");
    }

    public String taxjarProductCode() {
        return this.optString("taxjar_product_code");
    }

    public AvalaraSaleType avalaraSaleType() {
        return this.optEnum("avalara_sale_type", AvalaraSaleType.class);
    }

    public Integer avalaraTransactionType() {
        return this.optInteger("avalara_transaction_type");
    }

    public Integer avalaraServiceType() {
        return this.optInteger("avalara_service_type");
    }

    public String sku() {
        return this.optString("sku");
    }

    public String accountingCode() {
        return this.optString("accounting_code");
    }

    public String accountingCategory1() {
        return this.optString("accounting_category1");
    }

    public String accountingCategory2() {
        return this.optString("accounting_category2");
    }

    public String accountingCategory3() {
        return this.optString("accounting_category3");
    }

    public String accountingCategory4() {
        return this.optString("accounting_category4");
    }

    public Boolean isShippable() {
        return this.optBoolean("is_shippable");
    }

    public Integer shippingFrequencyPeriod() {
        return this.optInteger("shipping_frequency_period");
    }

    public ShippingFrequencyPeriodUnit shippingFrequencyPeriodUnit() {
        return this.optEnum("shipping_frequency_period_unit", ShippingFrequencyPeriodUnit.class);
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public String priceInDecimal() {
        return this.optString("price_in_decimal");
    }

    public Boolean includedInMrr() {
        return this.optBoolean("included_in_mrr");
    }

    public Channel channel() {
        return this.optEnum("channel", Channel.class);
    }

    public ProrationType prorationType() {
        return this.optEnum("proration_type", ProrationType.class);
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public Boolean taxable() {
        return this.optBoolean("taxable");
    }

    public String taxProfileId() {
        return this.optString("tax_profile_id");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public List<Tier> tiers() {
        return this.optList("tiers", Tier.class);
    }

    public List<TaxProvidersField> taxProvidersFields() {
        return this.optList("tax_providers_fields", TaxProvidersField.class);
    }

    public Boolean showDescriptionInInvoices() {
        return this.optBoolean("show_description_in_invoices");
    }

    public Boolean showDescriptionInQuotes() {
        return this.optBoolean("show_description_in_quotes");
    }

    public static CreateRequest create() {
        String uri = Addon.uri("addons");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = Addon.uri("addons", Addon.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static AddonListRequest list() {
        String uri = Addon.uri("addons");
        return new AddonListRequest(uri);
    }

    public static Request retrieve(String id) {
        String uri = Addon.uri("addons", Addon.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request delete(String id) {
        String uri = Addon.uri("addons", Addon.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static CopyRequest copy() {
        String uri = Addon.uri("addons", "copy");
        return new CopyRequest(HttpUtil.Method.POST, uri);
    }

    public static Request unarchive(String id) {
        String uri = Addon.uri("addons", Addon.nullCheck(id), "unarchive");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class CopyRequest
    extends Request<CopyRequest> {
        private CopyRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CopyRequest fromSite(String fromSite) {
            this.params.add("from_site", fromSite);
            return this;
        }

        public CopyRequest idAtFromSite(String idAtFromSite) {
            this.params.add("id_at_from_site", idAtFromSite);
            return this;
        }

        public CopyRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CopyRequest forSiteMerging(Boolean forSiteMerging) {
            this.params.addOpt("for_site_merging", forSiteMerging);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AddonListRequest
    extends ListRequest<AddonListRequest> {
        private AddonListRequest(String uri) {
            super(uri);
        }

        public StringFilter<AddonListRequest> id() {
            return new StringFilter<AddonListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<AddonListRequest> name() {
            return new StringFilter<AddonListRequest>("name", this).supportsMultiOperators(true);
        }

        public EnumFilter<PricingModel, AddonListRequest> pricingModel() {
            return new EnumFilter<PricingModel, AddonListRequest>("pricing_model", this);
        }

        @Deprecated
        public EnumFilter<Type, AddonListRequest> type() {
            return new EnumFilter<Type, AddonListRequest>("type", this);
        }

        public EnumFilter<ChargeType, AddonListRequest> chargeType() {
            return new EnumFilter<ChargeType, AddonListRequest>("charge_type", this);
        }

        public NumberFilter<Long, AddonListRequest> price() {
            return new NumberFilter<Long, AddonListRequest>("price", this);
        }

        public NumberFilter<Integer, AddonListRequest> period() {
            return new NumberFilter<Integer, AddonListRequest>("period", this);
        }

        public EnumFilter<PeriodUnit, AddonListRequest> periodUnit() {
            return new EnumFilter<PeriodUnit, AddonListRequest>("period_unit", this);
        }

        public EnumFilter<Status, AddonListRequest> status() {
            return new EnumFilter<Status, AddonListRequest>("status", this);
        }

        public TimestampFilter<AddonListRequest> updatedAt() {
            return new TimestampFilter<AddonListRequest>("updated_at", this);
        }

        public StringFilter<AddonListRequest> currencyCode() {
            return new StringFilter<AddonListRequest>("currency_code", this).supportsMultiOperators(true);
        }

        public EnumFilter<Channel, AddonListRequest> channel() {
            return new EnumFilter<Channel, AddonListRequest>("channel", this);
        }

        public AddonListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public UpdateRequest chargeType(ChargeType chargeType) {
            this.params.addOpt("charge_type", (Object)chargeType);
            return this;
        }

        public UpdateRequest price(Long price) {
            this.params.addOpt("price", price);
            return this;
        }

        public UpdateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public UpdateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public UpdateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public UpdateRequest pricingModel(PricingModel pricingModel) {
            this.params.addOpt("pricing_model", (Object)pricingModel);
            return this;
        }

        @Deprecated
        public UpdateRequest type(Type type) {
            this.params.addOpt("type", (Object)type);
            return this;
        }

        public UpdateRequest unit(String unit) {
            this.params.addOpt("unit", unit);
            return this;
        }

        public UpdateRequest enabledInPortal(Boolean enabledInPortal) {
            this.params.addOpt("enabled_in_portal", enabledInPortal);
            return this;
        }

        public UpdateRequest taxable(Boolean taxable) {
            this.params.addOpt("taxable", taxable);
            return this;
        }

        public UpdateRequest taxProfileId(String taxProfileId) {
            this.params.addOpt("tax_profile_id", taxProfileId);
            return this;
        }

        public UpdateRequest avalaraSaleType(AvalaraSaleType avalaraSaleType) {
            this.params.addOpt("avalara_sale_type", (Object)avalaraSaleType);
            return this;
        }

        public UpdateRequest avalaraTransactionType(Integer avalaraTransactionType) {
            this.params.addOpt("avalara_transaction_type", avalaraTransactionType);
            return this;
        }

        public UpdateRequest avalaraServiceType(Integer avalaraServiceType) {
            this.params.addOpt("avalara_service_type", avalaraServiceType);
            return this;
        }

        public UpdateRequest taxCode(String taxCode) {
            this.params.addOpt("tax_code", taxCode);
            return this;
        }

        public UpdateRequest hsnCode(String hsnCode) {
            this.params.addOpt("hsn_code", hsnCode);
            return this;
        }

        public UpdateRequest taxjarProductCode(String taxjarProductCode) {
            this.params.addOpt("taxjar_product_code", taxjarProductCode);
            return this;
        }

        public UpdateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public UpdateRequest sku(String sku) {
            this.params.addOpt("sku", sku);
            return this;
        }

        public UpdateRequest accountingCode(String accountingCode) {
            this.params.addOpt("accounting_code", accountingCode);
            return this;
        }

        public UpdateRequest accountingCategory1(String accountingCategory1) {
            this.params.addOpt("accounting_category1", accountingCategory1);
            return this;
        }

        public UpdateRequest accountingCategory2(String accountingCategory2) {
            this.params.addOpt("accounting_category2", accountingCategory2);
            return this;
        }

        public UpdateRequest accountingCategory3(String accountingCategory3) {
            this.params.addOpt("accounting_category3", accountingCategory3);
            return this;
        }

        public UpdateRequest accountingCategory4(String accountingCategory4) {
            this.params.addOpt("accounting_category4", accountingCategory4);
            return this;
        }

        public UpdateRequest isShippable(Boolean isShippable) {
            this.params.addOpt("is_shippable", isShippable);
            return this;
        }

        public UpdateRequest shippingFrequencyPeriod(Integer shippingFrequencyPeriod) {
            this.params.addOpt("shipping_frequency_period", shippingFrequencyPeriod);
            return this;
        }

        public UpdateRequest shippingFrequencyPeriodUnit(ShippingFrequencyPeriodUnit shippingFrequencyPeriodUnit) {
            this.params.addOpt("shipping_frequency_period_unit", (Object)shippingFrequencyPeriodUnit);
            return this;
        }

        public UpdateRequest includedInMrr(Boolean includedInMrr) {
            this.params.addOpt("included_in_mrr", includedInMrr);
            return this;
        }

        public UpdateRequest showDescriptionInInvoices(Boolean showDescriptionInInvoices) {
            this.params.addOpt("show_description_in_invoices", showDescriptionInInvoices);
            return this;
        }

        public UpdateRequest showDescriptionInQuotes(Boolean showDescriptionInQuotes) {
            this.params.addOpt("show_description_in_quotes", showDescriptionInQuotes);
            return this;
        }

        public UpdateRequest priceInDecimal(String priceInDecimal) {
            this.params.addOpt("price_in_decimal", priceInDecimal);
            return this;
        }

        public UpdateRequest prorationType(ProrationType prorationType) {
            this.params.addOpt("proration_type", (Object)prorationType);
            return this;
        }

        public UpdateRequest tierStartingUnit(int index, Integer tierStartingUnit) {
            this.params.addOpt("tiers[starting_unit][" + index + "]", tierStartingUnit);
            return this;
        }

        public UpdateRequest tierEndingUnit(int index, Integer tierEndingUnit) {
            this.params.addOpt("tiers[ending_unit][" + index + "]", tierEndingUnit);
            return this;
        }

        public UpdateRequest tierPrice(int index, Long tierPrice) {
            this.params.addOpt("tiers[price][" + index + "]", tierPrice);
            return this;
        }

        public UpdateRequest tierStartingUnitInDecimal(int index, String tierStartingUnitInDecimal) {
            this.params.addOpt("tiers[starting_unit_in_decimal][" + index + "]", tierStartingUnitInDecimal);
            return this;
        }

        public UpdateRequest tierEndingUnitInDecimal(int index, String tierEndingUnitInDecimal) {
            this.params.addOpt("tiers[ending_unit_in_decimal][" + index + "]", tierEndingUnitInDecimal);
            return this;
        }

        public UpdateRequest tierPriceInDecimal(int index, String tierPriceInDecimal) {
            this.params.addOpt("tiers[price_in_decimal][" + index + "]", tierPriceInDecimal);
            return this;
        }

        public UpdateRequest taxProvidersFieldProviderName(int index, String taxProvidersFieldProviderName) {
            this.params.add("tax_providers_fields[provider_name][" + index + "]", taxProvidersFieldProviderName);
            return this;
        }

        public UpdateRequest taxProvidersFieldFieldId(int index, String taxProvidersFieldFieldId) {
            this.params.add("tax_providers_fields[field_id][" + index + "]", taxProvidersFieldFieldId);
            return this;
        }

        public UpdateRequest taxProvidersFieldFieldValue(int index, String taxProvidersFieldFieldValue) {
            this.params.add("tax_providers_fields[field_value][" + index + "]", taxProvidersFieldFieldValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public CreateRequest chargeType(ChargeType chargeType) {
            this.params.add("charge_type", (Object)chargeType);
            return this;
        }

        public CreateRequest price(Long price) {
            this.params.addOpt("price", price);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public CreateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public CreateRequest pricingModel(PricingModel pricingModel) {
            this.params.addOpt("pricing_model", (Object)pricingModel);
            return this;
        }

        @Deprecated
        public CreateRequest type(Type type) {
            this.params.addOpt("type", (Object)type);
            return this;
        }

        public CreateRequest unit(String unit) {
            this.params.addOpt("unit", unit);
            return this;
        }

        public CreateRequest enabledInPortal(Boolean enabledInPortal) {
            this.params.addOpt("enabled_in_portal", enabledInPortal);
            return this;
        }

        public CreateRequest taxable(Boolean taxable) {
            this.params.addOpt("taxable", taxable);
            return this;
        }

        public CreateRequest taxProfileId(String taxProfileId) {
            this.params.addOpt("tax_profile_id", taxProfileId);
            return this;
        }

        public CreateRequest avalaraSaleType(AvalaraSaleType avalaraSaleType) {
            this.params.addOpt("avalara_sale_type", (Object)avalaraSaleType);
            return this;
        }

        public CreateRequest avalaraTransactionType(Integer avalaraTransactionType) {
            this.params.addOpt("avalara_transaction_type", avalaraTransactionType);
            return this;
        }

        public CreateRequest avalaraServiceType(Integer avalaraServiceType) {
            this.params.addOpt("avalara_service_type", avalaraServiceType);
            return this;
        }

        public CreateRequest taxCode(String taxCode) {
            this.params.addOpt("tax_code", taxCode);
            return this;
        }

        public CreateRequest hsnCode(String hsnCode) {
            this.params.addOpt("hsn_code", hsnCode);
            return this;
        }

        public CreateRequest taxjarProductCode(String taxjarProductCode) {
            this.params.addOpt("taxjar_product_code", taxjarProductCode);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public CreateRequest sku(String sku) {
            this.params.addOpt("sku", sku);
            return this;
        }

        public CreateRequest accountingCode(String accountingCode) {
            this.params.addOpt("accounting_code", accountingCode);
            return this;
        }

        public CreateRequest accountingCategory1(String accountingCategory1) {
            this.params.addOpt("accounting_category1", accountingCategory1);
            return this;
        }

        public CreateRequest accountingCategory2(String accountingCategory2) {
            this.params.addOpt("accounting_category2", accountingCategory2);
            return this;
        }

        public CreateRequest accountingCategory3(String accountingCategory3) {
            this.params.addOpt("accounting_category3", accountingCategory3);
            return this;
        }

        public CreateRequest accountingCategory4(String accountingCategory4) {
            this.params.addOpt("accounting_category4", accountingCategory4);
            return this;
        }

        public CreateRequest isShippable(Boolean isShippable) {
            this.params.addOpt("is_shippable", isShippable);
            return this;
        }

        public CreateRequest shippingFrequencyPeriod(Integer shippingFrequencyPeriod) {
            this.params.addOpt("shipping_frequency_period", shippingFrequencyPeriod);
            return this;
        }

        public CreateRequest shippingFrequencyPeriodUnit(ShippingFrequencyPeriodUnit shippingFrequencyPeriodUnit) {
            this.params.addOpt("shipping_frequency_period_unit", (Object)shippingFrequencyPeriodUnit);
            return this;
        }

        public CreateRequest includedInMrr(Boolean includedInMrr) {
            this.params.addOpt("included_in_mrr", includedInMrr);
            return this;
        }

        public CreateRequest showDescriptionInInvoices(Boolean showDescriptionInInvoices) {
            this.params.addOpt("show_description_in_invoices", showDescriptionInInvoices);
            return this;
        }

        public CreateRequest showDescriptionInQuotes(Boolean showDescriptionInQuotes) {
            this.params.addOpt("show_description_in_quotes", showDescriptionInQuotes);
            return this;
        }

        public CreateRequest priceInDecimal(String priceInDecimal) {
            this.params.addOpt("price_in_decimal", priceInDecimal);
            return this;
        }

        public CreateRequest prorationType(ProrationType prorationType) {
            this.params.addOpt("proration_type", (Object)prorationType);
            return this;
        }

        public CreateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public CreateRequest tierStartingUnit(int index, Integer tierStartingUnit) {
            this.params.addOpt("tiers[starting_unit][" + index + "]", tierStartingUnit);
            return this;
        }

        public CreateRequest tierEndingUnit(int index, Integer tierEndingUnit) {
            this.params.addOpt("tiers[ending_unit][" + index + "]", tierEndingUnit);
            return this;
        }

        public CreateRequest tierPrice(int index, Long tierPrice) {
            this.params.addOpt("tiers[price][" + index + "]", tierPrice);
            return this;
        }

        public CreateRequest tierStartingUnitInDecimal(int index, String tierStartingUnitInDecimal) {
            this.params.addOpt("tiers[starting_unit_in_decimal][" + index + "]", tierStartingUnitInDecimal);
            return this;
        }

        public CreateRequest tierEndingUnitInDecimal(int index, String tierEndingUnitInDecimal) {
            this.params.addOpt("tiers[ending_unit_in_decimal][" + index + "]", tierEndingUnitInDecimal);
            return this;
        }

        public CreateRequest tierPriceInDecimal(int index, String tierPriceInDecimal) {
            this.params.addOpt("tiers[price_in_decimal][" + index + "]", tierPriceInDecimal);
            return this;
        }

        public CreateRequest taxProvidersFieldProviderName(int index, String taxProvidersFieldProviderName) {
            this.params.add("tax_providers_fields[provider_name][" + index + "]", taxProvidersFieldProviderName);
            return this;
        }

        public CreateRequest taxProvidersFieldFieldId(int index, String taxProvidersFieldFieldId) {
            this.params.add("tax_providers_fields[field_id][" + index + "]", taxProvidersFieldFieldId);
            return this;
        }

        public CreateRequest taxProvidersFieldFieldValue(int index, String taxProvidersFieldFieldValue) {
            this.params.add("tax_providers_fields[field_value][" + index + "]", taxProvidersFieldFieldValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class TaxProvidersField
    extends Resource<TaxProvidersField> {
        public TaxProvidersField(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String providerName() {
            return this.reqString("provider_name");
        }

        public String fieldId() {
            return this.reqString("field_id");
        }

        public String fieldValue() {
            return this.reqString("field_value");
        }
    }

    public static class Tier
    extends Resource<Tier> {
        public Tier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Long price() {
            return this.reqLong("price");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String priceInDecimal() {
            return this.optString("price_in_decimal");
        }
    }

    public static enum ProrationType {
        SITE_DEFAULT,
        PARTIAL_TERM,
        FULL_TERM,
        _UNKNOWN;

    }

    public static enum ShippingFrequencyPeriodUnit {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        _UNKNOWN;

    }

    public static enum Status {
        ACTIVE,
        ARCHIVED,
        DELETED,
        _UNKNOWN;

    }

    public static enum PeriodUnit {
        DAY,
        WEEK,
        MONTH,
        YEAR,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    public static enum ChargeType {
        RECURRING,
        NON_RECURRING,
        _UNKNOWN;

    }

    @Deprecated
    public static enum Type {
        ON_OFF,
        QUANTITY,
        TIERED,
        VOLUME,
        STAIRSTEP,
        _UNKNOWN;

    }
}

