/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class BusinessEntity
extends Resource<BusinessEntity> {
    public BusinessEntity(String jsonStr) {
        super(jsonStr);
    }

    public BusinessEntity(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public static CreateTransfersRequest createTransfers() {
        String uri = BusinessEntity.uri("business_entities", "transfers");
        return new CreateTransfersRequest(HttpUtil.Method.POST, uri);
    }

    public static BusinessEntityGetTransfersRequest getTransfers() {
        String uri = BusinessEntity.uri("business_entities", "transfers");
        return new BusinessEntityGetTransfersRequest(uri);
    }

    public static class BusinessEntityGetTransfersRequest
    extends ListRequest<BusinessEntityGetTransfersRequest> {
        private BusinessEntityGetTransfersRequest(String uri) {
            super(uri);
        }

        public StringFilter<BusinessEntityGetTransfersRequest> resourceType() {
            return new StringFilter<BusinessEntityGetTransfersRequest>("resource_type", this);
        }

        public StringFilter<BusinessEntityGetTransfersRequest> resourceId() {
            return new StringFilter<BusinessEntityGetTransfersRequest>("resource_id", this);
        }

        public StringFilter<BusinessEntityGetTransfersRequest> activeResourceId() {
            return new StringFilter<BusinessEntityGetTransfersRequest>("active_resource_id", this);
        }

        public TimestampFilter<BusinessEntityGetTransfersRequest> createdAt() {
            return new TimestampFilter<BusinessEntityGetTransfersRequest>("created_at", this);
        }

        public BusinessEntityGetTransfersRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateTransfersRequest
    extends Request<CreateTransfersRequest> {
        private CreateTransfersRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateTransfersRequest activeResourceIds(List<String> activeResourceIds) {
            this.params.add("active_resource_ids", activeResourceIds);
            return this;
        }

        public CreateTransfersRequest activeResourceIds(String ... activeResourceIds) {
            this.params.add("active_resource_ids", activeResourceIds);
            return this;
        }

        public CreateTransfersRequest destinationBusinessEntityIds(List<String> destinationBusinessEntityIds) {
            this.params.add("destination_business_entity_ids", destinationBusinessEntityIds);
            return this;
        }

        public CreateTransfersRequest destinationBusinessEntityIds(String ... destinationBusinessEntityIds) {
            this.params.add("destination_business_entity_ids", destinationBusinessEntityIds);
            return this;
        }

        @Deprecated
        public CreateTransfersRequest sourceBusinessEntityIds(List<String> sourceBusinessEntityIds) {
            this.params.addOpt("source_business_entity_ids", sourceBusinessEntityIds);
            return this;
        }

        @Deprecated
        public CreateTransfersRequest sourceBusinessEntityIds(String ... sourceBusinessEntityIds) {
            this.params.addOpt("source_business_entity_ids", sourceBusinessEntityIds);
            return this;
        }

        @Deprecated
        public CreateTransfersRequest resourceTypes(List<String> resourceTypes) {
            this.params.add("resource_types", resourceTypes);
            return this;
        }

        @Deprecated
        public CreateTransfersRequest resourceTypes(String ... resourceTypes) {
            this.params.add("resource_types", resourceTypes);
            return this;
        }

        public CreateTransfersRequest reasonCodes(List<String> reasonCodes) {
            this.params.add("reason_codes", reasonCodes);
            return this;
        }

        public CreateTransfersRequest reasonCodes(String ... reasonCodes) {
            this.params.add("reason_codes", reasonCodes);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum Status {
        ACTIVE,
        INACTIVE,
        _UNKNOWN;

    }
}

