/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Tax1JurisType;
import com.chargebee.models.enums.Tax2JurisType;
import com.chargebee.models.enums.Tax3JurisType;
import com.chargebee.models.enums.Tax4JurisType;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class CsvTaxRule
extends Resource<CsvTaxRule> {
    public CsvTaxRule(String jsonStr) {
        super(jsonStr);
    }

    public CsvTaxRule(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String taxProfileName() {
        return this.optString("tax_profile_name");
    }

    public String country() {
        return this.optString("country");
    }

    public String state() {
        return this.optString("state");
    }

    public String zipCode() {
        return this.optString("zip_code");
    }

    public Integer zipCodeStart() {
        return this.optInteger("zip_code_start");
    }

    public Integer zipCodeEnd() {
        return this.optInteger("zip_code_end");
    }

    public String tax1Name() {
        return this.reqString("tax1_name");
    }

    public Double tax1Rate() {
        return this.reqDouble("tax1_rate");
    }

    public Tax1JurisType tax1JurisType() {
        return this.optEnum("tax1_juris_type", Tax1JurisType.class);
    }

    public String tax1JurisName() {
        return this.optString("tax1_juris_name");
    }

    public String tax1JurisCode() {
        return this.optString("tax1_juris_code");
    }

    public String tax2Name() {
        return this.optString("tax2_name");
    }

    public Double tax2Rate() {
        return this.optDouble("tax2_rate");
    }

    public Tax2JurisType tax2JurisType() {
        return this.optEnum("tax2_juris_type", Tax2JurisType.class);
    }

    public String tax2JurisName() {
        return this.optString("tax2_juris_name");
    }

    public String tax2JurisCode() {
        return this.optString("tax2_juris_code");
    }

    public String tax3Name() {
        return this.optString("tax3_name");
    }

    public Double tax3Rate() {
        return this.optDouble("tax3_rate");
    }

    public Tax3JurisType tax3JurisType() {
        return this.optEnum("tax3_juris_type", Tax3JurisType.class);
    }

    public String tax3JurisName() {
        return this.optString("tax3_juris_name");
    }

    public String tax3JurisCode() {
        return this.optString("tax3_juris_code");
    }

    public String tax4Name() {
        return this.optString("tax4_name");
    }

    public Double tax4Rate() {
        return this.optDouble("tax4_rate");
    }

    public Tax4JurisType tax4JurisType() {
        return this.optEnum("tax4_juris_type", Tax4JurisType.class);
    }

    public String tax4JurisName() {
        return this.optString("tax4_juris_name");
    }

    public String tax4JurisCode() {
        return this.optString("tax4_juris_code");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public String timeZone() {
        return this.optString("time_zone");
    }

    public Timestamp validFrom() {
        return this.optTimestamp("valid_from");
    }

    public Timestamp validTill() {
        return this.optTimestamp("valid_till");
    }

    public ServiceType serviceType() {
        return this.optEnum("service_type", ServiceType.class);
    }

    public Integer ruleWeight() {
        return this.optInteger("rule_weight");
    }

    public Boolean overwrite() {
        return this.reqBoolean("overwrite");
    }

    public static CreateRequest create() {
        String uri = CsvTaxRule.uri("csv_tax_rules");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest taxProfileName(String taxProfileName) {
            this.params.addOpt("tax_profile_name", taxProfileName);
            return this;
        }

        public CreateRequest country(String country) {
            this.params.addOpt("country", country);
            return this;
        }

        public CreateRequest state(String state) {
            this.params.addOpt("state", state);
            return this;
        }

        public CreateRequest zipCode(String zipCode) {
            this.params.addOpt("zip_code", zipCode);
            return this;
        }

        public CreateRequest zipCodeStart(Integer zipCodeStart) {
            this.params.addOpt("zip_code_start", zipCodeStart);
            return this;
        }

        public CreateRequest zipCodeEnd(Integer zipCodeEnd) {
            this.params.addOpt("zip_code_end", zipCodeEnd);
            return this;
        }

        public CreateRequest tax1Name(String tax1Name) {
            this.params.addOpt("tax1_name", tax1Name);
            return this;
        }

        public CreateRequest tax1Rate(Double tax1Rate) {
            this.params.addOpt("tax1_rate", tax1Rate);
            return this;
        }

        public CreateRequest tax1JurisType(Tax1JurisType tax1JurisType) {
            this.params.addOpt("tax1_juris_type", (Object)tax1JurisType);
            return this;
        }

        public CreateRequest tax1JurisName(String tax1JurisName) {
            this.params.addOpt("tax1_juris_name", tax1JurisName);
            return this;
        }

        public CreateRequest tax1JurisCode(String tax1JurisCode) {
            this.params.addOpt("tax1_juris_code", tax1JurisCode);
            return this;
        }

        public CreateRequest tax2Name(String tax2Name) {
            this.params.addOpt("tax2_name", tax2Name);
            return this;
        }

        public CreateRequest tax2Rate(Double tax2Rate) {
            this.params.addOpt("tax2_rate", tax2Rate);
            return this;
        }

        public CreateRequest tax2JurisType(Tax2JurisType tax2JurisType) {
            this.params.addOpt("tax2_juris_type", (Object)tax2JurisType);
            return this;
        }

        public CreateRequest tax2JurisName(String tax2JurisName) {
            this.params.addOpt("tax2_juris_name", tax2JurisName);
            return this;
        }

        public CreateRequest tax2JurisCode(String tax2JurisCode) {
            this.params.addOpt("tax2_juris_code", tax2JurisCode);
            return this;
        }

        public CreateRequest tax3Name(String tax3Name) {
            this.params.addOpt("tax3_name", tax3Name);
            return this;
        }

        public CreateRequest tax3Rate(Double tax3Rate) {
            this.params.addOpt("tax3_rate", tax3Rate);
            return this;
        }

        public CreateRequest tax3JurisType(Tax3JurisType tax3JurisType) {
            this.params.addOpt("tax3_juris_type", (Object)tax3JurisType);
            return this;
        }

        public CreateRequest tax3JurisName(String tax3JurisName) {
            this.params.addOpt("tax3_juris_name", tax3JurisName);
            return this;
        }

        public CreateRequest tax3JurisCode(String tax3JurisCode) {
            this.params.addOpt("tax3_juris_code", tax3JurisCode);
            return this;
        }

        public CreateRequest tax4Name(String tax4Name) {
            this.params.addOpt("tax4_name", tax4Name);
            return this;
        }

        public CreateRequest tax4Rate(Double tax4Rate) {
            this.params.addOpt("tax4_rate", tax4Rate);
            return this;
        }

        public CreateRequest tax4JurisType(Tax4JurisType tax4JurisType) {
            this.params.addOpt("tax4_juris_type", (Object)tax4JurisType);
            return this;
        }

        public CreateRequest tax4JurisName(String tax4JurisName) {
            this.params.addOpt("tax4_juris_name", tax4JurisName);
            return this;
        }

        public CreateRequest tax4JurisCode(String tax4JurisCode) {
            this.params.addOpt("tax4_juris_code", tax4JurisCode);
            return this;
        }

        public CreateRequest serviceType(ServiceType serviceType) {
            this.params.addOpt("service_type", (Object)serviceType);
            return this;
        }

        public CreateRequest timeZone(String timeZone) {
            this.params.addOpt("time_zone", timeZone);
            return this;
        }

        public CreateRequest validFrom(Timestamp validFrom) {
            this.params.addOpt("valid_from", validFrom);
            return this;
        }

        public CreateRequest validTill(Timestamp validTill) {
            this.params.addOpt("valid_till", validTill);
            return this;
        }

        public CreateRequest overwrite(Boolean overwrite) {
            this.params.addOpt("overwrite", overwrite);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum ServiceType {
        DIGITAL,
        OTHER,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    public static enum Status {
        ACTIVE,
        EXPIRED,
        SCHEDULED,
        _UNKNOWN;

    }
}

