/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Action;
import com.chargebee.org.json.JSONObject;

public class Entitlement
extends Resource<Entitlement> {
    public Entitlement(String jsonStr) {
        super(jsonStr);
    }

    public Entitlement(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String entityId() {
        return this.optString("entity_id");
    }

    public EntityType entityType() {
        return this.optEnum("entity_type", EntityType.class);
    }

    public String featureId() {
        return this.optString("feature_id");
    }

    public String featureName() {
        return this.optString("feature_name");
    }

    public String value() {
        return this.optString("value");
    }

    public String name() {
        return this.optString("name");
    }

    public static EntitlementListRequest list() {
        String uri = Entitlement.uri("entitlements");
        return new EntitlementListRequest(uri);
    }

    public static CreateRequest create() {
        String uri = Entitlement.uri("entitlements");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest action(Action action) {
            this.params.add("action", (Object)action);
            return this;
        }

        public CreateRequest entitlementEntityId(int index, String entitlementEntityId) {
            this.params.add("entitlements[entity_id][" + index + "]", entitlementEntityId);
            return this;
        }

        public CreateRequest entitlementFeatureId(int index, String entitlementFeatureId) {
            this.params.add("entitlements[feature_id][" + index + "]", entitlementFeatureId);
            return this;
        }

        public CreateRequest entitlementEntityType(int index, EntityType entitlementEntityType) {
            this.params.addOpt("entitlements[entity_type][" + index + "]", (Object)entitlementEntityType);
            return this;
        }

        public CreateRequest entitlementValue(int index, String entitlementValue) {
            this.params.addOpt("entitlements[value][" + index + "]", entitlementValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class EntitlementListRequest
    extends ListRequest<EntitlementListRequest> {
        private EntitlementListRequest(String uri) {
            super(uri);
        }

        public StringFilter<EntitlementListRequest> featureId() {
            return new StringFilter<EntitlementListRequest>("feature_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<EntityType, EntitlementListRequest> entityType() {
            return new EnumFilter("entity_type", this).supportsMultiOperators(true);
        }

        public StringFilter<EntitlementListRequest> entityId() {
            return new StringFilter<EntitlementListRequest>("entity_id", this).supportsMultiOperators(true);
        }

        @Deprecated
        public EntitlementListRequest includeDrafts(Boolean includeDrafts) {
            this.params.addOpt("include_drafts", includeDrafts);
            return this;
        }

        @Deprecated
        public EntitlementListRequest embed(String embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum EntityType {
        PLAN,
        ADDON,
        CHARGE,
        PLAN_PRICE,
        ADDON_PRICE,
        _UNKNOWN;

    }
}

