/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.Addon;
import com.chargebee.models.AttachedItem;
import com.chargebee.models.Coupon;
import com.chargebee.models.CreditNote;
import com.chargebee.models.Invoice;
import com.chargebee.models.Item;
import com.chargebee.models.ItemPrice;
import com.chargebee.models.Order;
import com.chargebee.models.Plan;
import com.chargebee.models.PriceVariant;
import com.chargebee.models.Subscription;
import com.chargebee.models.Transaction;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.Channel;
import com.chargebee.models.enums.ChargeOnEvent;
import com.chargebee.models.enums.ExportType;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.ItemType;
import com.chargebee.models.enums.OfflinePaymentMethod;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.models.enums.ReportBy;
import com.chargebee.models.enums.Taxability;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class Export
extends Resource<Export> {
    public Export(String jsonStr) {
        super(jsonStr);
    }

    public Export(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String operationType() {
        return this.reqString("operation_type");
    }

    public MimeType mimeType() {
        return this.reqEnum("mime_type", MimeType.class);
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Download download() {
        return this.optSubResource("download", Download.class);
    }

    public static Request retrieve(String id) {
        String uri = Export.uri("exports", Export.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static RevenueRecognitionRequest revenueRecognition() {
        String uri = Export.uri("exports", "revenue_recognition");
        return new RevenueRecognitionRequest(HttpUtil.Method.POST, uri);
    }

    public static DeferredRevenueRequest deferredRevenue() {
        String uri = Export.uri("exports", "deferred_revenue");
        return new DeferredRevenueRequest(HttpUtil.Method.POST, uri);
    }

    public static PlansRequest plans() {
        String uri = Export.uri("exports", "plans");
        return new PlansRequest(HttpUtil.Method.POST, uri);
    }

    public static AddonsRequest addons() {
        String uri = Export.uri("exports", "addons");
        return new AddonsRequest(HttpUtil.Method.POST, uri);
    }

    public static CouponsRequest coupons() {
        String uri = Export.uri("exports", "coupons");
        return new CouponsRequest(HttpUtil.Method.POST, uri);
    }

    public static CustomersRequest customers() {
        String uri = Export.uri("exports", "customers");
        return new CustomersRequest(HttpUtil.Method.POST, uri);
    }

    public static SubscriptionsRequest subscriptions() {
        String uri = Export.uri("exports", "subscriptions");
        return new SubscriptionsRequest(HttpUtil.Method.POST, uri);
    }

    public static InvoicesRequest invoices() {
        String uri = Export.uri("exports", "invoices");
        return new InvoicesRequest(HttpUtil.Method.POST, uri);
    }

    public static CreditNotesRequest creditNotes() {
        String uri = Export.uri("exports", "credit_notes");
        return new CreditNotesRequest(HttpUtil.Method.POST, uri);
    }

    public static TransactionsRequest transactions() {
        String uri = Export.uri("exports", "transactions");
        return new TransactionsRequest(HttpUtil.Method.POST, uri);
    }

    public static OrdersRequest orders() {
        String uri = Export.uri("exports", "orders");
        return new OrdersRequest(HttpUtil.Method.POST, uri);
    }

    public static ItemFamiliesRequest itemFamilies() {
        String uri = Export.uri("exports", "item_families");
        return new ItemFamiliesRequest(HttpUtil.Method.POST, uri);
    }

    public static ItemsRequest items() {
        String uri = Export.uri("exports", "items");
        return new ItemsRequest(HttpUtil.Method.POST, uri);
    }

    public static ItemPricesRequest itemPrices() {
        String uri = Export.uri("exports", "item_prices");
        return new ItemPricesRequest(HttpUtil.Method.POST, uri);
    }

    public static AttachedItemsRequest attachedItems() {
        String uri = Export.uri("exports", "attached_items");
        return new AttachedItemsRequest(HttpUtil.Method.POST, uri);
    }

    public static DifferentialPricesRequest differentialPrices() {
        String uri = Export.uri("exports", "differential_prices");
        return new DifferentialPricesRequest(HttpUtil.Method.POST, uri);
    }

    public static PriceVariantsRequest priceVariants() {
        String uri = Export.uri("exports", "price_variants");
        return new PriceVariantsRequest(HttpUtil.Method.POST, uri);
    }

    public Export waitForExportCompletion() throws Exception {
        int count = 0;
        int sleepTime = Integer.getInteger("cb.java.export.sleep.millis", 10000);
        while (this.status() == Status.IN_PROCESS) {
            if (count++ > 50) {
                throw new RuntimeException("Export is taking too long");
            }
            Thread.sleep(sleepTime);
            Request req = Export.retrieve(this.id());
            this.jsonObj = req.request().export().jsonObj;
        }
        return this;
    }

    public static class PriceVariantsRequest
    extends Request<PriceVariantsRequest> {
        private PriceVariantsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<PriceVariantsRequest> businessEntityId() {
            return new StringFilter<PriceVariantsRequest>("business_entity_id", this).supportsPresenceOperator(true);
        }

        public BooleanFilter<PriceVariantsRequest> includeSiteLevelResources() {
            return new BooleanFilter<PriceVariantsRequest>("include_site_level_resources", this);
        }

        public StringFilter<PriceVariantsRequest> priceVariantId() {
            return new StringFilter<PriceVariantsRequest>("price_variant[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<PriceVariantsRequest> priceVariantName() {
            return new StringFilter<PriceVariantsRequest>("price_variant[name]", this).supportsMultiOperators(true);
        }

        public EnumFilter<PriceVariant.Status, PriceVariantsRequest> priceVariantStatus() {
            return new EnumFilter<PriceVariant.Status, PriceVariantsRequest>("price_variant[status]", this);
        }

        public TimestampFilter<PriceVariantsRequest> priceVariantUpdatedAt() {
            return new TimestampFilter<PriceVariantsRequest>("price_variant[updated_at]", this);
        }

        public TimestampFilter<PriceVariantsRequest> priceVariantCreatedAt() {
            return new TimestampFilter<PriceVariantsRequest>("price_variant[created_at]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class DifferentialPricesRequest
    extends Request<DifferentialPricesRequest> {
        private DifferentialPricesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<DifferentialPricesRequest> itemId() {
            return new StringFilter<DifferentialPricesRequest>("item_id", this).supportsMultiOperators(true);
        }

        public StringFilter<DifferentialPricesRequest> differentialPriceItemPriceId() {
            return new StringFilter<DifferentialPricesRequest>("differential_price[item_price_id]", this).supportsMultiOperators(true);
        }

        public StringFilter<DifferentialPricesRequest> differentialPriceId() {
            return new StringFilter<DifferentialPricesRequest>("differential_price[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<DifferentialPricesRequest> differentialPriceParentItemId() {
            return new StringFilter<DifferentialPricesRequest>("differential_price[parent_item_id]", this).supportsMultiOperators(true);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AttachedItemsRequest
    extends Request<AttachedItemsRequest> {
        private AttachedItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public EnumFilter<ItemType, AttachedItemsRequest> itemType() {
            return new EnumFilter<ItemType, AttachedItemsRequest>("item_type", this);
        }

        public StringFilter<AttachedItemsRequest> attachedItemId() {
            return new StringFilter<AttachedItemsRequest>("attached_item[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<AttachedItemsRequest> attachedItemItemId() {
            return new StringFilter<AttachedItemsRequest>("attached_item[item_id]", this).supportsMultiOperators(true);
        }

        public EnumFilter<AttachedItem.Type, AttachedItemsRequest> attachedItemType() {
            return new EnumFilter<AttachedItem.Type, AttachedItemsRequest>("attached_item[type]", this);
        }

        public EnumFilter<ChargeOnEvent, AttachedItemsRequest> attachedItemChargeOnEvent() {
            return new EnumFilter<ChargeOnEvent, AttachedItemsRequest>("attached_item[charge_on_event]", this);
        }

        public TimestampFilter<AttachedItemsRequest> attachedItemUpdatedAt() {
            return new TimestampFilter<AttachedItemsRequest>("attached_item[updated_at]", this);
        }

        public StringFilter<AttachedItemsRequest> attachedItemParentItemId() {
            return new StringFilter<AttachedItemsRequest>("attached_item[parent_item_id]", this).supportsMultiOperators(true);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ItemPricesRequest
    extends Request<ItemPricesRequest> {
        private ItemPricesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<ItemPricesRequest> itemFamilyId() {
            return new StringFilter<ItemPricesRequest>("item_family_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<ItemType, ItemPricesRequest> itemType() {
            return new EnumFilter<ItemType, ItemPricesRequest>("item_type", this);
        }

        public StringFilter<ItemPricesRequest> currencyCode() {
            return new StringFilter<ItemPricesRequest>("currency_code", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemPricesRequest> businessEntityId() {
            return new StringFilter<ItemPricesRequest>("business_entity_id", this).supportsPresenceOperator(true);
        }

        public BooleanFilter<ItemPricesRequest> includeSiteLevelResources() {
            return new BooleanFilter<ItemPricesRequest>("include_site_level_resources", this);
        }

        public StringFilter<ItemPricesRequest> itemPriceId() {
            return new StringFilter<ItemPricesRequest>("item_price[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemPricesRequest> itemPriceName() {
            return new StringFilter<ItemPricesRequest>("item_price[name]", this).supportsMultiOperators(true);
        }

        public EnumFilter<PricingModel, ItemPricesRequest> itemPricePricingModel() {
            return new EnumFilter<PricingModel, ItemPricesRequest>("item_price[pricing_model]", this);
        }

        public StringFilter<ItemPricesRequest> itemPriceItemId() {
            return new StringFilter<ItemPricesRequest>("item_price[item_id]", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemPricesRequest> itemPricePriceVariantId() {
            return new StringFilter<ItemPricesRequest>("item_price[price_variant_id]", this).supportsMultiOperators(true);
        }

        public NumberFilter<Integer, ItemPricesRequest> itemPriceTrialPeriod() {
            return new NumberFilter<Integer, ItemPricesRequest>("item_price[trial_period]", this);
        }

        public EnumFilter<ItemPrice.TrialPeriodUnit, ItemPricesRequest> itemPriceTrialPeriodUnit() {
            return new EnumFilter<ItemPrice.TrialPeriodUnit, ItemPricesRequest>("item_price[trial_period_unit]", this);
        }

        public EnumFilter<ItemPrice.Status, ItemPricesRequest> itemPriceStatus() {
            return new EnumFilter<ItemPrice.Status, ItemPricesRequest>("item_price[status]", this);
        }

        public TimestampFilter<ItemPricesRequest> itemPriceUpdatedAt() {
            return new TimestampFilter<ItemPricesRequest>("item_price[updated_at]", this);
        }

        public EnumFilter<ItemPrice.PeriodUnit, ItemPricesRequest> itemPricePeriodUnit() {
            return new EnumFilter<ItemPrice.PeriodUnit, ItemPricesRequest>("item_price[period_unit]", this);
        }

        public NumberFilter<Integer, ItemPricesRequest> itemPricePeriod() {
            return new NumberFilter<Integer, ItemPricesRequest>("item_price[period]", this);
        }

        public EnumFilter<Channel, ItemPricesRequest> itemPriceChannel() {
            return new EnumFilter<Channel, ItemPricesRequest>("item_price[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ItemsRequest
    extends Request<ItemsRequest> {
        private ItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<ItemsRequest> businessEntityId() {
            return new StringFilter<ItemsRequest>("business_entity_id", this).supportsPresenceOperator(true);
        }

        public BooleanFilter<ItemsRequest> includeSiteLevelResources() {
            return new BooleanFilter<ItemsRequest>("include_site_level_resources", this);
        }

        public StringFilter<ItemsRequest> itemId() {
            return new StringFilter<ItemsRequest>("item[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemsRequest> itemItemFamilyId() {
            return new StringFilter<ItemsRequest>("item[item_family_id]", this).supportsMultiOperators(true);
        }

        public EnumFilter<Item.Type, ItemsRequest> itemType() {
            return new EnumFilter<Item.Type, ItemsRequest>("item[type]", this);
        }

        public StringFilter<ItemsRequest> itemName() {
            return new StringFilter<ItemsRequest>("item[name]", this);
        }

        public EnumFilter<Item.ItemApplicability, ItemsRequest> itemItemApplicability() {
            return new EnumFilter<Item.ItemApplicability, ItemsRequest>("item[item_applicability]", this);
        }

        public EnumFilter<Item.Status, ItemsRequest> itemStatus() {
            return new EnumFilter<Item.Status, ItemsRequest>("item[status]", this);
        }

        public BooleanFilter<ItemsRequest> itemIsGiftable() {
            return new BooleanFilter<ItemsRequest>("item[is_giftable]", this);
        }

        public TimestampFilter<ItemsRequest> itemUpdatedAt() {
            return new TimestampFilter<ItemsRequest>("item[updated_at]", this);
        }

        public BooleanFilter<ItemsRequest> itemEnabledForCheckout() {
            return new BooleanFilter<ItemsRequest>("item[enabled_for_checkout]", this);
        }

        public BooleanFilter<ItemsRequest> itemEnabledInPortal() {
            return new BooleanFilter<ItemsRequest>("item[enabled_in_portal]", this);
        }

        public BooleanFilter<ItemsRequest> itemMetered() {
            return new BooleanFilter<ItemsRequest>("item[metered]", this);
        }

        public EnumFilter<Item.UsageCalculation, ItemsRequest> itemUsageCalculation() {
            return new EnumFilter<Item.UsageCalculation, ItemsRequest>("item[usage_calculation]", this);
        }

        public EnumFilter<Channel, ItemsRequest> itemChannel() {
            return new EnumFilter<Channel, ItemsRequest>("item[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ItemFamiliesRequest
    extends Request<ItemFamiliesRequest> {
        private ItemFamiliesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<ItemFamiliesRequest> businessEntityId() {
            return new StringFilter<ItemFamiliesRequest>("business_entity_id", this).supportsPresenceOperator(true);
        }

        public BooleanFilter<ItemFamiliesRequest> includeSiteLevelResources() {
            return new BooleanFilter<ItemFamiliesRequest>("include_site_level_resources", this);
        }

        public StringFilter<ItemFamiliesRequest> itemFamilyId() {
            return new StringFilter<ItemFamiliesRequest>("item_family[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<ItemFamiliesRequest> itemFamilyName() {
            return new StringFilter<ItemFamiliesRequest>("item_family[name]", this);
        }

        public TimestampFilter<ItemFamiliesRequest> itemFamilyUpdatedAt() {
            return new TimestampFilter<ItemFamiliesRequest>("item_family[updated_at]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class OrdersRequest
    extends Request<OrdersRequest> {
        private OrdersRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public NumberFilter<Long, OrdersRequest> total() {
            return new NumberFilter<Long, OrdersRequest>("total", this);
        }

        public StringFilter<OrdersRequest> orderId() {
            return new StringFilter<OrdersRequest>("order[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<OrdersRequest> orderSubscriptionId() {
            return new StringFilter<OrdersRequest>("order[subscription_id]", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<OrdersRequest> orderCustomerId() {
            return new StringFilter<OrdersRequest>("order[customer_id]", this).supportsMultiOperators(true);
        }

        public EnumFilter<Order.Status, OrdersRequest> orderStatus() {
            return new EnumFilter<Order.Status, OrdersRequest>("order[status]", this);
        }

        public EnumFilter<PriceType, OrdersRequest> orderPriceType() {
            return new EnumFilter<PriceType, OrdersRequest>("order[price_type]", this);
        }

        public TimestampFilter<OrdersRequest> orderOrderDate() {
            return new TimestampFilter<OrdersRequest>("order[order_date]", this);
        }

        public TimestampFilter<OrdersRequest> orderShippingDate() {
            return new TimestampFilter<OrdersRequest>("order[shipping_date]", this);
        }

        public TimestampFilter<OrdersRequest> orderShippedAt() {
            return new TimestampFilter<OrdersRequest>("order[shipped_at]", this);
        }

        public TimestampFilter<OrdersRequest> orderDeliveredAt() {
            return new TimestampFilter<OrdersRequest>("order[delivered_at]", this);
        }

        public TimestampFilter<OrdersRequest> orderCancelledAt() {
            return new TimestampFilter<OrdersRequest>("order[cancelled_at]", this);
        }

        public NumberFilter<Long, OrdersRequest> orderAmountPaid() {
            return new NumberFilter<Long, OrdersRequest>("order[amount_paid]", this);
        }

        public NumberFilter<Long, OrdersRequest> orderRefundableCredits() {
            return new NumberFilter<Long, OrdersRequest>("order[refundable_credits]", this);
        }

        public NumberFilter<Long, OrdersRequest> orderRefundableCreditsIssued() {
            return new NumberFilter<Long, OrdersRequest>("order[refundable_credits_issued]", this);
        }

        public TimestampFilter<OrdersRequest> orderUpdatedAt() {
            return new TimestampFilter<OrdersRequest>("order[updated_at]", this);
        }

        public EnumFilter<Order.ResentStatus, OrdersRequest> orderResentStatus() {
            return new EnumFilter<Order.ResentStatus, OrdersRequest>("order[resent_status]", this);
        }

        public BooleanFilter<OrdersRequest> orderIsResent() {
            return new BooleanFilter<OrdersRequest>("order[is_resent]", this);
        }

        public StringFilter<OrdersRequest> orderOriginalOrderId() {
            return new StringFilter<OrdersRequest>("order[original_order_id]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class TransactionsRequest
    extends Request<TransactionsRequest> {
        private TransactionsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<TransactionsRequest> transactionId() {
            return new StringFilter<TransactionsRequest>("transaction[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<TransactionsRequest> transactionCustomerId() {
            return new StringFilter<TransactionsRequest>("transaction[customer_id]", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<TransactionsRequest> transactionSubscriptionId() {
            return new StringFilter<TransactionsRequest>("transaction[subscription_id]", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<TransactionsRequest> transactionPaymentSourceId() {
            return new StringFilter<TransactionsRequest>("transaction[payment_source_id]", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public EnumFilter<PaymentMethod, TransactionsRequest> transactionPaymentMethod() {
            return new EnumFilter<PaymentMethod, TransactionsRequest>("transaction[payment_method]", this);
        }

        public EnumFilter<Gateway, TransactionsRequest> transactionGateway() {
            return new EnumFilter<Gateway, TransactionsRequest>("transaction[gateway]", this);
        }

        public StringFilter<TransactionsRequest> transactionGatewayAccountId() {
            return new StringFilter<TransactionsRequest>("transaction[gateway_account_id]", this).supportsMultiOperators(true);
        }

        public StringFilter<TransactionsRequest> transactionIdAtGateway() {
            return new StringFilter<TransactionsRequest>("transaction[id_at_gateway]", this);
        }

        public StringFilter<TransactionsRequest> transactionReferenceNumber() {
            return new StringFilter<TransactionsRequest>("transaction[reference_number]", this).supportsPresenceOperator(true);
        }

        public EnumFilter<Transaction.Type, TransactionsRequest> transactionType() {
            return new EnumFilter<Transaction.Type, TransactionsRequest>("transaction[type]", this);
        }

        public TimestampFilter<TransactionsRequest> transactionDate() {
            return new TimestampFilter<TransactionsRequest>("transaction[date]", this);
        }

        public NumberFilter<Long, TransactionsRequest> transactionAmount() {
            return new NumberFilter<Long, TransactionsRequest>("transaction[amount]", this);
        }

        public NumberFilter<Long, TransactionsRequest> transactionAmountCapturable() {
            return new NumberFilter<Long, TransactionsRequest>("transaction[amount_capturable]", this);
        }

        public EnumFilter<Transaction.Status, TransactionsRequest> transactionStatus() {
            return new EnumFilter<Transaction.Status, TransactionsRequest>("transaction[status]", this);
        }

        public TimestampFilter<TransactionsRequest> transactionUpdatedAt() {
            return new TimestampFilter<TransactionsRequest>("transaction[updated_at]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreditNotesRequest
    extends Request<CreditNotesRequest> {
        private CreditNotesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<CreditNotesRequest> creditNoteId() {
            return new StringFilter<CreditNotesRequest>("credit_note[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<CreditNotesRequest> creditNoteCustomerId() {
            return new StringFilter<CreditNotesRequest>("credit_note[customer_id]", this).supportsMultiOperators(true);
        }

        public StringFilter<CreditNotesRequest> creditNoteSubscriptionId() {
            return new StringFilter<CreditNotesRequest>("credit_note[subscription_id]", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<CreditNotesRequest> creditNoteReferenceInvoiceId() {
            return new StringFilter<CreditNotesRequest>("credit_note[reference_invoice_id]", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public EnumFilter<CreditNote.Type, CreditNotesRequest> creditNoteType() {
            return new EnumFilter<CreditNote.Type, CreditNotesRequest>("credit_note[type]", this);
        }

        public EnumFilter<CreditNote.ReasonCode, CreditNotesRequest> creditNoteReasonCode() {
            return new EnumFilter<CreditNote.ReasonCode, CreditNotesRequest>("credit_note[reason_code]", this);
        }

        public StringFilter<CreditNotesRequest> creditNoteCreateReasonCode() {
            return new StringFilter<CreditNotesRequest>("credit_note[create_reason_code]", this).supportsMultiOperators(true);
        }

        public EnumFilter<CreditNote.Status, CreditNotesRequest> creditNoteStatus() {
            return new EnumFilter<CreditNote.Status, CreditNotesRequest>("credit_note[status]", this);
        }

        public TimestampFilter<CreditNotesRequest> creditNoteDate() {
            return new TimestampFilter<CreditNotesRequest>("credit_note[date]", this);
        }

        public NumberFilter<Long, CreditNotesRequest> creditNoteTotal() {
            return new NumberFilter<Long, CreditNotesRequest>("credit_note[total]", this);
        }

        public EnumFilter<PriceType, CreditNotesRequest> creditNotePriceType() {
            return new EnumFilter<PriceType, CreditNotesRequest>("credit_note[price_type]", this);
        }

        public NumberFilter<Long, CreditNotesRequest> creditNoteAmountAllocated() {
            return new NumberFilter<Long, CreditNotesRequest>("credit_note[amount_allocated]", this);
        }

        public NumberFilter<Long, CreditNotesRequest> creditNoteAmountRefunded() {
            return new NumberFilter<Long, CreditNotesRequest>("credit_note[amount_refunded]", this);
        }

        public NumberFilter<Long, CreditNotesRequest> creditNoteAmountAvailable() {
            return new NumberFilter<Long, CreditNotesRequest>("credit_note[amount_available]", this);
        }

        public TimestampFilter<CreditNotesRequest> creditNoteVoidedAt() {
            return new TimestampFilter<CreditNotesRequest>("credit_note[voided_at]", this);
        }

        public TimestampFilter<CreditNotesRequest> creditNoteUpdatedAt() {
            return new TimestampFilter<CreditNotesRequest>("credit_note[updated_at]", this);
        }

        public EnumFilter<Channel, CreditNotesRequest> creditNoteChannel() {
            return new EnumFilter<Channel, CreditNotesRequest>("credit_note[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class InvoicesRequest
    extends Request<InvoicesRequest> {
        private InvoicesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<InvoicesRequest> paymentOwner() {
            return new StringFilter<InvoicesRequest>("payment_owner", this).supportsMultiOperators(true);
        }

        public StringFilter<InvoicesRequest> invoiceId() {
            return new StringFilter<InvoicesRequest>("invoice[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<InvoicesRequest> invoiceSubscriptionId() {
            return new StringFilter<InvoicesRequest>("invoice[subscription_id]", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<InvoicesRequest> invoiceCustomerId() {
            return new StringFilter<InvoicesRequest>("invoice[customer_id]", this).supportsMultiOperators(true);
        }

        public BooleanFilter<InvoicesRequest> invoiceRecurring() {
            return new BooleanFilter<InvoicesRequest>("invoice[recurring]", this);
        }

        public EnumFilter<Invoice.Status, InvoicesRequest> invoiceStatus() {
            return new EnumFilter<Invoice.Status, InvoicesRequest>("invoice[status]", this);
        }

        public EnumFilter<PriceType, InvoicesRequest> invoicePriceType() {
            return new EnumFilter<PriceType, InvoicesRequest>("invoice[price_type]", this);
        }

        public TimestampFilter<InvoicesRequest> invoiceDate() {
            return new TimestampFilter<InvoicesRequest>("invoice[date]", this);
        }

        public TimestampFilter<InvoicesRequest> invoicePaidAt() {
            return new TimestampFilter<InvoicesRequest>("invoice[paid_at]", this);
        }

        public NumberFilter<Long, InvoicesRequest> invoiceTotal() {
            return new NumberFilter<Long, InvoicesRequest>("invoice[total]", this);
        }

        public NumberFilter<Long, InvoicesRequest> invoiceAmountPaid() {
            return new NumberFilter<Long, InvoicesRequest>("invoice[amount_paid]", this);
        }

        public NumberFilter<Long, InvoicesRequest> invoiceAmountAdjusted() {
            return new NumberFilter<Long, InvoicesRequest>("invoice[amount_adjusted]", this);
        }

        public NumberFilter<Long, InvoicesRequest> invoiceCreditsApplied() {
            return new NumberFilter<Long, InvoicesRequest>("invoice[credits_applied]", this);
        }

        public NumberFilter<Long, InvoicesRequest> invoiceAmountDue() {
            return new NumberFilter<Long, InvoicesRequest>("invoice[amount_due]", this);
        }

        public EnumFilter<Invoice.DunningStatus, InvoicesRequest> invoiceDunningStatus() {
            return new EnumFilter("invoice[dunning_status]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<InvoicesRequest> invoiceUpdatedAt() {
            return new TimestampFilter<InvoicesRequest>("invoice[updated_at]", this);
        }

        public EnumFilter<Channel, InvoicesRequest> invoiceChannel() {
            return new EnumFilter<Channel, InvoicesRequest>("invoice[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class SubscriptionsRequest
    extends Request<SubscriptionsRequest> {
        private SubscriptionsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public SubscriptionsRequest exportType(ExportType exportType) {
            this.params.addOpt("export_type", (Object)exportType);
            return this;
        }

        public StringFilter<SubscriptionsRequest> itemId() {
            return new StringFilter<SubscriptionsRequest>("item_id", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionsRequest> itemPriceId() {
            return new StringFilter<SubscriptionsRequest>("item_price_id", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionsRequest> cancelReasonCode() {
            return new StringFilter<SubscriptionsRequest>("cancel_reason_code", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionsRequest> subscriptionId() {
            return new StringFilter<SubscriptionsRequest>("subscription[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionsRequest> subscriptionCustomerId() {
            return new StringFilter<SubscriptionsRequest>("subscription[customer_id]", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionsRequest> subscriptionPlanId() {
            return new StringFilter<SubscriptionsRequest>("subscription[plan_id]", this).supportsMultiOperators(true);
        }

        public EnumFilter<Subscription.Status, SubscriptionsRequest> subscriptionStatus() {
            return new EnumFilter<Subscription.Status, SubscriptionsRequest>("subscription[status]", this);
        }

        public EnumFilter<Subscription.CancelReason, SubscriptionsRequest> subscriptionCancelReason() {
            return new EnumFilter("subscription[cancel_reason]", this).supportsPresenceOperator(true);
        }

        public NumberFilter<Integer, SubscriptionsRequest> subscriptionRemainingBillingCycles() {
            return new NumberFilter("subscription[remaining_billing_cycles]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<SubscriptionsRequest> subscriptionCreatedAt() {
            return new TimestampFilter<SubscriptionsRequest>("subscription[created_at]", this);
        }

        public TimestampFilter<SubscriptionsRequest> subscriptionActivatedAt() {
            return new TimestampFilter<SubscriptionsRequest>("subscription[activated_at]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<SubscriptionsRequest> subscriptionNextBillingAt() {
            return new TimestampFilter<SubscriptionsRequest>("subscription[next_billing_at]", this);
        }

        public TimestampFilter<SubscriptionsRequest> subscriptionCancelledAt() {
            return new TimestampFilter<SubscriptionsRequest>("subscription[cancelled_at]", this);
        }

        public BooleanFilter<SubscriptionsRequest> subscriptionHasScheduledChanges() {
            return new BooleanFilter<SubscriptionsRequest>("subscription[has_scheduled_changes]", this);
        }

        public TimestampFilter<SubscriptionsRequest> subscriptionUpdatedAt() {
            return new TimestampFilter<SubscriptionsRequest>("subscription[updated_at]", this);
        }

        public EnumFilter<OfflinePaymentMethod, SubscriptionsRequest> subscriptionOfflinePaymentMethod() {
            return new EnumFilter<OfflinePaymentMethod, SubscriptionsRequest>("subscription[offline_payment_method]", this);
        }

        public BooleanFilter<SubscriptionsRequest> subscriptionAutoCloseInvoices() {
            return new BooleanFilter<SubscriptionsRequest>("subscription[auto_close_invoices]", this);
        }

        public EnumFilter<Channel, SubscriptionsRequest> subscriptionChannel() {
            return new EnumFilter<Channel, SubscriptionsRequest>("subscription[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CustomersRequest
    extends Request<CustomersRequest> {
        private CustomersRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CustomersRequest exportType(ExportType exportType) {
            this.params.addOpt("export_type", (Object)exportType);
            return this;
        }

        public StringFilter<CustomersRequest> businessEntityId() {
            return new StringFilter<CustomersRequest>("business_entity_id", this);
        }

        public StringFilter<CustomersRequest> customerId() {
            return new StringFilter<CustomersRequest>("customer[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<CustomersRequest> customerFirstName() {
            return new StringFilter<CustomersRequest>("customer[first_name]", this).supportsPresenceOperator(true);
        }

        public StringFilter<CustomersRequest> customerLastName() {
            return new StringFilter<CustomersRequest>("customer[last_name]", this).supportsPresenceOperator(true);
        }

        public StringFilter<CustomersRequest> customerEmail() {
            return new StringFilter<CustomersRequest>("customer[email]", this).supportsPresenceOperator(true);
        }

        public StringFilter<CustomersRequest> customerCompany() {
            return new StringFilter<CustomersRequest>("customer[company]", this).supportsPresenceOperator(true);
        }

        public StringFilter<CustomersRequest> customerPhone() {
            return new StringFilter<CustomersRequest>("customer[phone]", this).supportsPresenceOperator(true);
        }

        public EnumFilter<AutoCollection, CustomersRequest> customerAutoCollection() {
            return new EnumFilter<AutoCollection, CustomersRequest>("customer[auto_collection]", this);
        }

        public EnumFilter<Taxability, CustomersRequest> customerTaxability() {
            return new EnumFilter<Taxability, CustomersRequest>("customer[taxability]", this);
        }

        public TimestampFilter<CustomersRequest> customerCreatedAt() {
            return new TimestampFilter<CustomersRequest>("customer[created_at]", this);
        }

        public TimestampFilter<CustomersRequest> customerUpdatedAt() {
            return new TimestampFilter<CustomersRequest>("customer[updated_at]", this);
        }

        public StringFilter<CustomersRequest> relationshipParentId() {
            return new StringFilter<CustomersRequest>("relationship[parent_id]", this);
        }

        public StringFilter<CustomersRequest> relationshipPaymentOwnerId() {
            return new StringFilter<CustomersRequest>("relationship[payment_owner_id]", this);
        }

        public StringFilter<CustomersRequest> relationshipInvoiceOwnerId() {
            return new StringFilter<CustomersRequest>("relationship[invoice_owner_id]", this);
        }

        public EnumFilter<OfflinePaymentMethod, CustomersRequest> customerOfflinePaymentMethod() {
            return new EnumFilter<OfflinePaymentMethod, CustomersRequest>("customer[offline_payment_method]", this);
        }

        public BooleanFilter<CustomersRequest> customerAutoCloseInvoices() {
            return new BooleanFilter<CustomersRequest>("customer[auto_close_invoices]", this);
        }

        public EnumFilter<Channel, CustomersRequest> customerChannel() {
            return new EnumFilter<Channel, CustomersRequest>("customer[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CouponsRequest
    extends Request<CouponsRequest> {
        private CouponsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<CouponsRequest> currencyCode() {
            return new StringFilter<CouponsRequest>("currency_code", this).supportsMultiOperators(true);
        }

        public StringFilter<CouponsRequest> couponId() {
            return new StringFilter<CouponsRequest>("coupon[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<CouponsRequest> couponName() {
            return new StringFilter<CouponsRequest>("coupon[name]", this).supportsMultiOperators(true);
        }

        public EnumFilter<Coupon.DiscountType, CouponsRequest> couponDiscountType() {
            return new EnumFilter<Coupon.DiscountType, CouponsRequest>("coupon[discount_type]", this);
        }

        public EnumFilter<Coupon.DurationType, CouponsRequest> couponDurationType() {
            return new EnumFilter<Coupon.DurationType, CouponsRequest>("coupon[duration_type]", this);
        }

        public EnumFilter<Coupon.Status, CouponsRequest> couponStatus() {
            return new EnumFilter<Coupon.Status, CouponsRequest>("coupon[status]", this);
        }

        public EnumFilter<Coupon.ApplyOn, CouponsRequest> couponApplyOn() {
            return new EnumFilter<Coupon.ApplyOn, CouponsRequest>("coupon[apply_on]", this);
        }

        public TimestampFilter<CouponsRequest> couponCreatedAt() {
            return new TimestampFilter<CouponsRequest>("coupon[created_at]", this);
        }

        public TimestampFilter<CouponsRequest> couponUpdatedAt() {
            return new TimestampFilter<CouponsRequest>("coupon[updated_at]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AddonsRequest
    extends Request<AddonsRequest> {
        private AddonsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<AddonsRequest> currencyCode() {
            return new StringFilter<AddonsRequest>("currency_code", this).supportsMultiOperators(true);
        }

        public StringFilter<AddonsRequest> addonId() {
            return new StringFilter<AddonsRequest>("addon[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<AddonsRequest> addonName() {
            return new StringFilter<AddonsRequest>("addon[name]", this).supportsMultiOperators(true);
        }

        public EnumFilter<Addon.ChargeType, AddonsRequest> addonChargeType() {
            return new EnumFilter<Addon.ChargeType, AddonsRequest>("addon[charge_type]", this);
        }

        public NumberFilter<Long, AddonsRequest> addonPrice() {
            return new NumberFilter<Long, AddonsRequest>("addon[price]", this);
        }

        public NumberFilter<Integer, AddonsRequest> addonPeriod() {
            return new NumberFilter<Integer, AddonsRequest>("addon[period]", this);
        }

        public EnumFilter<Addon.PeriodUnit, AddonsRequest> addonPeriodUnit() {
            return new EnumFilter<Addon.PeriodUnit, AddonsRequest>("addon[period_unit]", this);
        }

        public EnumFilter<Addon.Status, AddonsRequest> addonStatus() {
            return new EnumFilter<Addon.Status, AddonsRequest>("addon[status]", this);
        }

        public TimestampFilter<AddonsRequest> addonUpdatedAt() {
            return new TimestampFilter<AddonsRequest>("addon[updated_at]", this);
        }

        public EnumFilter<Channel, AddonsRequest> addonChannel() {
            return new EnumFilter<Channel, AddonsRequest>("addon[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class PlansRequest
    extends Request<PlansRequest> {
        private PlansRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public StringFilter<PlansRequest> currencyCode() {
            return new StringFilter<PlansRequest>("currency_code", this).supportsMultiOperators(true);
        }

        public StringFilter<PlansRequest> planId() {
            return new StringFilter<PlansRequest>("plan[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<PlansRequest> planName() {
            return new StringFilter<PlansRequest>("plan[name]", this).supportsMultiOperators(true);
        }

        public NumberFilter<Long, PlansRequest> planPrice() {
            return new NumberFilter<Long, PlansRequest>("plan[price]", this);
        }

        public NumberFilter<Integer, PlansRequest> planPeriod() {
            return new NumberFilter<Integer, PlansRequest>("plan[period]", this);
        }

        public EnumFilter<Plan.PeriodUnit, PlansRequest> planPeriodUnit() {
            return new EnumFilter<Plan.PeriodUnit, PlansRequest>("plan[period_unit]", this);
        }

        public NumberFilter<Integer, PlansRequest> planTrialPeriod() {
            return new NumberFilter("plan[trial_period]", this).supportsPresenceOperator(true);
        }

        public EnumFilter<Plan.TrialPeriodUnit, PlansRequest> planTrialPeriodUnit() {
            return new EnumFilter<Plan.TrialPeriodUnit, PlansRequest>("plan[trial_period_unit]", this);
        }

        public EnumFilter<Plan.AddonApplicability, PlansRequest> planAddonApplicability() {
            return new EnumFilter<Plan.AddonApplicability, PlansRequest>("plan[addon_applicability]", this);
        }

        public BooleanFilter<PlansRequest> planGiftable() {
            return new BooleanFilter<PlansRequest>("plan[giftable]", this);
        }

        public EnumFilter<Plan.Status, PlansRequest> planStatus() {
            return new EnumFilter<Plan.Status, PlansRequest>("plan[status]", this);
        }

        public TimestampFilter<PlansRequest> planUpdatedAt() {
            return new TimestampFilter<PlansRequest>("plan[updated_at]", this);
        }

        public EnumFilter<Channel, PlansRequest> planChannel() {
            return new EnumFilter<Channel, PlansRequest>("plan[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class DeferredRevenueRequest
    extends Request<DeferredRevenueRequest> {
        private DeferredRevenueRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeferredRevenueRequest reportBy(ReportBy reportBy) {
            this.params.add("report_by", (Object)reportBy);
            return this;
        }

        public DeferredRevenueRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public DeferredRevenueRequest reportFromMonth(Integer reportFromMonth) {
            this.params.add("report_from_month", reportFromMonth);
            return this;
        }

        public DeferredRevenueRequest reportFromYear(Integer reportFromYear) {
            this.params.add("report_from_year", reportFromYear);
            return this;
        }

        public DeferredRevenueRequest reportToMonth(Integer reportToMonth) {
            this.params.add("report_to_month", reportToMonth);
            return this;
        }

        public DeferredRevenueRequest reportToYear(Integer reportToYear) {
            this.params.add("report_to_year", reportToYear);
            return this;
        }

        public DeferredRevenueRequest includeDiscounts(Boolean includeDiscounts) {
            this.params.addOpt("include_discounts", includeDiscounts);
            return this;
        }

        public StringFilter<DeferredRevenueRequest> paymentOwner() {
            return new StringFilter<DeferredRevenueRequest>("payment_owner", this).supportsMultiOperators(true);
        }

        public StringFilter<DeferredRevenueRequest> itemId() {
            return new StringFilter<DeferredRevenueRequest>("item_id", this).supportsMultiOperators(true);
        }

        public StringFilter<DeferredRevenueRequest> itemPriceId() {
            return new StringFilter<DeferredRevenueRequest>("item_price_id", this).supportsMultiOperators(true);
        }

        public StringFilter<DeferredRevenueRequest> cancelReasonCode() {
            return new StringFilter<DeferredRevenueRequest>("cancel_reason_code", this).supportsMultiOperators(true);
        }

        public StringFilter<DeferredRevenueRequest> businessEntityId() {
            return new StringFilter<DeferredRevenueRequest>("business_entity_id", this);
        }

        public StringFilter<DeferredRevenueRequest> invoiceId() {
            return new StringFilter<DeferredRevenueRequest>("invoice[id]", this).supportsMultiOperators(true);
        }

        public BooleanFilter<DeferredRevenueRequest> invoiceRecurring() {
            return new BooleanFilter<DeferredRevenueRequest>("invoice[recurring]", this);
        }

        public EnumFilter<Invoice.Status, DeferredRevenueRequest> invoiceStatus() {
            return new EnumFilter<Invoice.Status, DeferredRevenueRequest>("invoice[status]", this);
        }

        public EnumFilter<PriceType, DeferredRevenueRequest> invoicePriceType() {
            return new EnumFilter<PriceType, DeferredRevenueRequest>("invoice[price_type]", this);
        }

        public TimestampFilter<DeferredRevenueRequest> invoiceDate() {
            return new TimestampFilter<DeferredRevenueRequest>("invoice[date]", this);
        }

        public TimestampFilter<DeferredRevenueRequest> invoicePaidAt() {
            return new TimestampFilter<DeferredRevenueRequest>("invoice[paid_at]", this);
        }

        public NumberFilter<Long, DeferredRevenueRequest> invoiceTotal() {
            return new NumberFilter<Long, DeferredRevenueRequest>("invoice[total]", this);
        }

        public NumberFilter<Long, DeferredRevenueRequest> invoiceAmountPaid() {
            return new NumberFilter<Long, DeferredRevenueRequest>("invoice[amount_paid]", this);
        }

        public NumberFilter<Long, DeferredRevenueRequest> invoiceAmountAdjusted() {
            return new NumberFilter<Long, DeferredRevenueRequest>("invoice[amount_adjusted]", this);
        }

        public NumberFilter<Long, DeferredRevenueRequest> invoiceCreditsApplied() {
            return new NumberFilter<Long, DeferredRevenueRequest>("invoice[credits_applied]", this);
        }

        public NumberFilter<Long, DeferredRevenueRequest> invoiceAmountDue() {
            return new NumberFilter<Long, DeferredRevenueRequest>("invoice[amount_due]", this);
        }

        public EnumFilter<Invoice.DunningStatus, DeferredRevenueRequest> invoiceDunningStatus() {
            return new EnumFilter("invoice[dunning_status]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<DeferredRevenueRequest> invoiceUpdatedAt() {
            return new TimestampFilter<DeferredRevenueRequest>("invoice[updated_at]", this);
        }

        public EnumFilter<Channel, DeferredRevenueRequest> invoiceChannel() {
            return new EnumFilter<Channel, DeferredRevenueRequest>("invoice[channel]", this);
        }

        public StringFilter<DeferredRevenueRequest> subscriptionId() {
            return new StringFilter<DeferredRevenueRequest>("subscription[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<DeferredRevenueRequest> subscriptionCustomerId() {
            return new StringFilter<DeferredRevenueRequest>("subscription[customer_id]", this).supportsMultiOperators(true);
        }

        public StringFilter<DeferredRevenueRequest> subscriptionPlanId() {
            return new StringFilter<DeferredRevenueRequest>("subscription[plan_id]", this).supportsMultiOperators(true);
        }

        public EnumFilter<Subscription.Status, DeferredRevenueRequest> subscriptionStatus() {
            return new EnumFilter<Subscription.Status, DeferredRevenueRequest>("subscription[status]", this);
        }

        public EnumFilter<Subscription.CancelReason, DeferredRevenueRequest> subscriptionCancelReason() {
            return new EnumFilter("subscription[cancel_reason]", this).supportsPresenceOperator(true);
        }

        public NumberFilter<Integer, DeferredRevenueRequest> subscriptionRemainingBillingCycles() {
            return new NumberFilter("subscription[remaining_billing_cycles]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<DeferredRevenueRequest> subscriptionCreatedAt() {
            return new TimestampFilter<DeferredRevenueRequest>("subscription[created_at]", this);
        }

        public TimestampFilter<DeferredRevenueRequest> subscriptionActivatedAt() {
            return new TimestampFilter<DeferredRevenueRequest>("subscription[activated_at]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<DeferredRevenueRequest> subscriptionNextBillingAt() {
            return new TimestampFilter<DeferredRevenueRequest>("subscription[next_billing_at]", this);
        }

        public TimestampFilter<DeferredRevenueRequest> subscriptionCancelledAt() {
            return new TimestampFilter<DeferredRevenueRequest>("subscription[cancelled_at]", this);
        }

        public BooleanFilter<DeferredRevenueRequest> subscriptionHasScheduledChanges() {
            return new BooleanFilter<DeferredRevenueRequest>("subscription[has_scheduled_changes]", this);
        }

        public TimestampFilter<DeferredRevenueRequest> subscriptionUpdatedAt() {
            return new TimestampFilter<DeferredRevenueRequest>("subscription[updated_at]", this);
        }

        public EnumFilter<OfflinePaymentMethod, DeferredRevenueRequest> subscriptionOfflinePaymentMethod() {
            return new EnumFilter<OfflinePaymentMethod, DeferredRevenueRequest>("subscription[offline_payment_method]", this);
        }

        public BooleanFilter<DeferredRevenueRequest> subscriptionAutoCloseInvoices() {
            return new BooleanFilter<DeferredRevenueRequest>("subscription[auto_close_invoices]", this);
        }

        public EnumFilter<Channel, DeferredRevenueRequest> subscriptionChannel() {
            return new EnumFilter<Channel, DeferredRevenueRequest>("subscription[channel]", this);
        }

        public StringFilter<DeferredRevenueRequest> customerId() {
            return new StringFilter<DeferredRevenueRequest>("customer[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<DeferredRevenueRequest> customerFirstName() {
            return new StringFilter<DeferredRevenueRequest>("customer[first_name]", this).supportsPresenceOperator(true);
        }

        public StringFilter<DeferredRevenueRequest> customerLastName() {
            return new StringFilter<DeferredRevenueRequest>("customer[last_name]", this).supportsPresenceOperator(true);
        }

        public StringFilter<DeferredRevenueRequest> customerEmail() {
            return new StringFilter<DeferredRevenueRequest>("customer[email]", this).supportsPresenceOperator(true);
        }

        public StringFilter<DeferredRevenueRequest> customerCompany() {
            return new StringFilter<DeferredRevenueRequest>("customer[company]", this).supportsPresenceOperator(true);
        }

        public StringFilter<DeferredRevenueRequest> customerPhone() {
            return new StringFilter<DeferredRevenueRequest>("customer[phone]", this).supportsPresenceOperator(true);
        }

        public EnumFilter<AutoCollection, DeferredRevenueRequest> customerAutoCollection() {
            return new EnumFilter<AutoCollection, DeferredRevenueRequest>("customer[auto_collection]", this);
        }

        public EnumFilter<Taxability, DeferredRevenueRequest> customerTaxability() {
            return new EnumFilter<Taxability, DeferredRevenueRequest>("customer[taxability]", this);
        }

        public TimestampFilter<DeferredRevenueRequest> customerCreatedAt() {
            return new TimestampFilter<DeferredRevenueRequest>("customer[created_at]", this);
        }

        public TimestampFilter<DeferredRevenueRequest> customerUpdatedAt() {
            return new TimestampFilter<DeferredRevenueRequest>("customer[updated_at]", this);
        }

        public StringFilter<DeferredRevenueRequest> relationshipParentId() {
            return new StringFilter<DeferredRevenueRequest>("relationship[parent_id]", this);
        }

        public StringFilter<DeferredRevenueRequest> relationshipPaymentOwnerId() {
            return new StringFilter<DeferredRevenueRequest>("relationship[payment_owner_id]", this);
        }

        public StringFilter<DeferredRevenueRequest> relationshipInvoiceOwnerId() {
            return new StringFilter<DeferredRevenueRequest>("relationship[invoice_owner_id]", this);
        }

        public EnumFilter<OfflinePaymentMethod, DeferredRevenueRequest> customerOfflinePaymentMethod() {
            return new EnumFilter<OfflinePaymentMethod, DeferredRevenueRequest>("customer[offline_payment_method]", this);
        }

        public BooleanFilter<DeferredRevenueRequest> customerAutoCloseInvoices() {
            return new BooleanFilter<DeferredRevenueRequest>("customer[auto_close_invoices]", this);
        }

        public EnumFilter<Channel, DeferredRevenueRequest> customerChannel() {
            return new EnumFilter<Channel, DeferredRevenueRequest>("customer[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RevenueRecognitionRequest
    extends Request<RevenueRecognitionRequest> {
        private RevenueRecognitionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RevenueRecognitionRequest reportBy(ReportBy reportBy) {
            this.params.add("report_by", (Object)reportBy);
            return this;
        }

        public RevenueRecognitionRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public RevenueRecognitionRequest reportFromMonth(Integer reportFromMonth) {
            this.params.add("report_from_month", reportFromMonth);
            return this;
        }

        public RevenueRecognitionRequest reportFromYear(Integer reportFromYear) {
            this.params.add("report_from_year", reportFromYear);
            return this;
        }

        public RevenueRecognitionRequest reportToMonth(Integer reportToMonth) {
            this.params.add("report_to_month", reportToMonth);
            return this;
        }

        public RevenueRecognitionRequest reportToYear(Integer reportToYear) {
            this.params.add("report_to_year", reportToYear);
            return this;
        }

        public RevenueRecognitionRequest includeDiscounts(Boolean includeDiscounts) {
            this.params.addOpt("include_discounts", includeDiscounts);
            return this;
        }

        public StringFilter<RevenueRecognitionRequest> paymentOwner() {
            return new StringFilter<RevenueRecognitionRequest>("payment_owner", this).supportsMultiOperators(true);
        }

        public StringFilter<RevenueRecognitionRequest> itemId() {
            return new StringFilter<RevenueRecognitionRequest>("item_id", this).supportsMultiOperators(true);
        }

        public StringFilter<RevenueRecognitionRequest> itemPriceId() {
            return new StringFilter<RevenueRecognitionRequest>("item_price_id", this).supportsMultiOperators(true);
        }

        public StringFilter<RevenueRecognitionRequest> cancelReasonCode() {
            return new StringFilter<RevenueRecognitionRequest>("cancel_reason_code", this).supportsMultiOperators(true);
        }

        public StringFilter<RevenueRecognitionRequest> businessEntityId() {
            return new StringFilter<RevenueRecognitionRequest>("business_entity_id", this);
        }

        public StringFilter<RevenueRecognitionRequest> invoiceId() {
            return new StringFilter<RevenueRecognitionRequest>("invoice[id]", this).supportsMultiOperators(true);
        }

        public BooleanFilter<RevenueRecognitionRequest> invoiceRecurring() {
            return new BooleanFilter<RevenueRecognitionRequest>("invoice[recurring]", this);
        }

        public EnumFilter<Invoice.Status, RevenueRecognitionRequest> invoiceStatus() {
            return new EnumFilter<Invoice.Status, RevenueRecognitionRequest>("invoice[status]", this);
        }

        public EnumFilter<PriceType, RevenueRecognitionRequest> invoicePriceType() {
            return new EnumFilter<PriceType, RevenueRecognitionRequest>("invoice[price_type]", this);
        }

        public TimestampFilter<RevenueRecognitionRequest> invoiceDate() {
            return new TimestampFilter<RevenueRecognitionRequest>("invoice[date]", this);
        }

        public TimestampFilter<RevenueRecognitionRequest> invoicePaidAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("invoice[paid_at]", this);
        }

        public NumberFilter<Long, RevenueRecognitionRequest> invoiceTotal() {
            return new NumberFilter<Long, RevenueRecognitionRequest>("invoice[total]", this);
        }

        public NumberFilter<Long, RevenueRecognitionRequest> invoiceAmountPaid() {
            return new NumberFilter<Long, RevenueRecognitionRequest>("invoice[amount_paid]", this);
        }

        public NumberFilter<Long, RevenueRecognitionRequest> invoiceAmountAdjusted() {
            return new NumberFilter<Long, RevenueRecognitionRequest>("invoice[amount_adjusted]", this);
        }

        public NumberFilter<Long, RevenueRecognitionRequest> invoiceCreditsApplied() {
            return new NumberFilter<Long, RevenueRecognitionRequest>("invoice[credits_applied]", this);
        }

        public NumberFilter<Long, RevenueRecognitionRequest> invoiceAmountDue() {
            return new NumberFilter<Long, RevenueRecognitionRequest>("invoice[amount_due]", this);
        }

        public EnumFilter<Invoice.DunningStatus, RevenueRecognitionRequest> invoiceDunningStatus() {
            return new EnumFilter("invoice[dunning_status]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<RevenueRecognitionRequest> invoiceUpdatedAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("invoice[updated_at]", this);
        }

        public EnumFilter<Channel, RevenueRecognitionRequest> invoiceChannel() {
            return new EnumFilter<Channel, RevenueRecognitionRequest>("invoice[channel]", this);
        }

        public StringFilter<RevenueRecognitionRequest> subscriptionId() {
            return new StringFilter<RevenueRecognitionRequest>("subscription[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<RevenueRecognitionRequest> subscriptionCustomerId() {
            return new StringFilter<RevenueRecognitionRequest>("subscription[customer_id]", this).supportsMultiOperators(true);
        }

        public StringFilter<RevenueRecognitionRequest> subscriptionPlanId() {
            return new StringFilter<RevenueRecognitionRequest>("subscription[plan_id]", this).supportsMultiOperators(true);
        }

        public EnumFilter<Subscription.Status, RevenueRecognitionRequest> subscriptionStatus() {
            return new EnumFilter<Subscription.Status, RevenueRecognitionRequest>("subscription[status]", this);
        }

        public EnumFilter<Subscription.CancelReason, RevenueRecognitionRequest> subscriptionCancelReason() {
            return new EnumFilter("subscription[cancel_reason]", this).supportsPresenceOperator(true);
        }

        public NumberFilter<Integer, RevenueRecognitionRequest> subscriptionRemainingBillingCycles() {
            return new NumberFilter("subscription[remaining_billing_cycles]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<RevenueRecognitionRequest> subscriptionCreatedAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("subscription[created_at]", this);
        }

        public TimestampFilter<RevenueRecognitionRequest> subscriptionActivatedAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("subscription[activated_at]", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<RevenueRecognitionRequest> subscriptionNextBillingAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("subscription[next_billing_at]", this);
        }

        public TimestampFilter<RevenueRecognitionRequest> subscriptionCancelledAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("subscription[cancelled_at]", this);
        }

        public BooleanFilter<RevenueRecognitionRequest> subscriptionHasScheduledChanges() {
            return new BooleanFilter<RevenueRecognitionRequest>("subscription[has_scheduled_changes]", this);
        }

        public TimestampFilter<RevenueRecognitionRequest> subscriptionUpdatedAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("subscription[updated_at]", this);
        }

        public EnumFilter<OfflinePaymentMethod, RevenueRecognitionRequest> subscriptionOfflinePaymentMethod() {
            return new EnumFilter<OfflinePaymentMethod, RevenueRecognitionRequest>("subscription[offline_payment_method]", this);
        }

        public BooleanFilter<RevenueRecognitionRequest> subscriptionAutoCloseInvoices() {
            return new BooleanFilter<RevenueRecognitionRequest>("subscription[auto_close_invoices]", this);
        }

        public EnumFilter<Channel, RevenueRecognitionRequest> subscriptionChannel() {
            return new EnumFilter<Channel, RevenueRecognitionRequest>("subscription[channel]", this);
        }

        public StringFilter<RevenueRecognitionRequest> customerId() {
            return new StringFilter<RevenueRecognitionRequest>("customer[id]", this).supportsMultiOperators(true);
        }

        public StringFilter<RevenueRecognitionRequest> customerFirstName() {
            return new StringFilter<RevenueRecognitionRequest>("customer[first_name]", this).supportsPresenceOperator(true);
        }

        public StringFilter<RevenueRecognitionRequest> customerLastName() {
            return new StringFilter<RevenueRecognitionRequest>("customer[last_name]", this).supportsPresenceOperator(true);
        }

        public StringFilter<RevenueRecognitionRequest> customerEmail() {
            return new StringFilter<RevenueRecognitionRequest>("customer[email]", this).supportsPresenceOperator(true);
        }

        public StringFilter<RevenueRecognitionRequest> customerCompany() {
            return new StringFilter<RevenueRecognitionRequest>("customer[company]", this).supportsPresenceOperator(true);
        }

        public StringFilter<RevenueRecognitionRequest> customerPhone() {
            return new StringFilter<RevenueRecognitionRequest>("customer[phone]", this).supportsPresenceOperator(true);
        }

        public EnumFilter<AutoCollection, RevenueRecognitionRequest> customerAutoCollection() {
            return new EnumFilter<AutoCollection, RevenueRecognitionRequest>("customer[auto_collection]", this);
        }

        public EnumFilter<Taxability, RevenueRecognitionRequest> customerTaxability() {
            return new EnumFilter<Taxability, RevenueRecognitionRequest>("customer[taxability]", this);
        }

        public TimestampFilter<RevenueRecognitionRequest> customerCreatedAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("customer[created_at]", this);
        }

        public TimestampFilter<RevenueRecognitionRequest> customerUpdatedAt() {
            return new TimestampFilter<RevenueRecognitionRequest>("customer[updated_at]", this);
        }

        public StringFilter<RevenueRecognitionRequest> relationshipParentId() {
            return new StringFilter<RevenueRecognitionRequest>("relationship[parent_id]", this);
        }

        public StringFilter<RevenueRecognitionRequest> relationshipPaymentOwnerId() {
            return new StringFilter<RevenueRecognitionRequest>("relationship[payment_owner_id]", this);
        }

        public StringFilter<RevenueRecognitionRequest> relationshipInvoiceOwnerId() {
            return new StringFilter<RevenueRecognitionRequest>("relationship[invoice_owner_id]", this);
        }

        public EnumFilter<OfflinePaymentMethod, RevenueRecognitionRequest> customerOfflinePaymentMethod() {
            return new EnumFilter<OfflinePaymentMethod, RevenueRecognitionRequest>("customer[offline_payment_method]", this);
        }

        public BooleanFilter<RevenueRecognitionRequest> customerAutoCloseInvoices() {
            return new BooleanFilter<RevenueRecognitionRequest>("customer[auto_close_invoices]", this);
        }

        public EnumFilter<Channel, RevenueRecognitionRequest> customerChannel() {
            return new EnumFilter<Channel, RevenueRecognitionRequest>("customer[channel]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Download
    extends Resource<Download> {
        public Download(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String downloadUrl() {
            return this.reqString("download_url");
        }

        public Timestamp validTill() {
            return this.reqTimestamp("valid_till");
        }

        public String mimeType() {
            return this.optString("mime_type");
        }
    }

    public static enum Status {
        IN_PROCESS,
        COMPLETED,
        FAILED,
        _UNKNOWN;

    }

    public static enum MimeType {
        PDF,
        ZIP,
        _UNKNOWN;

    }
}

