/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class Feature
extends Resource<Feature> {
    public Feature(String jsonStr) {
        super(jsonStr);
    }

    public Feature(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String description() {
        return this.optString("description");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public Type type() {
        return this.optEnum("type", Type.class);
    }

    public String unit() {
        return this.optString("unit");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public List<Level> levels() {
        return this.optList("levels", Level.class);
    }

    public static FeatureListRequest list() {
        String uri = Feature.uri("features");
        return new FeatureListRequest(uri);
    }

    public static CreateRequest create() {
        String uri = Feature.uri("features");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = Feature.uri("features", Feature.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = Feature.uri("features", Feature.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request delete(String id) {
        String uri = Feature.uri("features", Feature.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request activate(String id) {
        String uri = Feature.uri("features", Feature.nullCheck(id), "activate_command");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request archive(String id) {
        String uri = Feature.uri("features", Feature.nullCheck(id), "archive_command");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request reactivate(String id) {
        String uri = Feature.uri("features", Feature.nullCheck(id), "reactivate_command");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public UpdateRequest unit(String unit) {
            this.params.addOpt("unit", unit);
            return this;
        }

        public UpdateRequest levelName(int index, String levelName) {
            this.params.addOpt("levels[name][" + index + "]", levelName);
            return this;
        }

        public UpdateRequest levelValue(int index, String levelValue) {
            this.params.addOpt("levels[value][" + index + "]", levelValue);
            return this;
        }

        public UpdateRequest levelIsUnlimited(int index, Boolean levelIsUnlimited) {
            this.params.addOpt("levels[is_unlimited][" + index + "]", levelIsUnlimited);
            return this;
        }

        public UpdateRequest levelLevel(int index, Integer levelLevel) {
            this.params.addOpt("levels[level][" + index + "]", levelLevel);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public CreateRequest type(Type type) {
            this.params.addOpt("type", (Object)type);
            return this;
        }

        public CreateRequest unit(String unit) {
            this.params.addOpt("unit", unit);
            return this;
        }

        public CreateRequest levelName(int index, String levelName) {
            this.params.addOpt("levels[name][" + index + "]", levelName);
            return this;
        }

        public CreateRequest levelValue(int index, String levelValue) {
            this.params.addOpt("levels[value][" + index + "]", levelValue);
            return this;
        }

        public CreateRequest levelIsUnlimited(int index, Boolean levelIsUnlimited) {
            this.params.addOpt("levels[is_unlimited][" + index + "]", levelIsUnlimited);
            return this;
        }

        public CreateRequest levelLevel(int index, Integer levelLevel) {
            this.params.addOpt("levels[level][" + index + "]", levelLevel);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class FeatureListRequest
    extends ListRequest<FeatureListRequest> {
        private FeatureListRequest(String uri) {
            super(uri);
        }

        public StringFilter<FeatureListRequest> name() {
            return new StringFilter<FeatureListRequest>("name", this).supportsMultiOperators(true);
        }

        public StringFilter<FeatureListRequest> id() {
            return new StringFilter<FeatureListRequest>("id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Status, FeatureListRequest> status() {
            return new EnumFilter<Status, FeatureListRequest>("status", this);
        }

        public EnumFilter<Type, FeatureListRequest> type() {
            return new EnumFilter<Type, FeatureListRequest>("type", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Level
    extends Resource<Level> {
        public Level(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String name() {
            return this.optString("name");
        }

        public String value() {
            return this.reqString("value");
        }

        public Integer level() {
            return this.reqInteger("level");
        }

        public Boolean isUnlimited() {
            return this.reqBoolean("is_unlimited");
        }
    }

    public static enum Type {
        SWITCH,
        CUSTOM,
        QUANTITY,
        RANGE,
        _UNKNOWN;

    }

    public static enum Status {
        ACTIVE,
        ARCHIVED,
        DRAFT,
        _UNKNOWN;

    }
}

