/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class OmnichannelSubscription
extends Resource<OmnichannelSubscription> {
    public OmnichannelSubscription(String jsonStr) {
        super(jsonStr);
    }

    public OmnichannelSubscription(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String idAtSource() {
        return this.reqString("id_at_source");
    }

    public String appId() {
        return this.reqString("app_id");
    }

    public Source source() {
        return this.reqEnum("source", Source.class);
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public List<OmnichannelSubscriptionItem> omnichannelSubscriptionItems() {
        return this.reqList("omnichannel_subscription_items", OmnichannelSubscriptionItem.class);
    }

    public static Request retrieve(String id) {
        String uri = OmnichannelSubscription.uri("omnichannel_subscriptions", OmnichannelSubscription.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static ListRequest list() {
        String uri = OmnichannelSubscription.uri("omnichannel_subscriptions");
        return new ListRequest(uri);
    }

    public static ListRequest omnichannelTransactionsForOmnichannelSubscription(String id) {
        String uri = OmnichannelSubscription.uri("omnichannel_subscriptions", OmnichannelSubscription.nullCheck(id), "omnichannel_transactions");
        return new ListRequest(uri);
    }

    public static class OmnichannelSubscriptionItem
    extends Resource<OmnichannelSubscriptionItem> {
        public OmnichannelSubscriptionItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public String idAtSource() {
            return this.reqString("id_at_source");
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public Timestamp currentTermStart() {
            return this.optTimestamp("current_term_start");
        }

        public Timestamp currentTermEnd() {
            return this.optTimestamp("current_term_end");
        }

        public Timestamp expiredAt() {
            return this.optTimestamp("expired_at");
        }

        public ExpirationReason expirationReason() {
            return this.optEnum("expiration_reason", ExpirationReason.class);
        }

        public Timestamp cancelledAt() {
            return this.optTimestamp("cancelled_at");
        }

        public CancellationReason cancellationReason() {
            return this.optEnum("cancellation_reason", CancellationReason.class);
        }

        public static enum CancellationReason {
            CUSTOMER_CANCELLED,
            CUSTOMER_DID_NOT_CONSENT_TO_PRICE_INCREASE,
            _UNKNOWN;

        }

        public static enum ExpirationReason {
            BILLING_ERROR,
            PRODUCT_NOT_AVAILABLE,
            OTHER,
            _UNKNOWN;

        }

        public static enum Status {
            ACTIVE,
            EXPIRED,
            CANCELLED,
            _UNKNOWN;

        }
    }

    public static enum Source {
        APPLE_APP_STORE,
        _UNKNOWN;

    }
}

