/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;

public class PaymentScheduleScheme
extends Resource<PaymentScheduleScheme> {
    public PaymentScheduleScheme(String jsonStr) {
        super(jsonStr);
    }

    public PaymentScheduleScheme(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.optString("name");
    }

    public String description() {
        return this.optString("description");
    }

    public Integer numberOfSchedules() {
        return this.reqInteger("number_of_schedules");
    }

    public PeriodUnit periodUnit() {
        return this.reqEnum("period_unit", PeriodUnit.class);
    }

    public Integer period() {
        return this.optInteger("period");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    @Deprecated
    public List<PreferredSchedule> preferredSchedules() {
        return this.optList("preferred_schedules", PreferredSchedule.class);
    }

    public static CreateRequest create() {
        String uri = PaymentScheduleScheme.uri("payment_schedule_schemes");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = PaymentScheduleScheme.uri("payment_schedule_schemes", PaymentScheduleScheme.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request delete(String id) {
        String uri = PaymentScheduleScheme.uri("payment_schedule_schemes", PaymentScheduleScheme.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest numberOfSchedules(Integer numberOfSchedules) {
            this.params.add("number_of_schedules", numberOfSchedules);
            return this;
        }

        public CreateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.add("period_unit", (Object)periodUnit);
            return this;
        }

        public CreateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest flexibleSchedulePeriod(int index, Integer flexibleSchedulePeriod) {
            this.params.addOpt("flexible_schedules[period][" + index + "]", flexibleSchedulePeriod);
            return this;
        }

        public CreateRequest flexibleScheduleAmountPercentage(int index, BigDecimal flexibleScheduleAmountPercentage) {
            this.params.addOpt("flexible_schedules[amount_percentage][" + index + "]", flexibleScheduleAmountPercentage);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class PreferredSchedule
    extends Resource<PreferredSchedule> {
        public PreferredSchedule(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer period() {
            return this.optInteger("period");
        }

        public BigDecimal amountPercentage() {
            return this.optBigDecimal("amount_percentage");
        }
    }

    public static enum PeriodUnit {
        DAY,
        WEEK,
        MONTH,
        _UNKNOWN;

    }
}

