/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class PriceVariant
extends Resource<PriceVariant> {
    public PriceVariant(String jsonStr) {
        super(jsonStr);
    }

    public PriceVariant(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String externalName() {
        return this.optString("external_name");
    }

    public String variantGroup() {
        return this.optString("variant_group");
    }

    public String description() {
        return this.optString("description");
    }

    public Status status() {
        return this.optEnum("status", Status.class);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Timestamp archivedAt() {
        return this.optTimestamp("archived_at");
    }

    public List<Attribute> attributes() {
        return this.optList("attributes", Attribute.class);
    }

    public String businessEntityId() {
        return this.optString("business_entity_id");
    }

    public static CreateRequest create() {
        String uri = PriceVariant.uri("price_variants");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = PriceVariant.uri("price_variants", PriceVariant.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static UpdateRequest update(String id) {
        String uri = PriceVariant.uri("price_variants", PriceVariant.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) {
        String uri = PriceVariant.uri("price_variants", PriceVariant.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static PriceVariantListRequest list() {
        String uri = PriceVariant.uri("price_variants");
        return new PriceVariantListRequest(uri);
    }

    public static class PriceVariantListRequest
    extends ListRequest<PriceVariantListRequest> {
        private PriceVariantListRequest(String uri) {
            super(uri);
        }

        public StringFilter<PriceVariantListRequest> id() {
            return new StringFilter<PriceVariantListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<PriceVariantListRequest> name() {
            return new StringFilter<PriceVariantListRequest>("name", this).supportsMultiOperators(true);
        }

        public EnumFilter<Status, PriceVariantListRequest> status() {
            return new EnumFilter<Status, PriceVariantListRequest>("status", this);
        }

        public TimestampFilter<PriceVariantListRequest> updatedAt() {
            return new TimestampFilter<PriceVariantListRequest>("updated_at", this);
        }

        public TimestampFilter<PriceVariantListRequest> createdAt() {
            return new TimestampFilter<PriceVariantListRequest>("created_at", this);
        }

        public StringFilter<PriceVariantListRequest> businessEntityId() {
            return new StringFilter<PriceVariantListRequest>("business_entity_id", this).supportsPresenceOperator(true);
        }

        public BooleanFilter<PriceVariantListRequest> includeSiteLevelResources() {
            return new BooleanFilter<PriceVariantListRequest>("include_site_level_resources", this);
        }

        public PriceVariantListRequest sortByName(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "name");
            return this;
        }

        public PriceVariantListRequest sortById(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "id");
            return this;
        }

        public PriceVariantListRequest sortByStatus(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "status");
            return this;
        }

        public PriceVariantListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        public PriceVariantListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest externalName(String externalName) {
            this.params.addOpt("external_name", externalName);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public UpdateRequest variantGroup(String variantGroup) {
            this.params.addOpt("variant_group", variantGroup);
            return this;
        }

        public UpdateRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public UpdateRequest attributeName(int index, String attributeName) {
            this.params.add("attributes[name][" + index + "]", attributeName);
            return this;
        }

        public UpdateRequest attributeValue(int index, String attributeValue) {
            this.params.add("attributes[value][" + index + "]", attributeValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest externalName(String externalName) {
            this.params.addOpt("external_name", externalName);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public CreateRequest variantGroup(String variantGroup) {
            this.params.addOpt("variant_group", variantGroup);
            return this;
        }

        public CreateRequest businessEntityId(String businessEntityId) {
            this.params.addOpt("business_entity_id", businessEntityId);
            return this;
        }

        public CreateRequest attributeName(int index, String attributeName) {
            this.params.add("attributes[name][" + index + "]", attributeName);
            return this;
        }

        public CreateRequest attributeValue(int index, String attributeValue) {
            this.params.add("attributes[value][" + index + "]", attributeValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Attribute
    extends Resource<Attribute> {
        public Attribute(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String name() {
            return this.reqString("name");
        }

        public String value() {
            return this.reqString("value");
        }
    }

    public static enum Status {
        ACTIVE,
        ARCHIVED,
        DELETED,
        _UNKNOWN;

    }
}

