/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.CompositeArrayParameter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.ParamsV2;
import com.chargebee.internal.PrimitiveParameter;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.ApplyOn;
import com.chargebee.models.enums.DurationType;
import com.chargebee.models.enums.PeriodUnit;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class Ramp
extends Resource<Ramp> {
    public Ramp(String jsonStr) {
        super(jsonStr);
    }

    public Ramp(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String description() {
        return this.optString("description");
    }

    public String subscriptionId() {
        return this.reqString("subscription_id");
    }

    public Timestamp effectiveFrom() {
        return this.reqTimestamp("effective_from");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public List<ItemsToAdd> itemsToAdd() {
        return this.optList("items_to_add", ItemsToAdd.class);
    }

    public List<ItemsToUpdate> itemsToUpdate() {
        return this.optList("items_to_update", ItemsToUpdate.class);
    }

    public List<CouponsToAdd> couponsToAdd() {
        return this.optList("coupons_to_add", CouponsToAdd.class);
    }

    public List<DiscountsToAdd> discountsToAdd() {
        return this.optList("discounts_to_add", DiscountsToAdd.class);
    }

    public List<ItemTier> itemTiers() {
        return this.optList("item_tiers", ItemTier.class);
    }

    public List<String> itemsToRemove() {
        return this.optList("items_to_remove", String.class);
    }

    public List<String> couponsToRemove() {
        return this.optList("coupons_to_remove", String.class);
    }

    public List<String> discountsToRemove() {
        return this.optList("discounts_to_remove", String.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public StatusTransitionReason statusTransitionReason() {
        return this.optSubResource("status_transition_reason", StatusTransitionReason.class);
    }

    public static CreateForSubscriptionRequest createForSubscription(String id) {
        String uri = Ramp.uri("subscriptions", Ramp.nullCheck(id), "create_ramp");
        return new CreateForSubscriptionRequest(HttpUtil.Method.POST, uri, Ramp.nullCheckWithoutEncoding(id));
    }

    public static UpdateRequest update(String id) {
        String uri = Ramp.uri("ramps", Ramp.nullCheck(id), "update");
        return new UpdateRequest(HttpUtil.Method.POST, uri, Ramp.nullCheckWithoutEncoding(id));
    }

    public static Request retrieve(String id) {
        String uri = Ramp.uri("ramps", Ramp.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request delete(String id) {
        String uri = Ramp.uri("ramps", Ramp.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri, Ramp.nullCheckWithoutEncoding(id));
    }

    public static RampListRequest list() {
        String uri = Ramp.uri("ramps");
        return new RampListRequest(uri);
    }

    public static class RampListRequest
    extends ListRequest<RampListRequest> {
        private RampListRequest(String uri) {
            super(uri);
        }

        public RampListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public EnumFilter<Status, RampListRequest> status() {
            return new EnumFilter<Status, RampListRequest>("status", this);
        }

        public StringFilter<RampListRequest> subscriptionId() {
            return new StringFilter<RampListRequest>("subscription_id", this).supportsMultiOperators(true);
        }

        public TimestampFilter<RampListRequest> effectiveFrom() {
            return new TimestampFilter<RampListRequest>("effective_from", this);
        }

        public TimestampFilter<RampListRequest> updatedAt() {
            return new TimestampFilter<RampListRequest>("updated_at", this);
        }

        public RampListRequest sortByEffectiveFrom(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "effective_from");
            return this;
        }

        public RampListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        private UpdateRequest(HttpUtil.Method httpMeth, String uri, String pathParam) {
            super(httpMeth, uri, pathParam);
        }

        public UpdateRequest effectiveFrom(Timestamp effectiveFrom) {
            this.params.add("effective_from", effectiveFrom);
            this.paramsV2.add(new PrimitiveParameter("effective_from"), effectiveFrom);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            this.paramsV2.addOpt(new PrimitiveParameter("description"), description);
            return this;
        }

        public UpdateRequest couponsToRemove(List<String> couponsToRemove) {
            this.params.addOpt("coupons_to_remove", couponsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("coupons_to_remove"), couponsToRemove);
            return this;
        }

        public UpdateRequest couponsToRemove(String ... couponsToRemove) {
            this.params.addOpt("coupons_to_remove", couponsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("coupons_to_remove"), couponsToRemove);
            return this;
        }

        public UpdateRequest discountsToRemove(List<String> discountsToRemove) {
            this.params.addOpt("discounts_to_remove", discountsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("discounts_to_remove"), discountsToRemove);
            return this;
        }

        public UpdateRequest discountsToRemove(String ... discountsToRemove) {
            this.params.addOpt("discounts_to_remove", discountsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("discounts_to_remove"), discountsToRemove);
            return this;
        }

        public UpdateRequest itemsToRemove(List<String> itemsToRemove) {
            this.params.addOpt("items_to_remove", itemsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("items_to_remove"), itemsToRemove);
            return this;
        }

        public UpdateRequest itemsToRemove(String ... itemsToRemove) {
            this.params.addOpt("items_to_remove", itemsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("items_to_remove"), itemsToRemove);
            return this;
        }

        public UpdateRequest itemsToAddItemPriceId(int index, String itemsToAddItemPriceId) {
            this.params.add("items_to_add[item_price_id][" + index + "]", itemsToAddItemPriceId);
            this.paramsV2.add(new CompositeArrayParameter("items_to_add", "item_price_id", index), itemsToAddItemPriceId);
            return this;
        }

        public UpdateRequest itemsToAddQuantity(int index, Integer itemsToAddQuantity) {
            this.params.addOpt("items_to_add[quantity][" + index + "]", itemsToAddQuantity);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "quantity", index), itemsToAddQuantity);
            return this;
        }

        public UpdateRequest itemsToAddQuantityInDecimal(int index, String itemsToAddQuantityInDecimal) {
            this.params.addOpt("items_to_add[quantity_in_decimal][" + index + "]", itemsToAddQuantityInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "quantity_in_decimal", index), itemsToAddQuantityInDecimal);
            return this;
        }

        public UpdateRequest itemsToAddUnitPrice(int index, Long itemsToAddUnitPrice) {
            this.params.addOpt("items_to_add[unit_price][" + index + "]", itemsToAddUnitPrice);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "unit_price", index), itemsToAddUnitPrice);
            return this;
        }

        public UpdateRequest itemsToAddUnitPriceInDecimal(int index, String itemsToAddUnitPriceInDecimal) {
            this.params.addOpt("items_to_add[unit_price_in_decimal][" + index + "]", itemsToAddUnitPriceInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "unit_price_in_decimal", index), itemsToAddUnitPriceInDecimal);
            return this;
        }

        public UpdateRequest itemsToAddBillingCycles(int index, Integer itemsToAddBillingCycles) {
            this.params.addOpt("items_to_add[billing_cycles][" + index + "]", itemsToAddBillingCycles);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "billing_cycles", index), itemsToAddBillingCycles);
            return this;
        }

        public UpdateRequest itemsToAddServicePeriodDays(int index, Integer itemsToAddServicePeriodDays) {
            this.params.addOpt("items_to_add[service_period_days][" + index + "]", itemsToAddServicePeriodDays);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "service_period_days", index), itemsToAddServicePeriodDays);
            return this;
        }

        public UpdateRequest itemsToUpdateItemPriceId(int index, String itemsToUpdateItemPriceId) {
            this.params.add("items_to_update[item_price_id][" + index + "]", itemsToUpdateItemPriceId);
            this.paramsV2.add(new CompositeArrayParameter("items_to_update", "item_price_id", index), itemsToUpdateItemPriceId);
            return this;
        }

        public UpdateRequest itemsToUpdateQuantity(int index, Integer itemsToUpdateQuantity) {
            this.params.addOpt("items_to_update[quantity][" + index + "]", itemsToUpdateQuantity);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "quantity", index), itemsToUpdateQuantity);
            return this;
        }

        public UpdateRequest itemsToUpdateQuantityInDecimal(int index, String itemsToUpdateQuantityInDecimal) {
            this.params.addOpt("items_to_update[quantity_in_decimal][" + index + "]", itemsToUpdateQuantityInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "quantity_in_decimal", index), itemsToUpdateQuantityInDecimal);
            return this;
        }

        public UpdateRequest itemsToUpdateUnitPrice(int index, Long itemsToUpdateUnitPrice) {
            this.params.addOpt("items_to_update[unit_price][" + index + "]", itemsToUpdateUnitPrice);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "unit_price", index), itemsToUpdateUnitPrice);
            return this;
        }

        public UpdateRequest itemsToUpdateUnitPriceInDecimal(int index, String itemsToUpdateUnitPriceInDecimal) {
            this.params.addOpt("items_to_update[unit_price_in_decimal][" + index + "]", itemsToUpdateUnitPriceInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "unit_price_in_decimal", index), itemsToUpdateUnitPriceInDecimal);
            return this;
        }

        public UpdateRequest itemsToUpdateBillingCycles(int index, Integer itemsToUpdateBillingCycles) {
            this.params.addOpt("items_to_update[billing_cycles][" + index + "]", itemsToUpdateBillingCycles);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "billing_cycles", index), itemsToUpdateBillingCycles);
            return this;
        }

        public UpdateRequest itemsToUpdateServicePeriodDays(int index, Integer itemsToUpdateServicePeriodDays) {
            this.params.addOpt("items_to_update[service_period_days][" + index + "]", itemsToUpdateServicePeriodDays);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "service_period_days", index), itemsToUpdateServicePeriodDays);
            return this;
        }

        public UpdateRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "item_price_id", index), itemTierItemPriceId);
            return this;
        }

        public UpdateRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "starting_unit", index), itemTierStartingUnit);
            return this;
        }

        public UpdateRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "ending_unit", index), itemTierEndingUnit);
            return this;
        }

        public UpdateRequest itemTierPrice(int index, Long itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "price", index), itemTierPrice);
            return this;
        }

        public UpdateRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "starting_unit_in_decimal", index), itemTierStartingUnitInDecimal);
            return this;
        }

        public UpdateRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "ending_unit_in_decimal", index), itemTierEndingUnitInDecimal);
            return this;
        }

        public UpdateRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "price_in_decimal", index), itemTierPriceInDecimal);
            return this;
        }

        public UpdateRequest couponsToAddCouponId(int index, String couponsToAddCouponId) {
            this.params.addOpt("coupons_to_add[coupon_id][" + index + "]", couponsToAddCouponId);
            this.paramsV2.addOpt(new CompositeArrayParameter("coupons_to_add", "coupon_id", index), couponsToAddCouponId);
            return this;
        }

        public UpdateRequest couponsToAddApplyTill(int index, Timestamp couponsToAddApplyTill) {
            this.params.addOpt("coupons_to_add[apply_till][" + index + "]", couponsToAddApplyTill);
            this.paramsV2.addOpt(new CompositeArrayParameter("coupons_to_add", "apply_till", index), couponsToAddApplyTill);
            return this;
        }

        public UpdateRequest discountsToAddApplyOn(int index, ApplyOn discountsToAddApplyOn) {
            this.params.add("discounts_to_add[apply_on][" + index + "]", (Object)discountsToAddApplyOn);
            this.paramsV2.add(new CompositeArrayParameter("discounts_to_add", "apply_on", index), (Object)discountsToAddApplyOn);
            return this;
        }

        public UpdateRequest discountsToAddDurationType(int index, DurationType discountsToAddDurationType) {
            this.params.add("discounts_to_add[duration_type][" + index + "]", (Object)discountsToAddDurationType);
            this.paramsV2.add(new CompositeArrayParameter("discounts_to_add", "duration_type", index), (Object)discountsToAddDurationType);
            return this;
        }

        public UpdateRequest discountsToAddPercentage(int index, Double discountsToAddPercentage) {
            this.params.addOpt("discounts_to_add[percentage][" + index + "]", discountsToAddPercentage);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "percentage", index), discountsToAddPercentage);
            return this;
        }

        public UpdateRequest discountsToAddAmount(int index, Long discountsToAddAmount) {
            this.params.addOpt("discounts_to_add[amount][" + index + "]", discountsToAddAmount);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "amount", index), discountsToAddAmount);
            return this;
        }

        public UpdateRequest discountsToAddPeriod(int index, Integer discountsToAddPeriod) {
            this.params.addOpt("discounts_to_add[period][" + index + "]", discountsToAddPeriod);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "period", index), discountsToAddPeriod);
            return this;
        }

        public UpdateRequest discountsToAddPeriodUnit(int index, PeriodUnit discountsToAddPeriodUnit) {
            this.params.addOpt("discounts_to_add[period_unit][" + index + "]", (Object)discountsToAddPeriodUnit);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "period_unit", index), (Object)discountsToAddPeriodUnit);
            return this;
        }

        public UpdateRequest discountsToAddIncludedInMrr(int index, Boolean discountsToAddIncludedInMrr) {
            this.params.addOpt("discounts_to_add[included_in_mrr][" + index + "]", discountsToAddIncludedInMrr);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "included_in_mrr", index), discountsToAddIncludedInMrr);
            return this;
        }

        public UpdateRequest discountsToAddItemPriceId(int index, String discountsToAddItemPriceId) {
            this.params.addOpt("discounts_to_add[item_price_id][" + index + "]", discountsToAddItemPriceId);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "item_price_id", index), discountsToAddItemPriceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }

        @Override
        public ParamsV2 paramsV2() {
            return this.paramsV2;
        }
    }

    public static class CreateForSubscriptionRequest
    extends Request<CreateForSubscriptionRequest> {
        private CreateForSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        private CreateForSubscriptionRequest(HttpUtil.Method httpMeth, String uri, String pathParam) {
            super(httpMeth, uri, pathParam);
        }

        public CreateForSubscriptionRequest effectiveFrom(Timestamp effectiveFrom) {
            this.params.add("effective_from", effectiveFrom);
            this.paramsV2.add(new PrimitiveParameter("effective_from"), effectiveFrom);
            return this;
        }

        public CreateForSubscriptionRequest description(String description) {
            this.params.addOpt("description", description);
            this.paramsV2.addOpt(new PrimitiveParameter("description"), description);
            return this;
        }

        public CreateForSubscriptionRequest couponsToRemove(List<String> couponsToRemove) {
            this.params.addOpt("coupons_to_remove", couponsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("coupons_to_remove"), couponsToRemove);
            return this;
        }

        public CreateForSubscriptionRequest couponsToRemove(String ... couponsToRemove) {
            this.params.addOpt("coupons_to_remove", couponsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("coupons_to_remove"), couponsToRemove);
            return this;
        }

        public CreateForSubscriptionRequest discountsToRemove(List<String> discountsToRemove) {
            this.params.addOpt("discounts_to_remove", discountsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("discounts_to_remove"), discountsToRemove);
            return this;
        }

        public CreateForSubscriptionRequest discountsToRemove(String ... discountsToRemove) {
            this.params.addOpt("discounts_to_remove", discountsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("discounts_to_remove"), discountsToRemove);
            return this;
        }

        public CreateForSubscriptionRequest itemsToRemove(List<String> itemsToRemove) {
            this.params.addOpt("items_to_remove", itemsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("items_to_remove"), itemsToRemove);
            return this;
        }

        public CreateForSubscriptionRequest itemsToRemove(String ... itemsToRemove) {
            this.params.addOpt("items_to_remove", itemsToRemove);
            this.paramsV2.addOpt(new PrimitiveParameter("items_to_remove"), itemsToRemove);
            return this;
        }

        public CreateForSubscriptionRequest itemsToAddItemPriceId(int index, String itemsToAddItemPriceId) {
            this.params.add("items_to_add[item_price_id][" + index + "]", itemsToAddItemPriceId);
            this.paramsV2.add(new CompositeArrayParameter("items_to_add", "item_price_id", index), itemsToAddItemPriceId);
            return this;
        }

        public CreateForSubscriptionRequest itemsToAddQuantity(int index, Integer itemsToAddQuantity) {
            this.params.addOpt("items_to_add[quantity][" + index + "]", itemsToAddQuantity);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "quantity", index), itemsToAddQuantity);
            return this;
        }

        public CreateForSubscriptionRequest itemsToAddQuantityInDecimal(int index, String itemsToAddQuantityInDecimal) {
            this.params.addOpt("items_to_add[quantity_in_decimal][" + index + "]", itemsToAddQuantityInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "quantity_in_decimal", index), itemsToAddQuantityInDecimal);
            return this;
        }

        public CreateForSubscriptionRequest itemsToAddUnitPrice(int index, Long itemsToAddUnitPrice) {
            this.params.addOpt("items_to_add[unit_price][" + index + "]", itemsToAddUnitPrice);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "unit_price", index), itemsToAddUnitPrice);
            return this;
        }

        public CreateForSubscriptionRequest itemsToAddUnitPriceInDecimal(int index, String itemsToAddUnitPriceInDecimal) {
            this.params.addOpt("items_to_add[unit_price_in_decimal][" + index + "]", itemsToAddUnitPriceInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "unit_price_in_decimal", index), itemsToAddUnitPriceInDecimal);
            return this;
        }

        public CreateForSubscriptionRequest itemsToAddBillingCycles(int index, Integer itemsToAddBillingCycles) {
            this.params.addOpt("items_to_add[billing_cycles][" + index + "]", itemsToAddBillingCycles);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "billing_cycles", index), itemsToAddBillingCycles);
            return this;
        }

        public CreateForSubscriptionRequest itemsToAddServicePeriodDays(int index, Integer itemsToAddServicePeriodDays) {
            this.params.addOpt("items_to_add[service_period_days][" + index + "]", itemsToAddServicePeriodDays);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_add", "service_period_days", index), itemsToAddServicePeriodDays);
            return this;
        }

        public CreateForSubscriptionRequest itemsToUpdateItemPriceId(int index, String itemsToUpdateItemPriceId) {
            this.params.add("items_to_update[item_price_id][" + index + "]", itemsToUpdateItemPriceId);
            this.paramsV2.add(new CompositeArrayParameter("items_to_update", "item_price_id", index), itemsToUpdateItemPriceId);
            return this;
        }

        public CreateForSubscriptionRequest itemsToUpdateQuantity(int index, Integer itemsToUpdateQuantity) {
            this.params.addOpt("items_to_update[quantity][" + index + "]", itemsToUpdateQuantity);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "quantity", index), itemsToUpdateQuantity);
            return this;
        }

        public CreateForSubscriptionRequest itemsToUpdateQuantityInDecimal(int index, String itemsToUpdateQuantityInDecimal) {
            this.params.addOpt("items_to_update[quantity_in_decimal][" + index + "]", itemsToUpdateQuantityInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "quantity_in_decimal", index), itemsToUpdateQuantityInDecimal);
            return this;
        }

        public CreateForSubscriptionRequest itemsToUpdateUnitPrice(int index, Long itemsToUpdateUnitPrice) {
            this.params.addOpt("items_to_update[unit_price][" + index + "]", itemsToUpdateUnitPrice);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "unit_price", index), itemsToUpdateUnitPrice);
            return this;
        }

        public CreateForSubscriptionRequest itemsToUpdateUnitPriceInDecimal(int index, String itemsToUpdateUnitPriceInDecimal) {
            this.params.addOpt("items_to_update[unit_price_in_decimal][" + index + "]", itemsToUpdateUnitPriceInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "unit_price_in_decimal", index), itemsToUpdateUnitPriceInDecimal);
            return this;
        }

        public CreateForSubscriptionRequest itemsToUpdateBillingCycles(int index, Integer itemsToUpdateBillingCycles) {
            this.params.addOpt("items_to_update[billing_cycles][" + index + "]", itemsToUpdateBillingCycles);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "billing_cycles", index), itemsToUpdateBillingCycles);
            return this;
        }

        public CreateForSubscriptionRequest itemsToUpdateServicePeriodDays(int index, Integer itemsToUpdateServicePeriodDays) {
            this.params.addOpt("items_to_update[service_period_days][" + index + "]", itemsToUpdateServicePeriodDays);
            this.paramsV2.addOpt(new CompositeArrayParameter("items_to_update", "service_period_days", index), itemsToUpdateServicePeriodDays);
            return this;
        }

        public CreateForSubscriptionRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "item_price_id", index), itemTierItemPriceId);
            return this;
        }

        public CreateForSubscriptionRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "starting_unit", index), itemTierStartingUnit);
            return this;
        }

        public CreateForSubscriptionRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "ending_unit", index), itemTierEndingUnit);
            return this;
        }

        public CreateForSubscriptionRequest itemTierPrice(int index, Long itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "price", index), itemTierPrice);
            return this;
        }

        public CreateForSubscriptionRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "starting_unit_in_decimal", index), itemTierStartingUnitInDecimal);
            return this;
        }

        public CreateForSubscriptionRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "ending_unit_in_decimal", index), itemTierEndingUnitInDecimal);
            return this;
        }

        public CreateForSubscriptionRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            this.paramsV2.addOpt(new CompositeArrayParameter("item_tiers", "price_in_decimal", index), itemTierPriceInDecimal);
            return this;
        }

        public CreateForSubscriptionRequest couponsToAddCouponId(int index, String couponsToAddCouponId) {
            this.params.addOpt("coupons_to_add[coupon_id][" + index + "]", couponsToAddCouponId);
            this.paramsV2.addOpt(new CompositeArrayParameter("coupons_to_add", "coupon_id", index), couponsToAddCouponId);
            return this;
        }

        public CreateForSubscriptionRequest couponsToAddApplyTill(int index, Timestamp couponsToAddApplyTill) {
            this.params.addOpt("coupons_to_add[apply_till][" + index + "]", couponsToAddApplyTill);
            this.paramsV2.addOpt(new CompositeArrayParameter("coupons_to_add", "apply_till", index), couponsToAddApplyTill);
            return this;
        }

        public CreateForSubscriptionRequest discountsToAddApplyOn(int index, ApplyOn discountsToAddApplyOn) {
            this.params.add("discounts_to_add[apply_on][" + index + "]", (Object)discountsToAddApplyOn);
            this.paramsV2.add(new CompositeArrayParameter("discounts_to_add", "apply_on", index), (Object)discountsToAddApplyOn);
            return this;
        }

        public CreateForSubscriptionRequest discountsToAddDurationType(int index, DurationType discountsToAddDurationType) {
            this.params.add("discounts_to_add[duration_type][" + index + "]", (Object)discountsToAddDurationType);
            this.paramsV2.add(new CompositeArrayParameter("discounts_to_add", "duration_type", index), (Object)discountsToAddDurationType);
            return this;
        }

        public CreateForSubscriptionRequest discountsToAddPercentage(int index, Double discountsToAddPercentage) {
            this.params.addOpt("discounts_to_add[percentage][" + index + "]", discountsToAddPercentage);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "percentage", index), discountsToAddPercentage);
            return this;
        }

        public CreateForSubscriptionRequest discountsToAddAmount(int index, Long discountsToAddAmount) {
            this.params.addOpt("discounts_to_add[amount][" + index + "]", discountsToAddAmount);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "amount", index), discountsToAddAmount);
            return this;
        }

        public CreateForSubscriptionRequest discountsToAddPeriod(int index, Integer discountsToAddPeriod) {
            this.params.addOpt("discounts_to_add[period][" + index + "]", discountsToAddPeriod);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "period", index), discountsToAddPeriod);
            return this;
        }

        public CreateForSubscriptionRequest discountsToAddPeriodUnit(int index, PeriodUnit discountsToAddPeriodUnit) {
            this.params.addOpt("discounts_to_add[period_unit][" + index + "]", (Object)discountsToAddPeriodUnit);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "period_unit", index), (Object)discountsToAddPeriodUnit);
            return this;
        }

        public CreateForSubscriptionRequest discountsToAddIncludedInMrr(int index, Boolean discountsToAddIncludedInMrr) {
            this.params.addOpt("discounts_to_add[included_in_mrr][" + index + "]", discountsToAddIncludedInMrr);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "included_in_mrr", index), discountsToAddIncludedInMrr);
            return this;
        }

        public CreateForSubscriptionRequest discountsToAddItemPriceId(int index, String discountsToAddItemPriceId) {
            this.params.addOpt("discounts_to_add[item_price_id][" + index + "]", discountsToAddItemPriceId);
            this.paramsV2.addOpt(new CompositeArrayParameter("discounts_to_add", "item_price_id", index), discountsToAddItemPriceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }

        @Override
        public ParamsV2 paramsV2() {
            return this.paramsV2;
        }
    }

    public static class StatusTransitionReason
    extends Resource<StatusTransitionReason> {
        public StatusTransitionReason(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String code() {
            return this.optString("code");
        }

        public String message() {
            return this.optString("message");
        }
    }

    public static class ItemTier
    extends Resource<ItemTier> {
        public ItemTier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String itemPriceId() {
            return this.reqString("item_price_id");
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Long price() {
            return this.reqLong("price");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String priceInDecimal() {
            return this.optString("price_in_decimal");
        }

        public Integer index() {
            return this.reqInteger("index");
        }
    }

    public static class DiscountsToAdd
    extends Resource<DiscountsToAdd> {
        public DiscountsToAdd(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public String invoiceName() {
            return this.optString("invoice_name");
        }

        public Type type() {
            return this.reqEnum("type", Type.class);
        }

        public Double percentage() {
            return this.optDouble("percentage");
        }

        public Long amount() {
            return this.optLong("amount");
        }

        public DurationType durationType() {
            return this.reqEnum("duration_type", DurationType.class);
        }

        public Integer period() {
            return this.optInteger("period");
        }

        public PeriodUnit periodUnit() {
            return this.optEnum("period_unit", PeriodUnit.class);
        }

        public Boolean includedInMrr() {
            return this.reqBoolean("included_in_mrr");
        }

        public ApplyOn applyOn() {
            return this.reqEnum("apply_on", ApplyOn.class);
        }

        public String itemPriceId() {
            return this.optString("item_price_id");
        }

        public Timestamp createdAt() {
            return this.reqTimestamp("created_at");
        }

        public static enum ApplyOn {
            INVOICE_AMOUNT,
            SPECIFIC_ITEM_PRICE,
            _UNKNOWN;

        }

        public static enum DurationType {
            ONE_TIME,
            FOREVER,
            LIMITED_PERIOD,
            _UNKNOWN;

        }

        public static enum Type {
            FIXED_AMOUNT,
            PERCENTAGE,
            _UNKNOWN;

        }
    }

    public static class CouponsToAdd
    extends Resource<CouponsToAdd> {
        public CouponsToAdd(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String couponId() {
            return this.reqString("coupon_id");
        }

        public Timestamp applyTill() {
            return this.optTimestamp("apply_till");
        }
    }

    public static class ItemsToUpdate
    extends Resource<ItemsToUpdate> {
        public ItemsToUpdate(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String itemPriceId() {
            return this.reqString("item_price_id");
        }

        public ItemType itemType() {
            return this.reqEnum("item_type", ItemType.class);
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public String quantityInDecimal() {
            return this.optString("quantity_in_decimal");
        }

        public Long unitPrice() {
            return this.optLong("unit_price");
        }

        public String unitPriceInDecimal() {
            return this.optString("unit_price_in_decimal");
        }

        public Long amount() {
            return this.optLong("amount");
        }

        public String amountInDecimal() {
            return this.optString("amount_in_decimal");
        }

        public Integer freeQuantity() {
            return this.optInteger("free_quantity");
        }

        public String freeQuantityInDecimal() {
            return this.optString("free_quantity_in_decimal");
        }

        public Integer billingCycles() {
            return this.optInteger("billing_cycles");
        }

        public Integer servicePeriodDays() {
            return this.optInteger("service_period_days");
        }

        public String meteredQuantity() {
            return this.optString("metered_quantity");
        }

        public static enum ItemType {
            PLAN,
            ADDON,
            CHARGE,
            _UNKNOWN;

        }
    }

    public static class ItemsToAdd
    extends Resource<ItemsToAdd> {
        public ItemsToAdd(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String itemPriceId() {
            return this.reqString("item_price_id");
        }

        public ItemType itemType() {
            return this.reqEnum("item_type", ItemType.class);
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public String quantityInDecimal() {
            return this.optString("quantity_in_decimal");
        }

        public Long unitPrice() {
            return this.optLong("unit_price");
        }

        public String unitPriceInDecimal() {
            return this.optString("unit_price_in_decimal");
        }

        public Long amount() {
            return this.optLong("amount");
        }

        public String amountInDecimal() {
            return this.optString("amount_in_decimal");
        }

        public Integer freeQuantity() {
            return this.optInteger("free_quantity");
        }

        public String freeQuantityInDecimal() {
            return this.optString("free_quantity_in_decimal");
        }

        public Integer billingCycles() {
            return this.optInteger("billing_cycles");
        }

        public Integer servicePeriodDays() {
            return this.optInteger("service_period_days");
        }

        public String meteredQuantity() {
            return this.optString("metered_quantity");
        }

        public static enum ItemType {
            PLAN,
            ADDON,
            CHARGE,
            _UNKNOWN;

        }
    }

    public static enum Status {
        SCHEDULED,
        SUCCEEDED,
        FAILED,
        DRAFT,
        _UNKNOWN;

    }
}

