/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class RecordedPurchase
extends Resource<RecordedPurchase> {
    public RecordedPurchase(String jsonStr) {
        super(jsonStr);
    }

    public RecordedPurchase(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String appId() {
        return this.reqString("app_id");
    }

    public Source source() {
        return this.reqEnum("source", Source.class);
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String omnichannelTransactionId() {
        return this.optString("omnichannel_transaction_id");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public List<LinkedOmnichannelSubscription> linkedOmnichannelSubscriptions() {
        return this.optList("linked_omnichannel_subscriptions", LinkedOmnichannelSubscription.class);
    }

    public ErrorDetail errorDetail() {
        return this.optSubResource("error_detail", ErrorDetail.class);
    }

    public static CreateRequest create() {
        String uri = RecordedPurchase.uri("recorded_purchases");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = RecordedPurchase.uri("recorded_purchases", RecordedPurchase.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest appId(String appId) {
            this.params.add("app_id", appId);
            return this;
        }

        public CreateRequest customerId(String customerId) {
            this.params.add("customer[id]", customerId);
            return this;
        }

        public CreateRequest appleAppStoreTransactionId(String appleAppStoreTransactionId) {
            this.params.addOpt("apple_app_store[transaction_id]", appleAppStoreTransactionId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ErrorDetail
    extends Resource<ErrorDetail> {
        public ErrorDetail(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String errorMessage() {
            return this.optString("error_message");
        }
    }

    public static class LinkedOmnichannelSubscription
    extends Resource<LinkedOmnichannelSubscription> {
        public LinkedOmnichannelSubscription(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String omnichannelSubscriptionId() {
            return this.optString("omnichannel_subscription_id");
        }
    }

    public static enum Status {
        IN_PROCESS,
        COMPLETED,
        FAILED,
        _UNKNOWN;

    }

    public static enum Source {
        APPLE_APP_STORE,
        _UNKNOWN;

    }
}

