/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.DedupeOption;
import com.chargebee.models.enums.DispositionType;
import com.chargebee.models.enums.Source;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class Usage
extends Resource<Usage> {
    public Usage(String jsonStr) {
        super(jsonStr);
    }

    public Usage(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.optString("id");
    }

    public Timestamp usageDate() {
        return this.reqTimestamp("usage_date");
    }

    public String subscriptionId() {
        return this.reqString("subscription_id");
    }

    public String itemPriceId() {
        return this.reqString("item_price_id");
    }

    public String invoiceId() {
        return this.optString("invoice_id");
    }

    public String lineItemId() {
        return this.optString("line_item_id");
    }

    public String quantity() {
        return this.reqString("quantity");
    }

    public Source source() {
        return this.optEnum("source", Source.class);
    }

    public String note() {
        return this.optString("note");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public static CreateRequest create(String id) {
        String uri = Usage.uri("subscriptions", Usage.nullCheck(id), "usages");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static RetrieveRequest retrieve(String id) {
        String uri = Usage.uri("subscriptions", Usage.nullCheck(id), "usages");
        return new RetrieveRequest(HttpUtil.Method.GET, uri);
    }

    public static DeleteRequest delete(String id) {
        String uri = Usage.uri("subscriptions", Usage.nullCheck(id), "delete_usage");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    public static UsageListRequest list() {
        String uri = Usage.uri("usages");
        return new UsageListRequest(uri);
    }

    public static PdfRequest pdf() {
        String uri = Usage.uri("usages", "pdf");
        return new PdfRequest(HttpUtil.Method.POST, uri);
    }

    public static class PdfRequest
    extends Request<PdfRequest> {
        private PdfRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public PdfRequest dispositionType(DispositionType dispositionType) {
            this.params.addOpt("disposition_type", (Object)dispositionType);
            return this;
        }

        public PdfRequest invoiceId(String invoiceId) {
            this.params.add("invoice[id]", invoiceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UsageListRequest
    extends ListRequest<UsageListRequest> {
        private UsageListRequest(String uri) {
            super(uri);
        }

        public StringFilter<UsageListRequest> id() {
            return new StringFilter<UsageListRequest>("id", this);
        }

        public StringFilter<UsageListRequest> subscriptionId() {
            return new StringFilter<UsageListRequest>("subscription_id", this);
        }

        public TimestampFilter<UsageListRequest> usageDate() {
            return new TimestampFilter<UsageListRequest>("usage_date", this);
        }

        public TimestampFilter<UsageListRequest> updatedAt() {
            return new TimestampFilter<UsageListRequest>("updated_at", this);
        }

        public StringFilter<UsageListRequest> itemPriceId() {
            return new StringFilter<UsageListRequest>("item_price_id", this);
        }

        public StringFilter<UsageListRequest> invoiceId() {
            return new StringFilter<UsageListRequest>("invoice_id", this).supportsPresenceOperator(true);
        }

        public EnumFilter<Source, UsageListRequest> source() {
            return new EnumFilter<Source, UsageListRequest>("source", this);
        }

        public UsageListRequest sortByUsageDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "usage_date");
            return this;
        }

        public UsageListRequest sortByUpdatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "updated_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RetrieveRequest
    extends Request<RetrieveRequest> {
        private RetrieveRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RetrieveRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateRequest itemPriceId(String itemPriceId) {
            this.params.add("item_price_id", itemPriceId);
            return this;
        }

        public CreateRequest quantity(String quantity) {
            this.params.add("quantity", quantity);
            return this;
        }

        public CreateRequest usageDate(Timestamp usageDate) {
            this.params.add("usage_date", usageDate);
            return this;
        }

        @Deprecated
        public CreateRequest dedupeOption(DedupeOption dedupeOption) {
            this.params.addOpt("dedupe_option", (Object)dedupeOption);
            return this;
        }

        public CreateRequest note(String note) {
            this.params.addOpt("note", note);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }
}

