/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Date;

public class UnixTimestampModule
extends SimpleModule {
    public UnixTimestampModule() {
        this.addSerializer(Date.class, new UnixTimestampSerializer());
        this.addDeserializer(Date.class, new UnixTimestampDeserializer());
    }

    static class UnixTimestampDeserializer
    extends JsonDeserializer<Date> {
        UnixTimestampDeserializer() {
        }

        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new Date((long)jp.getValueAsInt() * 1000L);
        }
    }

    static class UnixTimestampSerializer
    extends JsonSerializer<Date> {
        UnixTimestampSerializer() {
        }

        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNumber(value.getTime() / 1000L);
        }
    }
}

