// Generated by delombok at Sat Dec 17 11:37:34 PST 2016
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Kunal Shah
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.codepine.api.testrail.model;

import com.codepine.api.testrail.TestRail;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import static com.codepine.api.testrail.model.Field.Type;

/**
 * TestRail case.
 */
public class Case {
    private static final String CUSTOM_FIELD_KEY_PREFIX = "custom_";
    private int id;
    @JsonView({TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private String title;
    private int sectionId;
    @JsonView({TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private Integer typeId;
    @JsonView({TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private Integer priorityId;
    @JsonView({TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private Integer milestoneId;
    @JsonView({TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private String refs;
    private int createdBy;
    private Date createdOn;
    private int updatedBy;
    private Date updatedOn;
    @JsonView({TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private String estimate;
    private String estimateForecast;
    private int suiteId;
    @JsonView({TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    @JsonIgnore
    private Map<String, Object> customFields;

    @JsonAnyGetter
    @JsonSerialize(keyUsing = CustomFieldSerializer.class)
    public Map<String, Object> getCustomFields() {
        return Objects.firstNonNull(customFields, Collections.<String, Object>emptyMap());
    }

    /**
     * Add a custom field.
     *
     * @param key   the name of the custom field with or without "custom_" prefix
     * @param value the value of the custom field
     * @return case instance for chaining
     */
    public Case addCustomField(String key, Object value) {
        if (customFields == null) {
            customFields = new HashMap<>();
        }
        customFields.put(key.replaceFirst(CUSTOM_FIELD_KEY_PREFIX, ""), value);
        return this;
    }

    /**
     * Support for forward compatibility and extracting custom fields.
     *
     * @param key the name of the unknown field
     * @param value the value of the unkown field
     */
    @JsonAnySetter
    private void addUnknownField(String key, Object value) {
        if (key.startsWith(CUSTOM_FIELD_KEY_PREFIX)) {
            addCustomField(key, value);
        }
    }

    /**
     * Get custom field.
     * <p>Use Java Type Inference, to get the value with correct type. Refer to {@link Type} for a map of TestRail field types to Java types.</p>
     *
     * @param key the system name of custom field
     * @param <T> the type of returned value
     * @return the value of the custom field
     */
    public <T> T getCustomField(String key) {
        return (T)getCustomFields().get(key);
    }

    /**
     * Serializer for custom fields.
     */
    private static class CustomFieldSerializer extends StdKeySerializer {


        @Override
        public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            super.serialize(CUSTOM_FIELD_KEY_PREFIX + o, jsonGenerator, serializerProvider);
        }
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case() {
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getId() {
        return this.id;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getTitle() {
        return this.title;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getSectionId() {
        return this.sectionId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTypeId() {
        return this.typeId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getPriorityId() {
        return this.priorityId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMilestoneId() {
        return this.milestoneId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRefs() {
        return this.refs;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getCreatedBy() {
        return this.createdBy;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Date getCreatedOn() {
        return this.createdOn;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getUpdatedBy() {
        return this.updatedBy;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getEstimate() {
        return this.estimate;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getEstimateForecast() {
        return this.estimateForecast;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getSuiteId() {
        return this.suiteId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setId(final int id) {
        this.id = id;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setTitle(final String title) {
        this.title = title;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setSectionId(final int sectionId) {
        this.sectionId = sectionId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setTypeId(final Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setPriorityId(final Integer priorityId) {
        this.priorityId = priorityId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setMilestoneId(final Integer milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setRefs(final String refs) {
        this.refs = refs;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setCreatedBy(final int createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setCreatedOn(final Date createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setUpdatedBy(final int updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setUpdatedOn(final Date updatedOn) {
        this.updatedOn = updatedOn;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setEstimate(final String estimate) {
        this.estimate = estimate;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setEstimateForecast(final String estimateForecast) {
        this.estimateForecast = estimateForecast;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setSuiteId(final int suiteId) {
        this.suiteId = suiteId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Case setCustomFields(final Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    @Override
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof Case)) return false;
        final Case other = (Case)o;
        if (!other.canEqual((Object)this)) return false;
        if (this.getId() != other.getId()) return false;
        final Object this$title = this.getTitle();
        final Object other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
        if (this.getSectionId() != other.getSectionId()) return false;
        final Object this$typeId = this.getTypeId();
        final Object other$typeId = other.getTypeId();
        if (this$typeId == null ? other$typeId != null : !this$typeId.equals(other$typeId)) return false;
        final Object this$priorityId = this.getPriorityId();
        final Object other$priorityId = other.getPriorityId();
        if (this$priorityId == null ? other$priorityId != null : !this$priorityId.equals(other$priorityId)) return false;
        final Object this$milestoneId = this.getMilestoneId();
        final Object other$milestoneId = other.getMilestoneId();
        if (this$milestoneId == null ? other$milestoneId != null : !this$milestoneId.equals(other$milestoneId)) return false;
        final Object this$refs = this.getRefs();
        final Object other$refs = other.getRefs();
        if (this$refs == null ? other$refs != null : !this$refs.equals(other$refs)) return false;
        if (this.getCreatedBy() != other.getCreatedBy()) return false;
        final Object this$createdOn = this.getCreatedOn();
        final Object other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !this$createdOn.equals(other$createdOn)) return false;
        if (this.getUpdatedBy() != other.getUpdatedBy()) return false;
        final Object this$updatedOn = this.getUpdatedOn();
        final Object other$updatedOn = other.getUpdatedOn();
        if (this$updatedOn == null ? other$updatedOn != null : !this$updatedOn.equals(other$updatedOn)) return false;
        final Object this$estimate = this.getEstimate();
        final Object other$estimate = other.getEstimate();
        if (this$estimate == null ? other$estimate != null : !this$estimate.equals(other$estimate)) return false;
        final Object this$estimateForecast = this.getEstimateForecast();
        final Object other$estimateForecast = other.getEstimateForecast();
        if (this$estimateForecast == null ? other$estimateForecast != null : !this$estimateForecast.equals(other$estimateForecast)) return false;
        if (this.getSuiteId() != other.getSuiteId()) return false;
        final Object this$customFields = this.getCustomFields();
        final Object other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !this$customFields.equals(other$customFields)) return false;
        return true;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final Object other) {
        return other instanceof Case;
    }

    @Override
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getId();
        final Object $title = this.getTitle();
        result = result * PRIME + ($title == null ? 0 : $title.hashCode());
        result = result * PRIME + this.getSectionId();
        final Object $typeId = this.getTypeId();
        result = result * PRIME + ($typeId == null ? 0 : $typeId.hashCode());
        final Object $priorityId = this.getPriorityId();
        result = result * PRIME + ($priorityId == null ? 0 : $priorityId.hashCode());
        final Object $milestoneId = this.getMilestoneId();
        result = result * PRIME + ($milestoneId == null ? 0 : $milestoneId.hashCode());
        final Object $refs = this.getRefs();
        result = result * PRIME + ($refs == null ? 0 : $refs.hashCode());
        result = result * PRIME + this.getCreatedBy();
        final Object $createdOn = this.getCreatedOn();
        result = result * PRIME + ($createdOn == null ? 0 : $createdOn.hashCode());
        result = result * PRIME + this.getUpdatedBy();
        final Object $updatedOn = this.getUpdatedOn();
        result = result * PRIME + ($updatedOn == null ? 0 : $updatedOn.hashCode());
        final Object $estimate = this.getEstimate();
        result = result * PRIME + ($estimate == null ? 0 : $estimate.hashCode());
        final Object $estimateForecast = this.getEstimateForecast();
        result = result * PRIME + ($estimateForecast == null ? 0 : $estimateForecast.hashCode());
        result = result * PRIME + this.getSuiteId();
        final Object $customFields = this.getCustomFields();
        result = result * PRIME + ($customFields == null ? 0 : $customFields.hashCode());
        return result;
    }

    @Override
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String toString() {
        return "Case(id=" + this.getId() + ", title=" + this.getTitle() + ", sectionId=" + this.getSectionId() + ", typeId=" + this.getTypeId() + ", priorityId=" + this.getPriorityId() + ", milestoneId=" + this.getMilestoneId() + ", refs=" + this.getRefs() + ", createdBy=" + this.getCreatedBy() + ", createdOn=" + this.getCreatedOn() + ", updatedBy=" + this.getUpdatedBy() + ", updatedOn=" + this.getUpdatedOn() + ", estimate=" + this.getEstimate() + ", estimateForecast=" + this.getEstimateForecast() + ", suiteId=" + this.getSuiteId() + ", customFields=" + this.getCustomFields() + ")";
    }
}