/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail;

import com.codepine.api.testrail.TestRailConfig;
import com.codepine.api.testrail.TestRailException;
import com.codepine.api.testrail.internal.CaseModule;
import com.codepine.api.testrail.internal.FieldModule;
import com.codepine.api.testrail.internal.PlanModule;
import com.codepine.api.testrail.internal.QueryParameterString;
import com.codepine.api.testrail.internal.ResultModule;
import com.codepine.api.testrail.internal.UnixTimestampModule;
import com.codepine.api.testrail.internal.UrlConnectionFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;
import lombok.NonNull;
import org.apache.log4j.Logger;

public abstract class Request<T> {
    private static final Logger log = Logger.getLogger(Request.class);
    private static final UrlConnectionFactory DEFAULT_URL_CONNECTION_FACTORY = new UrlConnectionFactory();
    private static final ObjectMapper JSON = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModules(new Module[]{new CaseModule(), new FieldModule(), new PlanModule(), new ResultModule(), new UnixTimestampModule()});
    @NonNull
    private final TestRailConfig config;
    @NonNull
    private final Method method;
    @NonNull
    private final String restPath;
    private final Class<? extends T> responseClass;
    private final TypeReference<? extends T> responseType;
    private UrlConnectionFactory urlConnectionFactory = DEFAULT_URL_CONNECTION_FACTORY;

    Request(TestRailConfig config, Method method, String restPath, @NonNull Class<? extends T> responseClass) {
        this(config, method, restPath, responseClass, null);
        if (responseClass == null) {
            throw new NullPointerException("responseClass");
        }
    }

    Request(TestRailConfig config, Method method, String restPath, @NonNull TypeReference<? extends T> responseType) {
        this(config, method, restPath, null, responseType);
        if (responseType == null) {
            throw new NullPointerException("responseType");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T execute() {
        try {
            Throwable throwable;
            String url = this.getUrl();
            HttpURLConnection con = (HttpURLConnection)this.urlConnectionFactory.getUrlConnection(url);
            con.setRequestMethod(this.method.name());
            if (this.config.getApplicationName().isPresent()) {
                con.setRequestProperty("User-Agent", (String)this.config.getApplicationName().get());
            }
            con.setRequestProperty("Content-Type", "application/json");
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])(this.config.getUsername() + ":" + this.config.getPassword()).getBytes(Charset.forName("UTF-8")));
            con.setRequestProperty("Authorization", basicAuth);
            if (this.method == Method.POST) {
                con.setDoOutput(true);
                Object content = this.getContent();
                if (content != null) {
                    throwable = null;
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(con.getOutputStream());){
                        JSON.writerWithView(this.getClass()).writeValue((OutputStream)outputStream, content);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                } else {
                    con.setFixedLengthStreamingMode(0);
                }
            }
            log.debug((Object)("Sending " + (Object)((Object)this.method) + " request to URL : " + url));
            int responseCode = 0;
            try {
                responseCode = con.getResponseCode();
            }
            catch (IOException e) {
                responseCode = con.getResponseCode();
            }
            log.debug((Object)("Response Code : " + responseCode));
            if (responseCode != 200) {
                InputStream errorStream = con.getErrorStream();
                throwable = null;
                try {
                    try {
                        TestRailException.Builder exceptionBuilder = new TestRailException.Builder().setResponseCode(responseCode);
                        if (errorStream != null) throw ((TestRailException.Builder)JSON.readerForUpdating((Object)exceptionBuilder).readValue((InputStream)new BufferedInputStream(errorStream))).build();
                        throw exceptionBuilder.setError("<server did not send any error message>").build();
                    }
                    catch (Throwable exceptionBuilder) {
                        throwable = exceptionBuilder;
                        throw exceptionBuilder;
                    }
                }
                catch (Throwable throwable2) {
                    if (errorStream == null) throw throwable2;
                    if (throwable == null) {
                        errorStream.close();
                        throw throwable2;
                    }
                    try {
                        errorStream.close();
                        throw throwable2;
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                        throw throwable2;
                    }
                }
            }
            throwable = null;
            try (BufferedInputStream responseStream = new BufferedInputStream(con.getInputStream());){
                Object supplementForDeserialization = this.getSupplementForDeserialization();
                if (this.responseClass != null) {
                    if (this.responseClass == Void.class) {
                        T t = null;
                        return t;
                    }
                    if (supplementForDeserialization != null) {
                        Object object = JSON.reader(this.responseClass).with((InjectableValues)new InjectableValues.Std().addValue(this.responseClass.toString(), supplementForDeserialization)).readValue((InputStream)responseStream);
                        return (T)object;
                    }
                    Object object = JSON.readValue((InputStream)responseStream, this.responseClass);
                    return (T)object;
                }
                if (supplementForDeserialization != null) {
                    Object actualTypes;
                    String supplementKey = this.responseType.getType().toString();
                    if (this.responseType.getType() instanceof ParameterizedType && ((Type[])(actualTypes = ((ParameterizedType)this.responseType.getType()).getActualTypeArguments())).length == 1 && actualTypes[0] instanceof Class) {
                        supplementKey = actualTypes[0].toString();
                    }
                    actualTypes = JSON.reader(this.responseType).with((InjectableValues)new InjectableValues.Std().addValue(supplementKey, supplementForDeserialization)).readValue((InputStream)responseStream);
                    return (T)actualTypes;
                }
                Object object = JSON.readValue((InputStream)responseStream, this.responseType);
                return (T)object;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getUrl() throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.config.getBaseApiUrl()).append(this.restPath);
        String queryParamJson = JSON.writerWithView(this.getClass()).writeValueAsString((Object)this);
        String queryParamString = ((QueryParameterString)JSON.readValue(queryParamJson, QueryParameterString.class)).toString();
        if (!queryParamString.isEmpty()) {
            urlBuilder.append("&").append(queryParamString);
        }
        return urlBuilder.toString();
    }

    Object getContent() {
        return null;
    }

    Object getSupplementForDeserialization() {
        return null;
    }

    void setUrlConnectionFactory(UrlConnectionFactory urlConnectionFactory) {
        this.urlConnectionFactory = urlConnectionFactory;
    }

    private Request(@NonNull TestRailConfig config, @NonNull Method method, @NonNull String restPath, Class<? extends T> responseClass, TypeReference<? extends T> responseType) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (restPath == null) {
            throw new NullPointerException("restPath");
        }
        this.config = config;
        this.method = method;
        this.restPath = restPath;
        this.responseClass = responseClass;
        this.responseType = responseType;
    }

    static enum Method {
        GET,
        POST;

    }
}

