/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail.internal;

import com.codepine.api.testrail.model.Plan;
import com.codepine.api.testrail.model.Run;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class PlanModule
extends SimpleModule {
    public void setupModule(Module.SetupContext setupContext) {
        setupContext.addBeanDeserializerModifier((BeanDeserializerModifier)new PlanDeserializerModifier());
        super.setupModule(setupContext);
    }

    private static class PlanDeserializerModifier
    extends BeanDeserializerModifier {
        private PlanDeserializerModifier() {
        }

        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig deserializationConfig, BeanDescription beanDescription, JsonDeserializer<?> jsonDeserializer) {
            if (Plan.class.isAssignableFrom(beanDescription.getBeanClass())) {
                return new PlanDeserializer(jsonDeserializer);
            }
            return jsonDeserializer;
        }
    }

    private static class PlanDeserializer
    extends StdDeserializer<Plan>
    implements ResolvableDeserializer {
        private final JsonDeserializer<?> defaultDeserializer;

        PlanDeserializer(JsonDeserializer<?> defaultDeserializer) {
            super(Plan.class);
            this.defaultDeserializer = defaultDeserializer;
        }

        public Plan deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Plan plan = (Plan)this.defaultDeserializer.deserialize(jsonParser, deserializationContext);
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            if (plan.getEntries() != null) {
                for (Plan.Entry entry : plan.getEntries()) {
                    if (entry.getRuns() == null) continue;
                    for (Run run : entry.getRuns()) {
                        run.setCreatedOn(plan.getCreatedOn());
                        run.setCreatedBy(plan.getCreatedBy());
                    }
                }
            }
            return plan;
        }

        public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
            ((ResolvableDeserializer)this.defaultDeserializer).resolve(deserializationContext);
        }
    }
}

