// Generated by delombok at Sun Dec 02 16:36:06 PST 2018
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Kunal Shah
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.codepine.api.testrail.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * TestRail test.
 */
public class Test {
    private static final String CUSTOM_FIELD_KEY_PREFIX = "custom_";
    private int id;
    private int caseId;
    private Integer assignedtoId;
    private String title;
    private int statusId;
    private int typeId;
    private int priorityId;
    private Integer milestoneId;
    private Integer runId;
    private String refs;
    private String estimate;
    private String estimateForecast;
    private Map<String, Object> customFields;

    public Map<String, Object> getCustomFields() {
        return MoreObjects.firstNonNull(customFields, Collections.<String, Object>emptyMap());
    }

    /**
     * Add a custom field.
     *
     * @param key   the name of the custom field with or without "custom_" prefix
     * @param value the value of the custom field
     * @return test instance for chaining
     */
    public Test addCustomField(String key, Object value) {
        if (customFields == null) {
            customFields = new HashMap<>();
        }
        customFields.put(key.replaceFirst(CUSTOM_FIELD_KEY_PREFIX, ""), value);
        return this;
    }

    /**
     * Support for forward compatibility and extracting custom fields.
     *
     * @param key the name of the unknown field
     * @param value the value of the unkown field
     */
    @JsonAnySetter
    private void addUnknownField(String key, Object value) {
        if (key.startsWith(CUSTOM_FIELD_KEY_PREFIX)) {
            addCustomField(key, value);
        }
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test() {
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getId() {
        return this.id;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getCaseId() {
        return this.caseId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getAssignedtoId() {
        return this.assignedtoId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getTitle() {
        return this.title;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getStatusId() {
        return this.statusId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getTypeId() {
        return this.typeId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int getPriorityId() {
        return this.priorityId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMilestoneId() {
        return this.milestoneId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getRunId() {
        return this.runId;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRefs() {
        return this.refs;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getEstimate() {
        return this.estimate;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getEstimateForecast() {
        return this.estimateForecast;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setId(final int id) {
        this.id = id;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setCaseId(final int caseId) {
        this.caseId = caseId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setAssignedtoId(final Integer assignedtoId) {
        this.assignedtoId = assignedtoId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setTitle(final String title) {
        this.title = title;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setStatusId(final int statusId) {
        this.statusId = statusId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setTypeId(final int typeId) {
        this.typeId = typeId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setPriorityId(final int priorityId) {
        this.priorityId = priorityId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setMilestoneId(final Integer milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setRunId(final Integer runId) {
        this.runId = runId;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setRefs(final String refs) {
        this.refs = refs;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setEstimate(final String estimate) {
        this.estimate = estimate;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setEstimateForecast(final String estimateForecast) {
        this.estimateForecast = estimateForecast;
        return this;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Test setCustomFields(final Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    @Override
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof Test)) return false;
        final Test other = (Test)o;
        if (!other.canEqual((Object)this)) return false;
        if (this.getId() != other.getId()) return false;
        if (this.getCaseId() != other.getCaseId()) return false;
        final Object this$assignedtoId = this.getAssignedtoId();
        final Object other$assignedtoId = other.getAssignedtoId();
        if (this$assignedtoId == null ? other$assignedtoId != null : !this$assignedtoId.equals(other$assignedtoId)) return false;
        final Object this$title = this.getTitle();
        final Object other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
        if (this.getStatusId() != other.getStatusId()) return false;
        if (this.getTypeId() != other.getTypeId()) return false;
        if (this.getPriorityId() != other.getPriorityId()) return false;
        final Object this$milestoneId = this.getMilestoneId();
        final Object other$milestoneId = other.getMilestoneId();
        if (this$milestoneId == null ? other$milestoneId != null : !this$milestoneId.equals(other$milestoneId)) return false;
        final Object this$runId = this.getRunId();
        final Object other$runId = other.getRunId();
        if (this$runId == null ? other$runId != null : !this$runId.equals(other$runId)) return false;
        final Object this$refs = this.getRefs();
        final Object other$refs = other.getRefs();
        if (this$refs == null ? other$refs != null : !this$refs.equals(other$refs)) return false;
        final Object this$estimate = this.getEstimate();
        final Object other$estimate = other.getEstimate();
        if (this$estimate == null ? other$estimate != null : !this$estimate.equals(other$estimate)) return false;
        final Object this$estimateForecast = this.getEstimateForecast();
        final Object other$estimateForecast = other.getEstimateForecast();
        if (this$estimateForecast == null ? other$estimateForecast != null : !this$estimateForecast.equals(other$estimateForecast)) return false;
        final Object this$customFields = this.getCustomFields();
        final Object other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !this$customFields.equals(other$customFields)) return false;
        return true;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final Object other) {
        return other instanceof Test;
    }

    @Override
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getId();
        result = result * PRIME + this.getCaseId();
        final Object $assignedtoId = this.getAssignedtoId();
        result = result * PRIME + ($assignedtoId == null ? 0 : $assignedtoId.hashCode());
        final Object $title = this.getTitle();
        result = result * PRIME + ($title == null ? 0 : $title.hashCode());
        result = result * PRIME + this.getStatusId();
        result = result * PRIME + this.getTypeId();
        result = result * PRIME + this.getPriorityId();
        final Object $milestoneId = this.getMilestoneId();
        result = result * PRIME + ($milestoneId == null ? 0 : $milestoneId.hashCode());
        final Object $runId = this.getRunId();
        result = result * PRIME + ($runId == null ? 0 : $runId.hashCode());
        final Object $refs = this.getRefs();
        result = result * PRIME + ($refs == null ? 0 : $refs.hashCode());
        final Object $estimate = this.getEstimate();
        result = result * PRIME + ($estimate == null ? 0 : $estimate.hashCode());
        final Object $estimateForecast = this.getEstimateForecast();
        result = result * PRIME + ($estimateForecast == null ? 0 : $estimateForecast.hashCode());
        final Object $customFields = this.getCustomFields();
        result = result * PRIME + ($customFields == null ? 0 : $customFields.hashCode());
        return result;
    }

    @Override
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String toString() {
        return "Test(id=" + this.getId() + ", caseId=" + this.getCaseId() + ", assignedtoId=" + this.getAssignedtoId() + ", title=" + this.getTitle() + ", statusId=" + this.getStatusId() + ", typeId=" + this.getTypeId() + ", priorityId=" + this.getPriorityId() + ", milestoneId=" + this.getMilestoneId() + ", runId=" + this.getRunId() + ", refs=" + this.getRefs() + ", estimate=" + this.getEstimate() + ", estimateForecast=" + this.getEstimateForecast() + ", customFields=" + this.getCustomFields() + ")";
    }
}