/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.autoconfigure;

import com.codeupsoft.component.redis.client.RedisTemplateClient;
import com.codeupsoft.component.security.filter.SecurityAuthenticationFilter;
import com.codeupsoft.component.security.filter.SecurityControllerFilter;
import com.codeupsoft.component.security.handler.AnonymousAccessHandler;
import com.codeupsoft.component.security.handler.DefaultSecurityJwtHandler;
import com.codeupsoft.component.security.handler.SecurityAccessDeniedHandler;
import com.codeupsoft.component.security.handler.SecurityAuthenticationEntryPoint;
import com.codeupsoft.component.security.handler.SecurityJwtHandler;
import com.codeupsoft.component.security.handler.SecurityLogoutSuccessHandler;
import com.codeupsoft.component.security.properties.ComponentSecurityProperties;
import com.codeupsoft.component.security.properties.SecurityAuthenticateProperties;
import com.codeupsoft.component.security.service.PermissionService;
import com.codeupsoft.component.security.service.SecurityAuthenticateService;
import com.codeupsoft.component.security.service.SecurityAuthenticateUserService;
import com.codeupsoft.component.security.service.impl.RedisSecurityAuthenticateUserService;
import com.codeupsoft.component.security.service.impl.SessionSecurityAuthenticateUserService;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@AutoConfiguration
@EnableConfigurationProperties(value={ComponentSecurityProperties.class, SecurityAuthenticateProperties.class})
@ConditionalOnProperty(prefix="codeupsoft.component.security", name={"auto-configure"}, havingValue="true", matchIfMissing=true)
public class ComponentSecurityAutoConfiguration {
    private final ComponentSecurityProperties componentSecurityProperties;
    private final SecurityAuthenticateProperties securityAuthenticateProperties;
    private final ApplicationContext applicationContext;

    @Bean(value={"ss"})
    public PermissionService permissionService() {
        return new PermissionService(this.componentSecurityProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityJwtHandler.class})
    public SecurityJwtHandler securityJwtHandler() {
        return new DefaultSecurityJwtHandler();
    }

    @Bean
    @ConditionalOnBean(value={RedisTemplateClient.class})
    @ConditionalOnMissingBean(value={SecurityAuthenticateUserService.class})
    @ConditionalOnProperty(prefix="codeupsoft.component.security.authenticate", name={"redis-auto-enabled"}, havingValue="true")
    public SecurityAuthenticateUserService redisSecurityAuthenticateUserService(RedisTemplateClient redisTemplateClient, SecurityJwtHandler securityJwtHandler) {
        return new RedisSecurityAuthenticateUserService(redisTemplateClient, securityJwtHandler, this.securityAuthenticateProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityAuthenticateUserService.class})
    @ConditionalOnProperty(prefix="codeupsoft.component.security.authenticate", name={"redis-auto-enabled"}, havingValue="false", matchIfMissing=true)
    public SecurityAuthenticateUserService sessionSecurityAuthenticateUserService() {
        return new SessionSecurityAuthenticateUserService(this.securityAuthenticateProperties);
    }

    @Bean
    public SecurityAuthenticateService securityAuthenticateService() {
        return new SecurityAuthenticateService(this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={AnonymousAccessHandler.class})
    public AnonymousAccessHandler anonymousAccessHandler(@Qualifier(value="requestMappingHandlerMapping") RequestMappingHandlerMapping requestMappingHandlerMapping, Environment environment) {
        return new AnonymousAccessHandler(requestMappingHandlerMapping, environment);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityAccessDeniedHandler.class})
    public SecurityAccessDeniedHandler securityAccessDeniedHandler() {
        return new SecurityAccessDeniedHandler(this.componentSecurityProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityAuthenticationEntryPoint.class})
    public SecurityAuthenticationEntryPoint securityAuthenticationEntryPoint() {
        return new SecurityAuthenticationEntryPoint(this.componentSecurityProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityLogoutSuccessHandler.class})
    public SecurityLogoutSuccessHandler securityLogoutSuccessHandler(SecurityAuthenticateUserService securityAuthenticateUserService) {
        return new SecurityLogoutSuccessHandler(securityAuthenticateUserService);
    }

    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityControllerFilter.class})
    @ConditionalOnProperty(prefix="codeupsoft.component.security", name={"controller-filter-enabled"}, havingValue="true")
    public FilterRegistrationBean<SecurityControllerFilter> securityControllerFilter(ComponentSecurityProperties componentSecurityProperties, SecurityAuthenticateService securityAuthenticateService, SecurityAuthenticateUserService securityAuthenticateUserService) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new SecurityControllerFilter(componentSecurityProperties, securityAuthenticateService, securityAuthenticateUserService));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName("securityControllerFilter");
        registrationBean.setOrder(-2147483638);
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="codeupsoft.component.security.filter-chain", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity, SecurityAuthenticateUserService authenticateUserService, SecurityAccessDeniedHandler securityAccessDeniedHandler, SecurityAuthenticationEntryPoint securityAuthenticationEntryPoint, SecurityLogoutSuccessHandler securityLogoutSuccessHandler, AnonymousAccessHandler anonymousAccessHandler) {
        ComponentSecurityProperties.FilterChainConfig filterChain = this.componentSecurityProperties.getFilterChain();
        HttpSecurity http = httpSecurity.csrf(csrf -> {
            if (filterChain.isCsrfEnabled()) {
                csrf.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse());
            } else {
                csrf.disable();
            }
        }).sessionManagement(session -> {
            if (authenticateUserService instanceof RedisSecurityAuthenticateUserService) {
                session.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
            } else {
                session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
            }
        }).authorizeHttpRequests(auth -> {
            String[] anonymousPaths;
            String[] whiteList = filterChain.getWhiteList();
            if (whiteList != null && whiteList.length > 0) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(whiteList)).permitAll();
            }
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{this.componentSecurityProperties.getLoginUrl()})).permitAll();
            if (anonymousAccessHandler != null && (anonymousPaths = anonymousAccessHandler.getAnonymousAccessPathArray()).length > 0) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(anonymousPaths)).permitAll();
            }
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated();
        }).exceptionHandling(exception -> exception.accessDeniedHandler((AccessDeniedHandler)securityAccessDeniedHandler).authenticationEntryPoint((AuthenticationEntryPoint)securityAuthenticationEntryPoint)).logout(logout -> logout.logoutUrl(this.componentSecurityProperties.getLogoutUrl()).logoutSuccessHandler((LogoutSuccessHandler)securityLogoutSuccessHandler));
        http.addFilterBefore((Filter)new SecurityAuthenticationFilter(authenticateUserService), UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Generated
    public ComponentSecurityAutoConfiguration(ComponentSecurityProperties componentSecurityProperties, SecurityAuthenticateProperties securityAuthenticateProperties, ApplicationContext applicationContext) {
        this.componentSecurityProperties = componentSecurityProperties;
        this.securityAuthenticateProperties = securityAuthenticateProperties;
        this.applicationContext = applicationContext;
    }
}

