/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.filter;

import com.codeupsoft.component.security.service.SecurityAuthenticateUserService;
import com.codeupsoft.component.security.service.impl.SessionSecurityAuthenticateUserService;
import com.codeupsoft.component.security.service.model.LoginUser;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.OncePerRequestFilter;

public class SecurityAuthenticationFilter
extends OncePerRequestFilter {
    private final SecurityAuthenticateUserService securityAuthenticateUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.securityAuthenticateUserService instanceof SessionSecurityAuthenticateUserService) {
            SessionSecurityAuthenticateUserService.setCurrentRequest(request);
        }
        try {
            LoginUser loginUser = this.securityAuthenticateUserService.getLoginUser(request);
            if (Objects.nonNull(loginUser)) {
                this.securityAuthenticateUserService.verifyUser(loginUser);
                UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)loginUser, null, loginUser.getAuthorities());
                authenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (this.securityAuthenticateUserService instanceof SessionSecurityAuthenticateUserService) {
                SessionSecurityAuthenticateUserService.clearCurrentRequest();
            }
        }
    }

    @Generated
    public SecurityAuthenticationFilter(SecurityAuthenticateUserService securityAuthenticateUserService) {
        this.securityAuthenticateUserService = securityAuthenticateUserService;
    }
}

