/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.handler;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.jwt.JWTPayload;
import cn.hutool.jwt.JWTUtil;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.JWTSignerUtil;
import com.codeupsoft.component.security.handler.SecurityJwtHandler;
import com.codeupsoft.component.security.service.model.LoginUser;
import java.util.Map;
import java.util.Objects;

public class DefaultSecurityJwtHandler
implements SecurityJwtHandler {
    private static final String UID_KEY = "uid";

    @Override
    public String generateToken(LoginUser loginUser, String secret) {
        String uuid = IdUtil.fastSimpleUUID();
        loginUser.setToken(uuid);
        return JWTUtil.createToken(Map.of(UID_KEY, uuid), (JWTSigner)JWTSignerUtil.hs256((byte[])secret.getBytes()));
    }

    @Override
    public boolean validateToken(String token, String secret) {
        try {
            return JWTUtil.verify((String)token, (JWTSigner)JWTSignerUtil.hs256((byte[])secret.getBytes()));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getTokenUid(String token) {
        JWTPayload payload = JWTUtil.parseToken((String)token).getPayload();
        Object uid = payload.getClaim(UID_KEY);
        if (Objects.isNull(uid)) {
            return null;
        }
        return Convert.toStr((Object)uid);
    }
}

