/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test.runner;

import com.codingapi.test.annotation.TestMethod;
import com.codingapi.test.runner.IMongoRunner;
import com.codingapi.test.runner.IRelationalDbRunner;
import com.codingapi.test.runner.ITestClear;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;

public class DefaultTestClear
implements ITestClear {
    private static final Logger log = LoggerFactory.getLogger(DefaultTestClear.class);

    @Override
    public <T> void clean(TestMethod testMethod, TestContext testContext) throws Exception {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        try {
            IRelationalDbRunner mysqlRunner = (IRelationalDbRunner)applicationContext.getBean(IRelationalDbRunner.class);
            if (mysqlRunner != null) {
                mysqlRunner.clear(applicationContext, testMethod);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.warn("no relational clean runner.");
        }
        try {
            IMongoRunner mongoRunner = (IMongoRunner)applicationContext.getBean(IMongoRunner.class);
            if (mongoRunner != null) {
                mongoRunner.clear(applicationContext, testMethod);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.warn("no mongo clean runner.");
        }
    }
}

