/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test.utils;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.test.annotation.XmlBuild;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlUtils {
    public static SqlParam parser(String initCmd, Object object) {
        Map map = (Map)JSONObject.toJSON((Object)object);
        ArrayList params = new ArrayList();
        SqlParam sqlParam = new SqlParam();
        String regex = "\\#\\{([^}]*)\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(initCmd);
        while (matcher.find()) {
            String key = matcher.group(1);
            Object val = map.get(key);
            params.add(val);
            initCmd = initCmd.replace("#{" + key + "}", "?");
        }
        sqlParam.setSql(initCmd);
        sqlParam.setParams(params.toArray());
        return sqlParam;
    }

    public static String createInsertSql(String name, XmlBuild.ColType colType, Class<?> clazz) {
        Field field;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        sb.append(name);
        sb.append("(");
        Field[] fields = clazz.getDeclaredFields();
        int filedLength = fields.length;
        for (i = 0; i < filedLength; ++i) {
            field = fields[i];
            if (i == filedLength - 1) {
                sb.append(SqlUtils.getColumn(field.getName(), colType));
                continue;
            }
            sb.append(SqlUtils.getColumn(field.getName(), colType) + ",");
        }
        sb.append(")");
        sb.append(" values(");
        for (i = 0; i < filedLength; ++i) {
            field = fields[i];
            if (i == filedLength - 1) {
                sb.append("#{" + field.getName() + "}");
                continue;
            }
            sb.append("#{" + field.getName() + "},");
        }
        sb.append(")");
        return sb.toString();
    }

    private static String getColumn(String name, XmlBuild.ColType colType) {
        if (colType.equals((Object)XmlBuild.ColType.UNDERLINE)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        }
        if (colType.equals((Object)XmlBuild.ColType.CAMEL)) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
        return null;
    }

    public static String createClearSql(String name) {
        return "truncate " + name;
    }

    public static class SqlParam {
        String sql;
        Object[] params;

        public String getSql() {
            return this.sql;
        }

        public Object[] getParams() {
            return this.params;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setParams(Object[] params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SqlParam)) {
                return false;
            }
            SqlParam other = (SqlParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            return Arrays.deepEquals(this.getParams(), other.getParams());
        }

        protected boolean canEqual(Object other) {
            return other instanceof SqlParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParams());
            return result;
        }

        public String toString() {
            return "SqlUtils.SqlParam(sql=" + this.getSql() + ", params=" + Arrays.deepToString(this.getParams()) + ")";
        }
    }
}

