/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.api.CDAClient;
import com.contentful.java.lib.Constants;
import com.contentful.java.model.CDAAsset;
import com.contentful.java.model.CDAContentType;
import com.contentful.java.model.CDAEntry;
import com.contentful.java.model.CDAResource;
import com.contentful.java.model.CDASpace;
import com.contentful.java.model.Locale;
import com.contentful.java.model.ResourceWithList;
import com.contentful.java.model.ResourceWithMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class ResourceTypeAdapter
implements JsonDeserializer<CDAResource> {
    private final CDAClient client;

    public ResourceTypeAdapter(CDAClient client) {
        this.client = client;
    }

    public CDAResource deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        CDAResource result = null;
        JsonObject sys = jsonElement.getAsJsonObject().getAsJsonObject("sys");
        if (sys != null) {
            Constants.CDAResourceType resourceType = Constants.CDAResourceType.valueOf(sys.get("type").getAsString());
            result = Constants.CDAResourceType.Asset.equals((Object)resourceType) ? this.deserializeAsset(jsonElement, context, sys) : (Constants.CDAResourceType.Entry.equals((Object)resourceType) ? this.deserializeEntry(jsonElement, context, sys) : (Constants.CDAResourceType.ContentType.equals((Object)resourceType) ? this.deserializeContentType(jsonElement, context, sys) : (Constants.CDAResourceType.Space.equals((Object)resourceType) ? this.deserializeSpace(jsonElement, context, sys) : this.deserializeResource(jsonElement, context, sys))));
        }
        return result;
    }

    private CDAResource deserializeResource(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        CDAResource result = new CDAResource();
        this.setBaseFields(result, sys, jsonElement, context);
        return result;
    }

    private CDAAsset deserializeAsset(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        Object map;
        CDAAsset result = new CDAAsset();
        this.setBaseFields(result, sys, jsonElement, context);
        Map fileMap = (Map)result.getFields().get("file");
        String defaultLocale = this.client.getSpace().getDefaultLocale();
        if (fileMap.containsKey(defaultLocale) && (map = fileMap.get(defaultLocale)) instanceof Map) {
            fileMap = (Map)map;
        }
        result.setUrl(String.format("%s:%s", this.client.getHttpScheme(), fileMap.get("url")));
        result.setMimeType((String)fileMap.get("contentType"));
        return result;
    }

    private CDAContentType deserializeContentType(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        JsonObject attrs = jsonElement.getAsJsonObject();
        String displayField = this.getFieldAsString(attrs, "displayField");
        String name = this.getFieldAsString(attrs, "name");
        String userDescription = this.getFieldAsString(attrs, "description");
        CDAContentType result = new CDAContentType(displayField, name, userDescription);
        this.setBaseFields(result, sys, jsonElement, context);
        return result;
    }

    private CDAEntry deserializeEntry(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        CDAEntry result;
        String contentTypeId = sys.get("contentType").getAsJsonObject().get("sys").getAsJsonObject().get("id").getAsString();
        Class<?> clazz = this.client.getCustomTypesMap().get(contentTypeId);
        if (clazz == null) {
            result = new CDAEntry();
        } else {
            try {
                result = (CDAEntry)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new JsonParseException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
        this.setBaseFields(result, sys, jsonElement, context);
        return result;
    }

    private CDASpace deserializeSpace(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        String name = jsonElement.getAsJsonObject().get("name").getAsString();
        JsonArray localesArray = jsonElement.getAsJsonObject().get("locales").getAsJsonArray();
        Type t = new TypeToken<ArrayList<Locale>>(){}.getType();
        ArrayList locales = (ArrayList)context.deserialize((JsonElement)localesArray, t);
        String defaultLocale = "en-US";
        for (Locale l : locales) {
            if (!l.isDefault) continue;
            defaultLocale = l.code;
            break;
        }
        CDASpace result = new CDASpace(defaultLocale, locales, name);
        this.setBaseFields(result, sys, jsonElement, context);
        return result;
    }

    private void setBaseFields(CDAResource target, JsonObject sys, JsonElement jsonElement, JsonDeserializationContext context) {
        Map sysMap = (Map)context.deserialize((JsonElement)sys, Map.class);
        if (sysMap.containsKey("space")) {
            sysMap.put("space", this.client.getSpace());
        }
        target.setSys(sysMap);
        JsonElement fields = jsonElement.getAsJsonObject().get("fields");
        if (target instanceof ResourceWithMap) {
            ResourceWithMap res = (ResourceWithMap)target;
            target.setLocale(this.client.getSpace().getDefaultLocale());
            res.setRawFields((Map)context.deserialize((JsonElement)fields.getAsJsonObject(), Map.class));
            res.getLocalizedFieldsMap().put(this.client.getSpace().getDefaultLocale(), res.getRawFields());
        } else if (target instanceof ResourceWithList) {
            ResourceWithList res = (ResourceWithList)target;
            res.setFields((List)context.deserialize((JsonElement)fields.getAsJsonArray(), List.class));
        }
    }

    private String getFieldAsString(JsonObject jsonObject, String name) {
        JsonElement value = jsonObject.get(name);
        if (value != null) {
            return value.getAsString();
        }
        return null;
    }
}

