/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.model.CDAArray;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

class Utils {
    static final String SDK_PROPERTIES = "contentful_cda.properties";
    static final String PROP_VERSION_NAME = "version.name";

    private Utils() {
    }

    static String getNextPageType(CDAArray array) {
        String url = Utils.assertArray(array);
        String result = null;
        try {
            URI uri = new URI(url);
            String[] split = uri.getPath().split("/");
            result = split[split.length - 1];
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String assertArray(CDAArray array) {
        String url = array.getOriginalUrl();
        if (url == null) {
            throw new IllegalArgumentException("Invalid array instance! (empty or unsuccessful response)");
        }
        return url;
    }

    static HashMap<String, String> getNextBatchQueryMapForArray(CDAArray array) {
        Utils.assertArray(array);
        int skip = array.getSkip();
        int limit = array.getLimit();
        int nextOffset = skip + limit;
        return Utils.prepareQueryMap(URI.create(array.getOriginalUrl()), nextOffset, limit);
    }

    private static HashMap<String, String> prepareQueryMap(URI uri, int nextOffset, int limit) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            String[] params;
            for (String p : params = query.split("&")) {
                String[] kv = p.split("=");
                if ("skip".equalsIgnoreCase(kv[0]) || "limit".equalsIgnoreCase(kv[0])) continue;
                queryMap.put(kv[0], kv[1]);
            }
        }
        queryMap.put("skip", Integer.toString(nextOffset));
        queryMap.put("limit", Integer.toString(limit));
        return queryMap;
    }

    static String getFromProperties(String field) throws IOException {
        Properties properties = new Properties();
        properties.load(Utils.class.getClassLoader().getResourceAsStream(SDK_PROPERTIES));
        return properties.getProperty(field);
    }

    static String getQueryParamFromUrl(String url, String param) {
        String result = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            for (NameValuePair pair : builder.getQueryParams()) {
                if (!pair.getName().equalsIgnoreCase(param)) continue;
                result = pair.getValue();
                break;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return result;
    }
}

