/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.api.ArrayResourceTypeAdapter;
import com.contentful.java.api.ArrayResponse;
import com.contentful.java.api.CDACallback;
import com.contentful.java.api.CDAService;
import com.contentful.java.api.EnsureSpaceCallback;
import com.contentful.java.api.ResourceTypeAdapter;
import com.contentful.java.api.SpaceMerger;
import com.contentful.java.api.SyncSpaceCallback;
import com.contentful.java.api.Utils;
import com.contentful.java.lib.Constants;
import com.contentful.java.model.CDAArray;
import com.contentful.java.model.CDAAsset;
import com.contentful.java.model.CDAContentType;
import com.contentful.java.model.CDAEntry;
import com.contentful.java.model.CDAResource;
import com.contentful.java.model.CDASpace;
import com.contentful.java.model.CDASyncedSpace;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.Response;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class CDAClient {
    static final String USER_AGENT = String.format("contentful.java/%s", "1.0");
    private String httpScheme;
    private String accessToken;
    private String spaceKey;
    private CDAService service;
    private HashMap<String, Class<?>> customTypesMap;
    private Client.Provider clientProvider;
    private CDASpace space;
    private Gson gson;
    ExecutorService executorService;

    private CDAClient() {
    }

    private void init(Builder builder) {
        this.customTypesMap = new HashMap();
        this.spaceKey = builder.spaceKey;
        this.accessToken = builder.accessToken;
        this.initGson();
        RestAdapter.Builder restBuilder = new RestAdapter.Builder().setConverter((Converter)new GsonConverter(this.gson)).setRequestInterceptor(this.getRequestInterceptor());
        if (builder.dontUseSSL) {
            restBuilder.setEndpoint(Constants.CDA_SERVER_URI_NOSSL);
            this.httpScheme = "http";
        } else {
            restBuilder.setEndpoint(Constants.CDA_SERVER_URI);
            this.httpScheme = "https";
        }
        if (builder.clientProvider != null) {
            restBuilder.setClient(builder.clientProvider);
        }
        if (builder.errorHandler != null) {
            restBuilder.setErrorHandler(builder.errorHandler);
        }
        this.service = (CDAService)restBuilder.build().create(CDAService.class);
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable r) {
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setPriority(1);
                        r.run();
                    }
                }, "Contentful-Idle");
            }
        });
    }

    private void initGson() {
        Gson arrayGson = CDAClient.setBaseTypeAdapters(new GsonBuilder(), this).create();
        this.gson = CDAClient.setBaseTypeAdapters(new GsonBuilder(), this).registerTypeAdapter(CDAArray.class, (Object)new ArrayResourceTypeAdapter(this, arrayGson)).registerTypeAdapter(CDASyncedSpace.class, (Object)new ArrayResourceTypeAdapter(this, arrayGson)).create();
    }

    static GsonBuilder setBaseTypeAdapters(GsonBuilder gsonBuilder, CDAClient client) {
        ResourceTypeAdapter rta = new ResourceTypeAdapter(client);
        return gsonBuilder.registerTypeAdapter(CDAResource.class, (Object)rta).registerTypeAdapter(CDAEntry.class, (Object)rta).registerTypeAdapter(CDAAsset.class, (Object)rta).registerTypeAdapter(CDAContentType.class, (Object)rta).registerTypeAdapter(CDASpace.class, (Object)rta);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                if (CDAClient.this.accessToken != null && !CDAClient.this.accessToken.isEmpty()) {
                    requestFacade.addHeader("Authorization", String.format("Bearer %s", CDAClient.this.accessToken));
                }
                requestFacade.addHeader("User-Agent", USER_AGENT);
            }
        };
    }

    public void registerCustomClass(String contentTypeIdentifier, Class<? extends CDAEntry> clazz) {
        this.customTypesMap.put(contentTypeIdentifier, clazz);
    }

    HashMap<String, Class<?>> getCustomTypesMap() {
        return this.customTypesMap;
    }

    public void fetchArrayNextPage(CDAArray array, CDACallback<CDAArray> callback) {
        if (array == null) {
            throw new IllegalArgumentException("Array may not be empty.");
        }
        String nextPageType = Utils.getNextPageType(array);
        HashMap<String, String> query = Utils.getNextBatchQueryMapForArray(array);
        this.fetchArrayWithType(nextPageType, query, callback);
    }

    public CDAArray fetchArrayNextPageBlocking(CDAArray array) throws Exception {
        if (array == null) {
            throw new IllegalArgumentException("Array may not be empty.");
        }
        String nextPageType = Utils.getNextPageType(array);
        HashMap<String, String> query = Utils.getNextBatchQueryMapForArray(array);
        return this.fetchArrayWithTypeBlocking(nextPageType, query);
    }

    public void fetchAssets(CDACallback<CDAArray> callback) {
        this.fetchArrayWithType("assets", null, callback);
    }

    public CDAArray fetchAssetsBlocking() throws Exception {
        return this.fetchArrayWithTypeBlocking("assets", null);
    }

    public void fetchAssetsMatching(Map<String, String> query, CDACallback<CDAArray> callback) {
        this.fetchArrayWithType("assets", query, callback);
    }

    public CDAArray fetchAssetsMatchingBlocking(Map<String, String> query) throws Exception {
        return this.fetchArrayWithTypeBlocking("assets", query);
    }

    public void fetchAssetWithIdentifier(final String identifier, final CDACallback<CDAAsset> callback) {
        this.ensureSpace(new EnsureSpaceCallback(this, callback){

            @Override
            void onSpaceReady() {
                CDAClient.this.service.fetchAssetWithIdentifier(CDAClient.this.spaceKey, identifier, callback);
            }
        });
    }

    public CDAAsset fetchAssetWithIdentifierBlocking(String identifier) throws Exception {
        this.ensureSpaceBlocking(false);
        return this.service.fetchAssetWithIdentifierBlocking(this.spaceKey, identifier);
    }

    public void fetchContentTypes(final CDACallback<CDAArray> callback) {
        this.ensureSpace(new EnsureSpaceCallback(this, callback){

            @Override
            void onSpaceReady() {
                CDAClient.this.service.fetchContentTypes(CDAClient.this.spaceKey, callback);
            }
        });
    }

    public CDAArray fetchContentTypesBlocking() throws Exception {
        this.ensureSpaceBlocking(false);
        return this.service.fetchContentTypesBlocking(this.spaceKey);
    }

    public void fetchContentTypeWithIdentifier(final String identifier, final CDACallback<CDAContentType> callback) {
        this.ensureSpace(new EnsureSpaceCallback(this, callback){

            @Override
            void onSpaceReady() {
                CDAClient.this.service.fetchContentTypeWithIdentifier(CDAClient.this.spaceKey, identifier, callback);
            }
        });
    }

    public CDAContentType fetchContentTypeWithIdentifierBlocking(String identifier) throws Exception {
        this.ensureSpaceBlocking(false);
        return this.service.fetchContentTypeWithIdentifierBlocking(this.spaceKey, identifier);
    }

    public void fetchEntries(CDACallback<CDAArray> callback) {
        this.fetchArrayWithType("entries", null, callback);
    }

    public CDAArray fetchEntriesBlocking() throws Exception {
        return this.fetchArrayWithTypeBlocking("entries", null);
    }

    public void fetchEntriesMatching(Map<String, String> query, CDACallback<CDAArray> callback) {
        this.fetchArrayWithType("entries", query, callback);
    }

    public CDAArray fetchEntriesMatchingBlocking(Map<String, String> query) throws Exception {
        return this.fetchArrayWithTypeBlocking("entries", query);
    }

    public void fetchEntryWithIdentifier(final String identifier, final CDACallback<? extends CDAEntry> callback) {
        this.ensureSpace(new EnsureSpaceCallback(this, callback){

            @Override
            void onSpaceReady() {
                CDAClient.this.service.fetchEntryWithIdentifier(CDAClient.this.spaceKey, identifier, callback);
            }
        });
    }

    public CDAEntry fetchEntryWithIdentifierBlocking(String identifier) throws Exception {
        this.ensureSpaceBlocking(false);
        return this.service.fetchEntryWithIdentifierBlocking(this.spaceKey, identifier);
    }

    public void fetchResourcesOfType(Constants.CDAResourceType resourceType, CDACallback<CDAArray> callback) {
        if (Constants.CDAResourceType.Asset.equals((Object)resourceType)) {
            this.fetchAssets(callback);
        } else if (Constants.CDAResourceType.ContentType.equals((Object)resourceType)) {
            this.fetchContentTypes(callback);
        } else if (Constants.CDAResourceType.Entry.equals((Object)resourceType)) {
            this.fetchEntries(callback);
        } else {
            throw new IllegalArgumentException("Invalid resource type, allowed types are: Asset, ContentType, Entry.");
        }
    }

    public void fetchResourcesOfTypeMatching(Constants.CDAResourceType resourceType, Map<String, String> query, CDACallback<CDAArray> callback) {
        if (Constants.CDAResourceType.Asset.equals((Object)resourceType)) {
            this.fetchAssetsMatching(query, callback);
        } else if (Constants.CDAResourceType.Entry.equals((Object)resourceType)) {
            this.fetchEntriesMatching(query, callback);
        } else {
            throw new IllegalArgumentException("Invalid resource type, allowed types are: Asset, Entry.");
        }
    }

    public void fetchSpace(CDACallback<CDASpace> callback) {
        this.service.fetchSpace(this.spaceKey, callback);
    }

    public CDASpace fetchSpaceBlocking() throws Exception {
        return this.service.fetchSpaceBlocking(this.spaceKey);
    }

    public void performInitialSynchronization(final CDACallback<CDASyncedSpace> callback) {
        this.ensureSpace(true, new EnsureSpaceCallback(this, callback){

            @Override
            void onSpaceReady() {
                CDAClient.this.service.performSynchronization(CDAClient.this.spaceKey, true, null, new SyncSpaceCallback(null, CDAClient.this, callback));
            }
        });
    }

    public CDASyncedSpace performInitialSynchronizationBlocking() throws Exception {
        this.ensureSpaceBlocking(true);
        CDASyncedSpace result = this.service.performSynchronizationBlocking(this.spaceKey, true, null);
        return new SpaceMerger(null, result, null, null, this.getSpace()).call();
    }

    public void performSynchronization(final CDASyncedSpace existingSpace, final CDACallback<CDASyncedSpace> callback) {
        if (existingSpace == null) {
            throw new IllegalArgumentException("Existing space may not be null.");
        }
        this.ensureSpace(true, new EnsureSpaceCallback(this, callback){

            @Override
            void onSpaceReady() {
                CDAClient.this.service.fetchSyncedSpaceWithPath(existingSpace.getNextSyncUrl(), new SyncSpaceCallback(existingSpace, CDAClient.this, callback));
            }
        });
    }

    public CDASyncedSpace performSynchronizationBlocking(CDASyncedSpace existingSpace) throws Exception {
        if (existingSpace == null) {
            throw new IllegalArgumentException("Existing space may not be null.");
        }
        this.ensureSpaceBlocking(true);
        CDASyncedSpace result = this.service.performSynchronizationBlocking(this.spaceKey, false, null);
        return new SpaceMerger(existingSpace, result, null, null, this.getSpace()).call();
    }

    public void performSynchronization(final String syncToken, final CDACallback<CDASyncedSpace> callback) {
        if (syncToken == null) {
            throw new IllegalArgumentException("Sync token may not be null.");
        }
        this.ensureSpace(true, new EnsureSpaceCallback(this, callback){

            @Override
            void onSpaceReady() {
                CDAClient.this.service.performSynchronization(CDAClient.this.spaceKey, null, syncToken, new SyncSpaceCallback(null, CDAClient.this, callback));
            }
        });
    }

    public CDASyncedSpace performSynchronization(String syncToken) throws Exception {
        if (syncToken == null) {
            throw new IllegalArgumentException("Sync token may not be null.");
        }
        this.ensureSpaceBlocking(true);
        CDASyncedSpace result = this.service.performSynchronizationBlocking(this.spaceKey, null, syncToken);
        return new SpaceMerger(null, result, null, null, this.getSpace()).call();
    }

    public CDASpace getSpace() {
        return this.space;
    }

    void onSpaceReady(CDASpace space) {
        if (space != null && this.space != space) {
            this.space = space;
        }
    }

    public String getHttpScheme() {
        return this.httpScheme;
    }

    private void ensureSpace(EnsureSpaceCallback callback) {
        this.ensureSpace(false, callback);
    }

    private void ensureSpace(boolean invalidate, EnsureSpaceCallback callback) {
        if (invalidate || this.space == null) {
            this.fetchSpace(callback);
        } else {
            callback.onSuccess(this.space, (Response)null);
        }
    }

    private void ensureSpaceBlocking(boolean invalidate) throws Exception {
        if (invalidate || this.space == null) {
            this.space = this.fetchSpaceBlocking();
        }
    }

    private void fetchArrayWithType(final String type, final Map<String, String> query, final CDACallback<CDAArray> callback) {
        this.ensureSpace(new EnsureSpaceCallback(this, callback){

            @Override
            void onSpaceReady() {
                CDAClient.this.service.fetchArrayWithType(CDAClient.this.spaceKey, type, query, new ArrayResponse(callback));
            }
        });
    }

    private CDAArray fetchArrayWithTypeBlocking(String type, Map<String, String> query) throws Exception {
        this.ensureSpaceBlocking(false);
        Response response = this.service.fetchArrayWithTypeBlocking(this.spaceKey, type, query);
        CDAArray result = (CDAArray)this.gson.fromJson((Reader)new InputStreamReader(response.getBody().in()), CDAArray.class);
        ArrayResponse.prepareResponse(result, response);
        return result;
    }

    public static class Builder {
        private String spaceKey;
        private String accessToken;
        private Client.Provider clientProvider;
        private ErrorHandler errorHandler;
        private boolean dontUseSSL = false;

        public Builder setSpaceKey(String spaceKey) {
            if (spaceKey == null) {
                throw new NullPointerException("Space key may not be null.");
            }
            this.spaceKey = spaceKey;
            return this;
        }

        public Builder setAccessToken(String accessToken) {
            if (accessToken == null) {
                throw new NullPointerException("Access token may not be null.");
            }
            this.accessToken = accessToken;
            return this;
        }

        public Builder setClient(final Client client) {
            if (client == null) {
                throw new NullPointerException("Client may not be null.");
            }
            return this.setClient(new Client.Provider(){

                public Client get() {
                    return client;
                }
            });
        }

        public Builder setClient(Client.Provider clientProvider) {
            if (clientProvider == null) {
                throw new NullPointerException("Client provider may not be null.");
            }
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder setErrorHandler(ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new NullPointerException("Error handler may not be null.");
            }
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder noSSL() {
            this.dontUseSSL = true;
            return this;
        }

        public CDAClient build() {
            CDAClient client = new CDAClient();
            client.init(this);
            return client;
        }
    }
}

