/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.api;

import com.contentful.java.api.ArrayResponse;
import com.contentful.java.api.CDACallback;
import com.contentful.java.api.SyncSpaceCallback;
import com.contentful.java.model.CDAArray;
import com.contentful.java.model.CDAAsset;
import com.contentful.java.model.CDAContentType;
import com.contentful.java.model.CDAEntry;
import com.contentful.java.model.CDASpace;
import com.contentful.java.model.CDASyncedSpace;
import java.util.Map;
import retrofit.client.Response;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.QueryMap;

interface CDAService {
    @GET(value="/spaces/{space}/{type}")
    public void fetchArrayWithType(@Path(value="space") String var1, @Path(value="type") String var2, @QueryMap Map<String, String> var3, ArrayResponse var4);

    @GET(value="/spaces/{space}/{type}")
    public Response fetchArrayWithTypeBlocking(@Path(value="space") String var1, @Path(value="type") String var2, @QueryMap Map<String, String> var3);

    @GET(value="/spaces/{space}/assets/{identifier}")
    public void fetchAssetWithIdentifier(@Path(value="space") String var1, @Path(value="identifier") String var2, CDACallback<CDAAsset> var3);

    @GET(value="/spaces/{space}/assets/{identifier}")
    public CDAAsset fetchAssetWithIdentifierBlocking(@Path(value="space") String var1, @Path(value="identifier") String var2);

    @GET(value="/spaces/{space}/content_types")
    public void fetchContentTypes(@Path(value="space") String var1, CDACallback<CDAArray> var2);

    @GET(value="/spaces/{space}/content_types")
    public CDAArray fetchContentTypesBlocking(@Path(value="space") String var1);

    @GET(value="/spaces/{space}/content_types/{identifier}")
    public void fetchContentTypeWithIdentifier(@Path(value="space") String var1, @Path(value="identifier") String var2, CDACallback<CDAContentType> var3);

    @GET(value="/spaces/{space}/content_types/{identifier}")
    public CDAContentType fetchContentTypeWithIdentifierBlocking(@Path(value="space") String var1, @Path(value="identifier") String var2);

    @GET(value="/spaces/{space}/entries/{identifier}")
    public void fetchEntryWithIdentifier(@Path(value="space") String var1, @Path(value="identifier") String var2, CDACallback<? extends CDAEntry> var3);

    @GET(value="/spaces/{space}/entries/{identifier}")
    public CDAEntry fetchEntryWithIdentifierBlocking(@Path(value="space") String var1, @Path(value="identifier") String var2);

    @GET(value="/spaces/{space}")
    public void fetchSpace(@Path(value="space") String var1, CDACallback<CDASpace> var2);

    @GET(value="/spaces/{space}")
    public CDASpace fetchSpaceBlocking(@Path(value="space") String var1);

    @GET(value="/spaces/{space}/sync")
    public void performSynchronization(@Path(value="space") String var1, @Query(value="initial") Boolean var2, @Query(value="sync_token") String var3, SyncSpaceCallback var4);

    @GET(value="/spaces/{space}/sync")
    public CDASyncedSpace performSynchronizationBlocking(@Path(value="space") String var1, @Query(value="initial") Boolean var2, @Query(value="sync_token") String var3);

    @GET(value="/{path}")
    public void fetchSyncedSpaceWithPath(@Path(value="path") String var1, SyncSpaceCallback var2);
}

