/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.QueryOperation;
import com.contentful.java.cda.Util;
import java.util.HashMap;
import java.util.Map;

public abstract class AbsQuery<Resource, Query extends AbsQuery<Resource, Query>> {
    private static final String PARAMETER_CONTENT_TYPE = "content_type";
    private static final String PARAMETER_LOCALE = "locale";
    private static final String PARAMETER_SELECT = "select";
    private static final String PARAMETER_ORDER = "order";
    private static final String PARAMETER_LIMIT = "limit";
    private static final String PARAMETER_SKIP = "skip";
    private static final String PARAMETER_INCLUDE = "include";
    private static final String PARAMETER_LINKS_TO_ENTRY = "links_to_entry";
    private static final String PARAMETER_LINKS_TO_ASSET = "links_to_asset";
    private static final int MAX_LIMIT = 1000;
    final Class<Resource> type;
    final CDAClient client;
    final Map<String, String> params = new HashMap<String, String>();

    AbsQuery(Class<Resource> type, CDAClient client) {
        this.type = type;
        this.client = client;
    }

    public Query withContentType(String contentType) {
        Util.checkNotEmpty(contentType, "ContentType must not be empty.", new Object[0]);
        if (this.hasContentTypeSet()) {
            throw new IllegalStateException(String.format("ContentType \"%s\" is already present in query.", contentType));
        }
        this.params.put(PARAMETER_CONTENT_TYPE, contentType);
        return (Query)this;
    }

    public Query withLocale(String locale) {
        Util.checkNotNull(locale, "Locale must not be null.", new Object[0]);
        if (this.params.get(PARAMETER_LOCALE) != null) {
            throw new IllegalStateException(String.format("Locale \"%s\" is already present in query.", this.params.get(PARAMETER_LOCALE)));
        }
        this.params.put(PARAMETER_LOCALE, locale);
        return (Query)this;
    }

    public Query select(String selection) {
        Util.checkNotEmpty(selection, "Selection must not be empty.", new Object[0]);
        if (this.countDots(selection) >= 2) {
            throw new IllegalArgumentException("Cannot request children of fields. ('fields.author'(\u2714) vs. 'fields.author.name'(\u2716))");
        }
        if (selection.startsWith("fields.") && !this.hasContentTypeSet()) {
            throw new IllegalStateException("Cannot use field selection without specifying a content type first. Use '.withContentType(\"{typeid}\")' first.");
        }
        if (selection.startsWith("sys.") || "sys".equals(selection)) {
            if (!this.params.containsKey(PARAMETER_SELECT)) {
                this.params.put(PARAMETER_SELECT, "sys");
            }
        } else if (this.params.containsKey(PARAMETER_SELECT)) {
            this.params.put(PARAMETER_SELECT, this.params.get(PARAMETER_SELECT) + "," + selection);
        } else {
            this.params.put(PARAMETER_SELECT, "sys," + selection);
        }
        return (Query)this;
    }

    public Query linksToEntryId(String entryId) {
        Util.checkNotEmpty(entryId, "entryId must not be empty.", new Object[0]);
        this.params.put(PARAMETER_LINKS_TO_ENTRY, entryId);
        return (Query)this;
    }

    public Query linksToAssetId(String assetId) {
        Util.checkNotEmpty(assetId, "assetId must not be empty.", new Object[0]);
        this.params.put(PARAMETER_LINKS_TO_ASSET, assetId);
        return (Query)this;
    }

    public Query select(String ... selections) {
        Util.checkNotNull(selections, "Selections cannot be null. Please specify at least one.", new Object[0]);
        if (selections.length == 0) {
            throw new IllegalArgumentException("Please provide a selection to be selected.");
        }
        for (int i = 0; i < selections.length; ++i) {
            try {
                this.select(selections[i]);
                continue;
            }
            catch (IllegalStateException stateException) {
                throw new IllegalStateException(stateException);
            }
            catch (IllegalArgumentException argumentException) {
                throw new IllegalArgumentException(String.format("Could not select %d. field (\"%s\").", i, selections[i]), argumentException);
            }
        }
        return (Query)this;
    }

    public <T> Query where(String name, QueryOperation<T> queryOperation, T ... values) {
        Util.checkNotEmpty(name, "Name cannot be empty/null, please specify a name to apply operations on.", new Object[0]);
        Util.checkNotNull(queryOperation, "QueryOperation cannot be null.", new Object[0]);
        Util.checkNotNull(values, "Values to be compared with need to be set to something.", new Object[0]);
        if (values.length == 0 && !queryOperation.hasDefaultValue()) {
            throw new IllegalArgumentException("Please specify at least one value to be searched for.");
        }
        for (int i = 0; i < values.length; ++i) {
            T value = values[i];
            Util.checkNotNull(value, "Value at position %d must not be null.", i);
            if (!(value instanceof CharSequence)) continue;
            Util.checkNotEmpty(value.toString(), "Value at position %d must not be empty.", i);
        }
        if (!(name.startsWith("sys.") || name.startsWith("fields.") || CDAContentType.class.isAssignableFrom(this.type))) {
            throw new IllegalArgumentException("Please specify either a \"sys.\" or a \"fields.\" attribute to be searched for. (Remember to specify a ContentType for \"fields.\" searches when querying entries.)");
        }
        if (name.startsWith("fields.") && !this.hasContentTypeSet()) {
            throw new IllegalStateException("Cannot request fields of an entry without having a content type set first.");
        }
        if (values.length == 0) {
            this.params.put(name + queryOperation.operator, queryOperation.defaultValue.toString());
        } else {
            this.params.put(name + queryOperation.operator, this.join(values));
        }
        return (Query)this;
    }

    public Query where(String key, String value) {
        this.params.put(key, value);
        return (Query)this;
    }

    public Query orderBy(String key) {
        Util.checkNotEmpty(key, "Key to order by must not be empty.", new Object[0]);
        if (key.startsWith("fields.") && !this.hasContentTypeSet()) {
            throw new IllegalStateException("\"fields.\" cannot be used without setting a content type first.");
        }
        this.params.put(PARAMETER_ORDER, key);
        return (Query)this;
    }

    public Query orderBy(String ... keys) {
        Util.checkNotNull(keys, "Keys should not be null.", new Object[0]);
        if (keys.length == 0) {
            throw new IllegalArgumentException("Cannot have an empty keys array.");
        }
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Util.checkNotEmpty(key, "Key at %d to order by must not be empty.", i);
            if (!key.startsWith("fields.") || this.hasContentTypeSet()) continue;
            throw new IllegalStateException(String.format("Key at %d uses \"fields.\" but cannot be used without setting a content type first.", i));
        }
        this.params.put(PARAMETER_ORDER, this.join(keys));
        return (Query)this;
    }

    public Query reverseOrderBy(String key) {
        Util.checkNotEmpty(key, "Key to order by must not be empty", new Object[0]);
        if (key.startsWith("fields.") && !this.hasContentTypeSet()) {
            throw new IllegalStateException("\"fields.\" cannot be used without setting a content type first.");
        }
        this.params.put(PARAMETER_ORDER, "-" + key);
        return (Query)this;
    }

    public Query limit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException(String.format("Limit of %d is negative.", limit));
        }
        if (limit > 1000) {
            throw new IllegalArgumentException(String.format("Limit of %d is greater than %d.", limit, 1000));
        }
        this.params.put(PARAMETER_LIMIT, Integer.toString(limit));
        return (Query)this;
    }

    public Query skip(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException(String.format("Limit of %d is negative.", skip));
        }
        this.params.put(PARAMETER_SKIP, Integer.toString(skip));
        return (Query)this;
    }

    public Query include(int level) {
        if (level < 0) {
            throw new IllegalArgumentException(String.format("Include level of %d is negative.", level));
        }
        if (level > 10) {
            throw new IllegalArgumentException(String.format("Include level of %d is to high.", level));
        }
        this.params.put(PARAMETER_INCLUDE, Integer.toString(level));
        return (Query)this;
    }

    Query where(Map<String, String> params) {
        this.params.clear();
        this.params.putAll(params);
        return (Query)this;
    }

    String path() {
        return Util.resourcePath(this.type);
    }

    private boolean hasContentTypeSet() {
        if (CDAAsset.class.isAssignableFrom(this.type)) {
            return true;
        }
        return this.params.containsKey(PARAMETER_CONTENT_TYPE);
    }

    private <T> String join(T[] values) {
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (T value : values) {
            builder.append(separator);
            separator = ",";
            builder.append(value);
        }
        return builder.toString();
    }

    private int countDots(String text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }
}

