/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public abstract class LocalizedResource
extends CDAResource {
    private static final long serialVersionUID = 5713028146014748949L;
    @JsonIgnore
    String defaultLocale;
    @JsonIgnore
    Map<String, String> fallbackLocaleMap;
    @JsonProperty(defaultValue="{}")
    Map<String, Object> fields = new HashMap<String, Object>();
    @JsonIgnore
    Map<String, Object> rawFields;

    public Localizer localize(String locale) {
        return new Localizer(locale);
    }

    public <T> T getField(String key) {
        return this.localize(this.defaultLocale).getField(key);
    }

    public <T> T getField(String locale, String key) {
        return this.localize(locale).getField(key);
    }

    public void setField(String locale, String key, Object value) {
        ((Map)this.fields.get(key)).put(locale, value);
    }

    public Map<String, Object> rawFields() {
        return this.rawFields;
    }

    public class Localizer {
        private final String locale;

        Localizer(String locale) {
            this.locale = locale;
        }

        public <T> T getField(String key) {
            Map value = (Map)LocalizedResource.this.fields.get(key);
            if (value == null) {
                return null;
            }
            return this.getFieldForFallbackLocale(value, this.locale);
        }

        <T> T getFieldForFallbackLocale(Map<String, T> value, String locale) {
            if (locale == null) {
                return null;
            }
            T localized = value.get(locale);
            if (localized != null) {
                return localized;
            }
            return this.getFieldForFallbackLocale(value, LocalizedResource.this.fallbackLocaleMap.get(locale));
        }
    }
}

