/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.SynchronizedSpace;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;

public class NestedTypeDeserializer
extends AsPropertyTypeDeserializer {
    public NestedTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    public NestedTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl, JsonTypeInfo.As inclusion) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl, inclusion);
    }

    public NestedTypeDeserializer(AsPropertyTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    public TypeDeserializer forProperty(BeanProperty prop) {
        return this;
    }

    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode originalNode;
        JsonNode node = originalNode = (JsonNode)p.readValueAsTree();
        if (originalNode == null || originalNode.isNull() || originalNode.isEmpty()) {
            return null;
        }
        for (String property : this._typePropertyName.split("\\.")) {
            JsonNode nestedProp = node.get(property);
            if (nestedProp == null) {
                ctxt.reportWrongTokenException(p, JsonToken.FIELD_NAME, "missing property '" + this._typePropertyName + "' that is to contain type id  (for class " + this.baseTypeName() + ")", new Object[0]);
                return null;
            }
            node = nestedProp;
        }
        String type = node.asText();
        if (type == null || type.length() == 0) {
            type = this._baseType.getTypeName();
        }
        if (this._baseType.isTypeOrSubTypeOf(SynchronizedSpace.class)) {
            type = "SynchronizedSpace";
        }
        JsonDeserializer deser = this._findDeserializer(ctxt, type);
        TreeTraversingParser jsonParser = new TreeTraversingParser(originalNode, p.getCodec());
        if (jsonParser.getCurrentToken() == null) {
            jsonParser.nextToken();
        }
        return deser.deserialize((JsonParser)jsonParser, ctxt);
    }
}

