/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAError;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.ResourceDeserializer;
import com.contentful.java.cda.ResourceUtils;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.rich.RichTextFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.mrbean.MrBeanModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import retrofit2.Response;

final class ResourceFactory {
    static final Gson GSON = ResourceFactory.createGson();
    static final ObjectMapper OBJECT_MAPPER = ResourceFactory.createObjectMapper();

    private ResourceFactory() {
        throw new AssertionError();
    }

    static CDAArray array(Response<CDAArray> arrayResponse, CDAClient client) {
        CDAArray array = (CDAArray)arrayResponse.body();
        array.assets = new LinkedHashMap();
        array.entries = new LinkedHashMap();
        Set<CDAResource> resources = ResourceFactory.collectResources(array);
        ResourceUtils.localizeResources(resources, client.cache);
        ResourceUtils.mapResources(resources, array.assets, array.entries);
        ResourceUtils.setRawFields(array);
        RichTextFactory.resolveRichTextField(array, client);
        ResourceUtils.resolveLinks(array, client);
        return array;
    }

    private static Set<CDAResource> collectResources(CDAArray array) {
        LinkedHashSet<CDAResource> resources = new LinkedHashSet<CDAResource>(array.items());
        if (array.includes != null) {
            if (array.includes.assets != null) {
                resources.addAll(array.includes.assets);
            }
            if (array.includes.entries != null) {
                resources.addAll(array.includes.entries);
            }
        }
        return resources;
    }

    static SynchronizedSpace sync(Response<SynchronizedSpace> newSpace, SynchronizedSpace oldSpace, CDAClient client) {
        HashMap<String, CDAAsset> assets = new HashMap<String, CDAAsset>();
        HashMap<String, CDAEntry> entries = new HashMap<String, CDAEntry>();
        if (oldSpace != null) {
            ResourceUtils.mapResources(oldSpace.items(), assets, entries);
        }
        SynchronizedSpace result = ResourceUtils.iterate(newSpace, client);
        ResourceUtils.mapResources(result.items(), assets, entries);
        ResourceUtils.mapDeletedResources(result);
        ArrayList items = new ArrayList();
        items.addAll(assets.values());
        items.addAll(entries.values());
        result.items = items;
        result.assets = assets;
        result.entries = entries;
        ResourceUtils.setRawFields(result);
        RichTextFactory.resolveRichTextField(result, client);
        ResourceUtils.resolveLinks(result, client);
        return result;
    }

    static <T extends CDAResource> T fromResponse(Response<T> response) {
        return (T)((CDAResource)response.body());
    }

    static CDAError errorFromResponse(Response response) {
        try {
            if (response.errorBody() != null) {
                return (CDAError)OBJECT_MAPPER.readValue(response.errorBody().byteStream(), CDAError.class);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CDAError();
    }

    static <T extends CDAResource> List<T> fromArrayToItems(CDAArray array) {
        ArrayList<CDAResource> result = new ArrayList<CDAResource>(array.items.size());
        for (CDAResource resource : array.items) {
            result.add(resource);
        }
        return result;
    }

    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(CDAResource.class, (Object)new ResourceDeserializer()).create();
    }

    private static ObjectMapper createObjectMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new ParameterNamesModule())).addModule((Module)new Jdk8Module())).addModule((Module)new JavaTimeModule())).addModule((Module)new MrBeanModule())).findAndAddModules()).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT})).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES})).build();
    }
}

