/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

public class QueryOperation<T> {
    public static final QueryOperation<String> IsEqualTo = new QueryOperation("");
    public static final QueryOperation<String> IsNotEqualTo = new QueryOperation("[ne]");
    public static final QueryOperation<String> HasOneOf = new QueryOperation("[in]");
    public static final QueryOperation<String> HasNoneOf = new QueryOperation("[nin]");
    public static final QueryOperation<String> HasAllOf = new QueryOperation("[all]");
    public static final QueryOperation<Integer> IsLessThan = new QueryOperation("[lt]");
    public static final QueryOperation<Integer> IsLessThanOrEqualTo = new QueryOperation("[lte]");
    public static final QueryOperation<Integer> IsGreaterThan = new QueryOperation("[gt]");
    public static final QueryOperation<Integer> IsGreaterThanOrEqualTo = new QueryOperation("[gte]");
    public static final QueryOperation<Boolean> Exists = new QueryOperation<Boolean>("[exists]", true);
    public static final QueryOperation<String> IsEarlierThan = new QueryOperation("[lt]");
    public static final QueryOperation<String> IsEarlierOrAt = new QueryOperation("[lte]");
    public static final QueryOperation<String> IsLaterThan = new QueryOperation("[gt]");
    public static final QueryOperation<String> IsLaterOrAt = new QueryOperation("[gte]");
    public static final QueryOperation<String> Matches = new QueryOperation("[match]");
    public static final QueryOperation<Location> IsCloseTo = new QueryOperation("[near]");
    public static final QueryOperation<BoundingBox> IsWithinBoundingBoxOf = new QueryOperation("[within]");
    public static final QueryOperation<BoundingCircle> IsWithinCircleOf = new QueryOperation("[within]");
    final String operator;
    final T defaultValue;

    protected QueryOperation(String operator) {
        this(operator, null);
    }

    protected QueryOperation(String operator, T defaultValue) {
        this.operator = operator;
        this.defaultValue = defaultValue;
    }

    protected boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public static class BoundingCircle {
        private final Location center;
        private final double radius;

        public BoundingCircle(Location center, double radius) {
            this.center = center;
            this.radius = radius;
        }

        public BoundingCircle(double centerLatitude, double centerLongitude, double radius) {
            this.center = new Location(centerLatitude, centerLongitude);
            this.radius = radius;
        }

        public String toString() {
            return String.format("%s,%f", this.center.toString(), this.radius);
        }
    }

    public static class BoundingBox {
        private final Location bottomLeft;
        private final Location topRight;

        public BoundingBox(Location bottomLeft, Location topRight) {
            this.bottomLeft = bottomLeft;
            this.topRight = topRight;
        }

        public BoundingBox(double bottom, double left, double top, double right) {
            this.bottomLeft = new Location(bottom, left);
            this.topRight = new Location(top, right);
        }

        public String toString() {
            return String.format("%s,%s", this.bottomLeft.toString(), this.topRight.toString());
        }
    }

    public static class Location {
        private final double latitude;
        private final double longitude;

        public Location(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public String toString() {
            return String.format("%f,%f", this.latitude, this.longitude);
        }
    }
}

