/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.ClientContext;
import com.contentful.java.cda.model.CDASpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbsModule<A extends Async, R extends Rx> {
    final ClientContext context;
    final A extAsync;
    final R extRxJava;

    AbsModule(ClientContext context) {
        this.context = context;
        this.extAsync = this.createAsyncExtension();
        this.extRxJava = this.createRxJavaExtension();
    }

    abstract A createAsyncExtension();

    abstract R createRxJavaExtension();

    public abstract A async();

    public abstract R rx();

    void ensureSpace() {
        this.ensureSpace(false);
    }

    void ensureSpace(boolean invalidate) {
        if (invalidate || this.context.spaceWrapper.get() == null) {
            CDASpace space = this.context.service.fetchSpace(this.context.spaceId);
            this.context.spaceWrapper.set(space);
        }
    }

    class Rx {
        Rx() {
        }
    }

    class Async {
        Async() {
        }
    }
}

