/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.Constants;
import com.contentful.java.cda.SpaceWrapper;
import com.contentful.java.cda.model.CDAAsset;
import com.contentful.java.cda.model.CDAContentType;
import com.contentful.java.cda.model.CDAEntry;
import com.contentful.java.cda.model.CDALocale;
import com.contentful.java.cda.model.CDAResource;
import com.contentful.java.cda.model.CDASpace;
import com.contentful.java.cda.model.ResourceWithList;
import com.contentful.java.cda.model.ResourceWithMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceTypeAdapter
implements JsonDeserializer<CDAResource> {
    private final SpaceWrapper spaceWrapper;
    private final Map<String, Class<?>> customTypesMap;
    private final String httpScheme;

    public ResourceTypeAdapter(SpaceWrapper spaceWrapper, Map<String, Class<?>> customTypesMap, String httpScheme) {
        this.spaceWrapper = spaceWrapper;
        this.customTypesMap = customTypesMap;
        this.httpScheme = httpScheme;
    }

    public CDAResource deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        CDAResource result = null;
        JsonObject sys = jsonElement.getAsJsonObject().getAsJsonObject("sys");
        if (sys != null) {
            Constants.CDAResourceType resourceType = Constants.CDAResourceType.valueOf(sys.get("type").getAsString());
            result = Constants.CDAResourceType.Asset.equals((Object)resourceType) ? this.deserializeAsset(jsonElement, context, sys) : (Constants.CDAResourceType.Entry.equals((Object)resourceType) ? this.deserializeEntry(jsonElement, context, sys) : (Constants.CDAResourceType.ContentType.equals((Object)resourceType) ? this.deserializeContentType(jsonElement, context, sys) : (Constants.CDAResourceType.Space.equals((Object)resourceType) ? this.deserializeSpace(jsonElement, context, sys) : this.deserializeResource(jsonElement, context, sys))));
        }
        return result;
    }

    private CDAResource deserializeResource(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        CDAResource result = new CDAResource();
        this.setBaseFields(result, sys, jsonElement, context);
        return result;
    }

    private CDAAsset deserializeAsset(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        Map fileMap;
        CDAAsset result = new CDAAsset();
        this.setBaseFields(result, sys, jsonElement, context);
        Map fields = result.getFields();
        if (fields != null && (fileMap = (Map)fields.get("file")) != null) {
            Object map;
            String defaultLocale = this.spaceWrapper.get().getDefaultLocale();
            if (fileMap.containsKey(defaultLocale) && (map = fileMap.get(defaultLocale)) instanceof Map) {
                fileMap = (Map)map;
            }
            result.setUrl(String.format("%s:%s", this.httpScheme, fileMap.get("url")));
            result.setMimeType((String)fileMap.get("contentType"));
        }
        return result;
    }

    private CDAContentType deserializeContentType(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        JsonObject attrs = jsonElement.getAsJsonObject();
        String displayField = this.getFieldAsString(attrs, "displayField");
        String name = this.getFieldAsString(attrs, "name");
        String userDescription = this.getFieldAsString(attrs, "description");
        CDAContentType result = new CDAContentType(displayField, name, userDescription);
        this.setBaseFields(result, sys, jsonElement, context);
        return result;
    }

    private CDAEntry deserializeEntry(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        CDAEntry result;
        String contentTypeId = sys.get("contentType").getAsJsonObject().get("sys").getAsJsonObject().get("id").getAsString();
        Class<?> clazz = this.customTypesMap.get(contentTypeId);
        if (clazz == null) {
            result = new CDAEntry();
        } else {
            try {
                result = (CDAEntry)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new JsonParseException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
        this.setBaseFields(result, sys, jsonElement, context);
        return result;
    }

    private CDASpace deserializeSpace(JsonElement jsonElement, JsonDeserializationContext context, JsonObject sys) {
        String name = jsonElement.getAsJsonObject().get("name").getAsString();
        JsonArray localesArray = jsonElement.getAsJsonObject().get("locales").getAsJsonArray();
        Type t = new TypeToken<ArrayList<CDALocale>>(){}.getType();
        ArrayList locales = (ArrayList)context.deserialize((JsonElement)localesArray, t);
        String defaultLocale = "en-US";
        for (CDALocale l : locales) {
            if (!l.isDefault()) continue;
            defaultLocale = l.getCode();
            break;
        }
        CDASpace result = new CDASpace(defaultLocale, locales, name);
        this.setBaseFields(result, sys, jsonElement, context);
        return result;
    }

    private void setBaseFields(CDAResource target, JsonObject sys, JsonElement jsonElement, JsonDeserializationContext context) {
        CDASpace space = this.spaceWrapper.get();
        Map sysMap = (Map)context.deserialize((JsonElement)sys, Map.class);
        if (sysMap.containsKey("space")) {
            sysMap.put("space", space);
        }
        target.setSys(sysMap);
        JsonElement fields = jsonElement.getAsJsonObject().get("fields");
        if (target instanceof ResourceWithMap) {
            Map fieldsMap = fields == null ? Collections.emptyMap() : (Map)context.deserialize((JsonElement)fields.getAsJsonObject(), Map.class);
            ResourceWithMap res = (ResourceWithMap)target;
            target.setLocale(space.getDefaultLocale());
            res.setRawFields(fieldsMap);
            res.getLocalizedFieldsMap().put(space.getDefaultLocale(), fieldsMap);
        } else if (target instanceof ResourceWithList) {
            List fieldsList = fields == null ? Collections.emptyList() : (List)context.deserialize((JsonElement)fields.getAsJsonArray(), List.class);
            ((ResourceWithList)target).setFields(fieldsList);
        }
    }

    private String getFieldAsString(JsonObject jsonObject, String name) {
        JsonElement value = jsonObject.get(name);
        if (value != null) {
            return value.getAsString();
        }
        return null;
    }
}

