/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.concurrent.Executor;

class Utils {
    static final Decoder DECODER = new Decoder(){

        public String decode(String url) throws UnsupportedEncodingException {
            return URLDecoder.decode(url, "UTF-8");
        }
    };

    private Utils() {
        throw new UnsupportedOperationException();
    }

    static void assertNotNull(Object object, String param) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s may not be null.", param));
        }
    }

    static String getQueryParamFromUrl(String url, String param) {
        return Utils.getQueryParamFromUrl(url, param, DECODER);
    }

    static String getQueryParamFromUrl(String url, String param, Decoder decoder) {
        String[] pairs;
        URI uri = URI.create(url);
        String query = uri.getQuery();
        if (query == null) {
            return null;
        }
        for (String pair : pairs = query.split("&")) {
            String[] split = pair.split("=");
            if (split.length != 2 || !param.equalsIgnoreCase(split[0])) continue;
            try {
                return decoder.decode(split[1]);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static class SynchronousExecutor
    implements Executor {
        SynchronousExecutor() {
        }

        public void execute(Runnable runnable) {
            runnable.run();
        }
    }

    static interface Decoder {
        public String decode(String var1) throws UnsupportedEncodingException;
    }
}

