/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDASpace;
import com.contentful.java.cda.CDAType;
import com.contentful.java.cda.DeletedResource;
import com.squareup.okhttp.HttpUrl;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

final class Util {
    private Util() {
        throw new AssertionError();
    }

    static <T> T checkNotNull(T reference, String format, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(String.format(format, args));
        }
        return reference;
    }

    static void checkState(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(String.format(format, args));
        }
    }

    static void checkArgument(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    static String resourcePath(Class<? extends CDAResource> clazz) {
        if (CDAAsset.class.equals(clazz)) {
            return "assets";
        }
        if (CDAContentType.class.equals(clazz)) {
            return "content_types";
        }
        if (CDAEntry.class.equals(clazz)) {
            return "entries";
        }
        throw new IllegalArgumentException("Invalid type specified: " + clazz.getName());
    }

    static Class<? extends CDAResource> classForType(CDAType type) {
        if (CDAType.ASSET.equals((Object)type)) {
            return CDAAsset.class;
        }
        if (CDAType.CONTENTTYPE.equals((Object)type)) {
            return CDAContentType.class;
        }
        if (CDAType.ENTRY.equals((Object)type)) {
            return CDAEntry.class;
        }
        if (CDAType.SPACE.equals((Object)type)) {
            return CDASpace.class;
        }
        if (CDAType.DELETEDASSET.equals((Object)type) || CDAType.DELETEDENTRY.equals((Object)type)) {
            return DeletedResource.class;
        }
        throw new IllegalArgumentException("Invalid type provided: " + (Object)((Object)type));
    }

    static CDAType typeForClass(Class<? extends CDAResource> clazz) {
        if (CDAAsset.class.equals(clazz)) {
            return CDAType.ASSET;
        }
        if (CDAContentType.class.equals(clazz)) {
            return CDAType.CONTENTTYPE;
        }
        if (CDAEntry.class.equals(clazz)) {
            return CDAType.ENTRY;
        }
        if (CDASpace.class.equals(clazz)) {
            return CDAType.SPACE;
        }
        throw new IllegalArgumentException("Invalid class provided: " + clazz.getName());
    }

    static <T> T extractNested(Map<?, ?> source, String ... keys) {
        Map curr = source;
        for (int i = 0; i < keys.length; ++i) {
            if (i == keys.length - 1) {
                return (T)curr.get(keys[i]);
            }
            if ((curr = (Map)curr.get(keys[i])) == null) break;
        }
        return null;
    }

    static String getProperty(String name) {
        Properties properties = new Properties();
        try {
            properties.load(Util.class.getClassLoader().getResourceAsStream("contentful_cda.properties"));
            String value = properties.getProperty(name);
            Util.checkNotNull(properties, "Properties file contains no version number.", new Object[0]);
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from properties file.", e);
        }
    }

    static String queryParam(String url, String name) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            return null;
        }
        return httpUrl.queryParameter(name);
    }
}

